/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.resource;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.URIQueryParameters;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.Resource;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.resource.AbstractResourceCollection;
import net.sf.saxon.resource.MetadataResource;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarCollection
extends AbstractResourceCollection {
    private XPathContext context;
    private String collectionURI;
    private SpaceStrippingRule whitespaceRules;

    public JarCollection(XPathContext context, String collectionURI, URIQueryParameters params) {
        super(context.getConfiguration());
        this.context = context;
        this.collectionURI = collectionURI;
        this.params = params;
    }

    @Override
    public boolean stripWhitespace(SpaceStrippingRule rules) {
        this.whitespaceRules = rules;
        return true;
    }

    @Override
    public String getCollectionURI() {
        return this.collectionURI;
    }

    @Override
    public Iterator<String> getResourceURIs(XPathContext context) throws XPathException {
        FilenameFilter filter2 = null;
        boolean recurse = false;
        if (this.params != null) {
            Boolean r;
            FilenameFilter f = this.params.getFilenameFilter();
            if (f != null) {
                filter2 = f;
            }
            if ((r = this.params.getRecurse()) != null) {
                recurse = r;
            }
        }
        ZipInputStream zipInputStream = this.getZipInputStream();
        ArrayList<String> result2 = new ArrayList<String>();
        try {
            ZipEntry entry2;
            String dirStr = "";
            while ((entry2 = zipInputStream.getNextEntry()) != null) {
                if (entry2.isDirectory()) {
                    dirStr = entry2.getName();
                }
                if (!entry2.isDirectory()) {
                    String entryName = entry2.getName();
                    if (filter2 != null) {
                        if (dirStr.equals("") || !entryName.contains(dirStr)) {
                            dirStr = entryName.contains("/") ? entryName.substring(0, entryName.lastIndexOf("/")) : "";
                        }
                        if (filter2.accept(new File(dirStr), entryName)) {
                            result2.add(this.makeResourceURI(entryName));
                        }
                    } else {
                        result2.add(this.makeResourceURI(entryName));
                    }
                }
                entry2 = zipInputStream.getNextEntry();
            }
        }
        catch (IOException e) {
            throw new XPathException("Unable to extract entry in JAR/ZIP file: " + this.collectionURI, e);
        }
        return result2.iterator();
    }

    private ZipInputStream getZipInputStream() throws XPathException {
        InputStream stream;
        URLConnection connection;
        URL url;
        try {
            url = new URL(this.collectionURI);
        }
        catch (MalformedURLException e) {
            throw new XPathException("Malformed JAR/ZIP file URI: " + this.collectionURI, e);
        }
        try {
            connection = url.openConnection();
        }
        catch (IOException e) {
            throw new XPathException("Unable to open connection to JAR/ZIP file URI: " + this.collectionURI, e);
        }
        try {
            stream = connection.getInputStream();
        }
        catch (IOException e) {
            throw new XPathException("Unable to get input stream for JAR/ZIP file connection: " + this.collectionURI, e);
        }
        return new ZipInputStream(stream);
    }

    public Iterator<Resource> getResources(XPathContext context) throws XPathException {
        FilenameFilter filter2 = null;
        boolean recurse = false;
        if (this.params != null) {
            Boolean r;
            FilenameFilter f = this.params.getFilenameFilter();
            if (f != null) {
                filter2 = f;
            }
            if ((r = this.params.getRecurse()) != null) {
                recurse = r;
            }
        }
        ZipInputStream zipInputStream = this.getZipInputStream();
        return new JarIterator(this.context, zipInputStream, filter2);
    }

    private String makeResourceURI(String entryName) {
        return (this.collectionURI.startsWith("jar:") ? "" : "jar:") + this.collectionURI + "!/" + entryName;
    }

    protected Map<String, Sequence> makeProperties(ZipEntry entry2) {
        HashMap<String, Sequence> map2 = new HashMap<String, Sequence>(10);
        map2.put("comment", StringValue.makeStringValue(entry2.getComment()));
        map2.put("compressed-size", new Int64Value(entry2.getCompressedSize()));
        map2.put("crc", new Int64Value(entry2.getCrc()));
        byte[] extra = entry2.getExtra();
        if (extra != null) {
            map2.put("extra", new Base64BinaryValue(extra));
        }
        map2.put("compression-method", new Int64Value(entry2.getMethod()));
        map2.put("entry-name", StringValue.makeStringValue(entry2.getName()));
        map2.put("size", new Int64Value(entry2.getSize()));
        try {
            map2.put("last-modified", DateTimeValue.fromJavaTime(entry2.getTime()));
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
        return map2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JarIterator
    implements Iterator<Resource> {
        private FilenameFilter filter;
        private Resource next = null;
        private XPathContext context;
        private ZipInputStream zipInputStream;
        private String dirStr = "";
        private ParseOptions options;
        private boolean metadata;

        public JarIterator(XPathContext context, ZipInputStream zipInputStream, FilenameFilter filter2) throws XPathException {
            this.context = context;
            this.filter = filter2;
            this.zipInputStream = zipInputStream;
            this.options = JarCollection.this.optionsFromQueryParameters(JarCollection.this.params, context);
            this.options.setSpaceStrippingRule(JarCollection.this.whitespaceRules);
            Boolean metadataParam = JarCollection.this.params == null ? null : JarCollection.this.params.getMetaData();
            this.metadata = metadataParam != null && metadataParam != false;
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Resource next() {
            Resource current = this.next;
            this.advance();
            return current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void advance() {
            while (true) {
                ZipEntry entry2;
                try {
                    entry2 = this.zipInputStream.getNextEntry();
                    if (entry2 == null) {
                        this.next = null;
                        return;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
                if (entry2.isDirectory()) {
                    this.dirStr = entry2.getName();
                    continue;
                }
                String entryName = entry2.getName();
                if (this.filter != null) {
                    if (this.dirStr.equals("") || !entryName.contains(this.dirStr)) {
                        this.dirStr = entryName.contains("/") ? entryName.substring(0, entryName.lastIndexOf("/")) : "";
                    }
                    if (!this.filter.accept(new File(this.dirStr), entryName)) continue;
                }
                try {
                    ZipInputStream is = this.zipInputStream;
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    try {
                        byte[] buffer = new byte[4096];
                        int len = 0;
                        while ((len = ((InputStream)is).read(buffer)) > 0) {
                            output.write(buffer, 0, len);
                        }
                    }
                    catch (IOException err2) {
                        err2.printStackTrace();
                    }
                    finally {
                        try {
                            output.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    ByteArrayInputStream entryContent = new ByteArrayInputStream(output.toByteArray());
                    AbstractResourceCollection.InputDetails details = new AbstractResourceCollection.InputDetails();
                    details.inputStream = entryContent;
                    details.contentType = JarCollection.this.guessContentType(entry2.getName(), entryContent);
                    details.parseOptions = this.options;
                    String resourceURI = JarCollection.this.makeResourceURI(entry2.getName());
                    this.next = JarCollection.this.makeResource(this.context.getConfiguration(), details, resourceURI);
                    if (this.metadata) {
                        Map<String, Sequence> properties = JarCollection.this.makeProperties(entry2);
                        this.next = new MetadataResource(resourceURI, this.next, properties);
                    }
                    return;
                }
                catch (XPathException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

