/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.resource;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.Resource;
import net.sf.saxon.lib.ResourceFactory;
import net.sf.saxon.om.Item;
import net.sf.saxon.resource.AbstractResourceCollection;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Base64BinaryValue;

public class BinaryResource
implements Resource {
    private String href = null;
    private String contentType = null;
    private byte[] data;
    private URLConnection connection = null;
    private InputStream inputStream = null;
    public static final ResourceFactory FACTORY = new ResourceFactory(){

        public Resource makeResource(Configuration config, String resourceURI, String contentType, AbstractResourceCollection.InputDetails details) throws XPathException {
            return new BinaryResource(resourceURI, contentType, details.inputStream);
        }
    };

    public BinaryResource(String href, String contentType, InputStream in) {
        this.contentType = contentType;
        this.href = href;
        this.inputStream = in;
    }

    public void setData(byte[] data2) {
        this.data = data2;
    }

    public String getResourceURI() {
        return this.href;
    }

    private byte[] readBinaryFromConn(URLConnection con) throws XPathException {
        InputStream raw2 = null;
        this.connection = con;
        try {
            int offset;
            raw2 = this.connection.getInputStream();
            int contentLength = this.connection.getContentLength();
            BufferedInputStream in = new BufferedInputStream(raw2);
            byte[] data2 = new byte[contentLength];
            int bytesRead = 0;
            for (offset = 0; offset < contentLength && (bytesRead = ((InputStream)in).read(data2, offset, data2.length - offset)) != -1; offset += bytesRead) {
            }
            ((InputStream)in).close();
            if (offset != contentLength) {
                throw new XPathException("Only read " + offset + " bytes; Expected " + contentLength + " bytes");
            }
            return data2;
        }
        catch (IOException e) {
            throw new XPathException(e);
        }
    }

    public static byte[] readBinaryFromStream(InputStream in, String path) throws XPathException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data2 = new byte[16384];
        try {
            int nRead;
            while ((nRead = in.read(data2, 0, data2.length)) != -1) {
                buffer.write(data2, 0, nRead);
            }
            buffer.flush();
            return buffer.toByteArray();
        }
        catch (IOException e) {
            throw new XPathException("Failed to read: " + path + " " + e);
        }
    }

    public Item getItem(XPathContext context) throws XPathException {
        if (this.data != null) {
            return new Base64BinaryValue(this.data);
        }
        if (this.connection != null) {
            this.data = this.readBinaryFromConn(this.connection);
            return new Base64BinaryValue(this.data);
        }
        if (this.inputStream != null) {
            this.data = BinaryResource.readBinaryFromStream(this.inputStream, this.href);
            return new Base64BinaryValue(this.data);
        }
        return null;
    }

    public String getContentType() {
        return this.contentType;
    }
}

