/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import java.util.List;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.regex.ARegexIterator;
import net.sf.saxon.regex.ATokenIterator;
import net.sf.saxon.regex.RECompiler;
import net.sf.saxon.regex.REFlags;
import net.sf.saxon.regex.REMatcher;
import net.sf.saxon.regex.REProgram;
import net.sf.saxon.regex.RESyntaxException;
import net.sf.saxon.regex.RegexIterator;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ARegularExpression
implements RegularExpression {
    UnicodeString rawPattern;
    String rawFlags;
    REProgram regex;

    public ARegularExpression(CharSequence pattern, String flags, String hostLanguage, List<String> warnings) throws XPathException {
        REFlags reFlags;
        this.rawFlags = flags;
        try {
            reFlags = new REFlags(flags, hostLanguage);
        }
        catch (RESyntaxException err2) {
            throw new XPathException(err2.getMessage(), "FORX0001");
        }
        try {
            this.rawPattern = UnicodeString.makeUnicodeString(pattern);
            RECompiler comp2 = new RECompiler();
            comp2.setFlags(reFlags);
            this.regex = comp2.compile(this.rawPattern);
            if (warnings != null) {
                for (String s2 : comp2.getWarnings()) {
                    warnings.add(s2);
                }
            }
        }
        catch (RESyntaxException err3) {
            throw new XPathException(err3.getMessage(), "FORX0002");
        }
    }

    @Override
    public boolean matches(CharSequence input2) {
        if (StringValue.isEmpty(input2) && this.regex.isNullable()) {
            return true;
        }
        REMatcher matcher = new REMatcher(this.regex);
        return matcher.anchoredMatch(UnicodeString.makeUnicodeString(input2));
    }

    @Override
    public boolean containsMatch(CharSequence input2) {
        REMatcher matcher = new REMatcher(this.regex);
        return matcher.match(UnicodeString.makeUnicodeString(input2), 0);
    }

    @Override
    public SequenceIterator tokenize(CharSequence input2) {
        return new ATokenIterator(UnicodeString.makeUnicodeString(input2), new REMatcher(this.regex));
    }

    @Override
    public RegexIterator analyze(CharSequence input2) {
        return new ARegexIterator(UnicodeString.makeUnicodeString(input2), this.rawPattern, new REMatcher(this.regex));
    }

    @Override
    public CharSequence replace(CharSequence input2, CharSequence replacement) throws XPathException {
        REMatcher matcher = new REMatcher(this.regex);
        UnicodeString in = UnicodeString.makeUnicodeString(input2);
        UnicodeString rep2 = UnicodeString.makeUnicodeString(replacement);
        try {
            return matcher.replace(in, rep2);
        }
        catch (RESyntaxException err2) {
            throw new XPathException(err2.getMessage(), "FORX0004");
        }
    }

    @Override
    public String getFlags() {
        return this.rawFlags;
    }
}

