/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.GlobalVariableReference;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.GlobalContextRequirement;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.SavedNamespaceContext;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.CodeInjector;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.functions.registry.BuiltInFunctionSet;
import net.sf.saxon.functions.registry.ConstructorFunctionLibrary;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameParser;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.Declaration;
import net.sf.saxon.query.ImportedFunctionLibrary;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.UnboundFunctionLibrary;
import net.sf.saxon.query.UndeclaredVariable;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionLibrary;
import net.sf.saxon.query.XQueryParser;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trace.TraceCodeInjector;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaComponentVisitor;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryModule
implements StaticContext {
    private boolean isMainModule;
    private Configuration config;
    private StaticQueryContext userQueryContext;
    private QueryModule topModule;
    private URI locationURI;
    private String baseURI;
    private String moduleNamespace;
    private HashMap<String, String> explicitPrologNamespaces;
    private Stack<ActiveNamespace> activeNamespaces;
    private HashMap<StructuredQName, GlobalVariable> variables;
    private HashMap<StructuredQName, GlobalVariable> libraryVariables;
    private HashMap<StructuredQName, UndeclaredVariable> undeclaredVariables;
    private HashSet<String> importedSchemata;
    private HashMap<String, HashSet<String>> loadedSchemata;
    private Executable executable;
    private List<QueryModule> importers;
    private FunctionLibraryList functionLibraryList;
    private XQueryFunctionLibrary globalFunctionLibrary;
    private int localFunctionLibraryNr;
    private int importedFunctionLibraryNr;
    private int unboundFunctionLibraryNr;
    private Set<String> importedModuleNamespaces;
    private boolean inheritNamespaces = true;
    private boolean preserveNamespaces = true;
    private int constructionMode = 3;
    private String defaultFunctionNamespace;
    private String defaultElementNamespace;
    private boolean preserveSpace = false;
    private boolean defaultEmptyLeast = true;
    private String defaultCollationName;
    private int revalidationMode = 4;
    private boolean isUpdating = false;
    private ItemType requiredContextItemType = AnyItemType.getInstance();
    private DecimalFormatManager decimalFormatManager = null;
    private CodeInjector codeInjector;
    private PackageData packageData;
    private RetainedStaticContext moduleStaticContext = null;
    private Location moduleLocation;

    public QueryModule(StaticQueryContext sqc) throws XPathException {
        this.config = sqc.getConfiguration();
        this.isMainModule = true;
        this.topModule = this;
        this.activeNamespaces = new Stack();
        this.baseURI = sqc.getBaseURI();
        this.defaultCollationName = sqc.getDefaultCollationName();
        try {
            this.locationURI = this.baseURI == null ? null : new URI(this.baseURI);
        }
        catch (URISyntaxException err2) {
            throw new XPathException("Invalid location URI: " + this.baseURI);
        }
        this.executable = sqc.makeExecutable();
        this.importers = null;
        this.init(sqc);
        PackageData pd = new PackageData(this.config);
        pd.setHostLanguage(51);
        pd.setSchemaAware(this.isSchemaAware());
        this.packageData = pd;
        Iterator<GlobalVariable> vars = sqc.iterateDeclaredGlobalVariables();
        while (vars.hasNext()) {
            GlobalVariable var = vars.next();
            this.declareVariable(var);
            pd.addGlobalVariable(var);
            var.setPackageData(pd);
        }
        this.executable.setTopLevelPackage(pd);
        this.executable.addPackage(pd);
        this.moduleLocation = sqc.getModuleLocation() == null ? new ExplicitLocation(sqc.getSystemId(), 1, -1) : sqc.getModuleLocation();
    }

    public QueryModule(Configuration config, QueryModule importer) {
        this.config = config;
        this.importers = null;
        if (importer == null) {
            this.topModule = this;
        } else {
            this.topModule = importer.topModule;
            this.userQueryContext = importer.userQueryContext;
            this.importers = new ArrayList<QueryModule>(2);
            this.importers.add(importer);
        }
        this.init(this.userQueryContext);
        this.packageData = importer.getPackageData();
        this.activeNamespaces = new Stack();
        this.executable = null;
    }

    private void init(StaticQueryContext sqc) {
        this.userQueryContext = sqc;
        this.variables = new HashMap(10);
        this.undeclaredVariables = new HashMap(5);
        if (this.isTopLevelModule()) {
            this.libraryVariables = new HashMap(10);
        }
        this.importedSchemata = new HashSet(5);
        this.importedModuleNamespaces = new HashSet<String>(5);
        this.moduleNamespace = null;
        this.activeNamespaces = new Stack();
        this.explicitPrologNamespaces = new HashMap(10);
        if (sqc != null) {
            this.inheritNamespaces = sqc.isInheritNamespaces();
            this.preserveNamespaces = sqc.isPreserveNamespaces();
            this.preserveSpace = sqc.isPreserveBoundarySpace();
            this.defaultEmptyLeast = sqc.isEmptyLeast();
            this.defaultFunctionNamespace = sqc.getDefaultFunctionNamespace();
            this.defaultElementNamespace = sqc.getDefaultElementNamespace();
            this.defaultCollationName = sqc.getDefaultCollationName();
            this.constructionMode = sqc.getConstructionMode();
            if (this.constructionMode == 3 && !sqc.isSchemaAware()) {
                this.constructionMode = 4;
            }
            this.requiredContextItemType = sqc.getRequiredContextItemType();
            this.isUpdating = sqc.isUpdatingEnabled();
            this.codeInjector = sqc.getCodeInjector();
        }
        this.initializeFunctionLibraries(sqc);
    }

    public static QueryModule makeQueryModule(String baseURI, Executable executable, QueryModule importer, String query, String namespaceURI) throws XPathException {
        Configuration config = executable.getConfiguration();
        QueryModule module = new QueryModule(config, importer);
        try {
            module.setLocationURI(new URI(baseURI));
        }
        catch (URISyntaxException e) {
            throw new XPathException("Invalid location URI " + baseURI, e);
        }
        module.setBaseURI(baseURI);
        module.setExecutable(executable);
        module.setModuleNamespace(namespaceURI);
        executable.addQueryLibraryModule(module);
        XQueryParser qp = (XQueryParser)config.newExpressionParser("XQ", importer.isUpdating(), 31);
        if (importer.getCodeInjector() != null) {
            qp.setCodeInjector(importer.getCodeInjector());
        } else if (config.isCompileWithTracing()) {
            qp.setCodeInjector(new TraceCodeInjector());
        }
        QNameParser qnp = new QNameParser(module.getLiveNamespaceResolver());
        qnp.setAcceptEQName(importer.getXPathVersion() >= 30);
        qnp.setUnescaper(new XQueryParser.Unescaper(config.getValidCharacterChecker()));
        qp.setQNameParser(qnp);
        qp.parseLibraryModule(query, module);
        String namespace = module.getModuleNamespace();
        if (namespace == null) {
            XPathException err2 = new XPathException("Imported module must be a library module");
            err2.setErrorCode("XQST0059");
            err2.setIsStaticError(true);
            throw err2;
        }
        if (!namespace.equals(namespaceURI)) {
            XPathException err3 = new XPathException("Imported module's namespace does not match requested namespace");
            err3.setErrorCode("XQST0059");
            err3.setIsStaticError(true);
            throw err3;
        }
        return module;
    }

    private void initializeFunctionLibraries(StaticQueryContext sqc) {
        Configuration config = this.getConfiguration();
        if (this.isTopLevelModule()) {
            this.globalFunctionLibrary = new XQueryFunctionLibrary(config);
        }
        this.functionLibraryList = new FunctionLibraryList();
        this.functionLibraryList.addFunctionLibrary(this.getBuiltInFunctionSet());
        this.functionLibraryList.addFunctionLibrary(config.getBuiltInExtensionLibraryList());
        this.functionLibraryList.addFunctionLibrary(new ConstructorFunctionLibrary(config));
        this.localFunctionLibraryNr = this.functionLibraryList.addFunctionLibrary(new XQueryFunctionLibrary(config));
        this.importedFunctionLibraryNr = this.functionLibraryList.addFunctionLibrary(new ImportedFunctionLibrary(this, this.getTopLevelModule().getGlobalFunctionLibrary()));
        if (sqc != null && sqc.getExtensionFunctionLibrary() != null) {
            this.functionLibraryList.addFunctionLibrary(sqc.getExtensionFunctionLibrary());
        }
        this.functionLibraryList.addFunctionLibrary(config.getIntegratedFunctionLibrary());
        config.addExtensionBinders(this.functionLibraryList);
        this.unboundFunctionLibraryNr = this.functionLibraryList.addFunctionLibrary(new UnboundFunctionLibrary());
    }

    public BuiltInFunctionSet getBuiltInFunctionSet() {
        if (this.isUpdating()) {
            return this.config.getXQueryUpdateFunctionSet();
        }
        return this.config.getXPath31FunctionSet();
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public PackageData getPackageData() {
        return this.packageData;
    }

    public void setPackageData(PackageData packageData) {
        this.packageData = packageData;
    }

    public boolean isTopLevelModule() {
        return this == this.topModule;
    }

    public void setIsMainModule(boolean main2) {
        this.isMainModule = main2;
    }

    public boolean isMainModule() {
        return this.isMainModule;
    }

    public boolean mayImportModule(String namespace) {
        if (namespace.equals(this.moduleNamespace)) {
            return false;
        }
        if (this.importers == null) {
            return true;
        }
        for (QueryModule importer : this.importers) {
            if (importer.mayImportModule(namespace)) continue;
            return false;
        }
        return true;
    }

    public boolean isSchemaAware() {
        return this.executable.isSchemaAware();
    }

    @Override
    public RetainedStaticContext makeRetainedStaticContext() {
        if (this.activeNamespaces.empty()) {
            if (this.moduleStaticContext == null) {
                this.moduleStaticContext = new RetainedStaticContext(this);
            }
            return this.moduleStaticContext;
        }
        return new RetainedStaticContext(this);
    }

    public void setInheritNamespaces(boolean inherit) {
        this.inheritNamespaces = inherit;
    }

    public boolean isInheritNamespaces() {
        return this.inheritNamespaces;
    }

    public void setPreserveNamespaces(boolean inherit) {
        this.preserveNamespaces = inherit;
    }

    public boolean isPreserveNamespaces() {
        return this.preserveNamespaces;
    }

    public void setConstructionMode(int mode) {
        this.constructionMode = mode;
    }

    public int getConstructionMode() {
        return this.constructionMode;
    }

    public void setPreserveBoundarySpace(boolean preserve) {
        this.preserveSpace = preserve;
    }

    public boolean isPreserveBoundarySpace() {
        return this.preserveSpace;
    }

    public void setEmptyLeast(boolean least) {
        this.defaultEmptyLeast = least;
    }

    public boolean isEmptyLeast() {
        return this.defaultEmptyLeast;
    }

    public XQueryFunctionLibrary getGlobalFunctionLibrary() {
        return this.globalFunctionLibrary;
    }

    public ImportedFunctionLibrary getImportedFunctionLibrary() {
        return (ImportedFunctionLibrary)this.functionLibraryList.get(this.importedFunctionLibraryNr);
    }

    public void addImportedNamespace(String uri) {
        if (this.importedModuleNamespaces == null) {
            this.importedModuleNamespaces = new HashSet<String>(5);
        }
        this.importedModuleNamespaces.add(uri);
        this.getImportedFunctionLibrary().addImportedNamespace(uri);
    }

    public boolean importsNamespace(String uri) {
        return this.importedModuleNamespaces != null && this.importedModuleNamespaces.contains(uri);
    }

    public QueryModule getTopLevelModule() {
        return this.topModule;
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    public StaticQueryContext getUserQueryContext() {
        return this.userQueryContext;
    }

    @Override
    public Location getContainingLocation() {
        return this.moduleLocation;
    }

    public void setModuleNamespace(String uri) {
        this.moduleNamespace = uri;
    }

    public String getModuleNamespace() {
        return this.moduleNamespace;
    }

    public void setLocationURI(URI uri) {
        this.locationURI = uri;
        this.moduleLocation = new ExplicitLocation(this.locationURI.toString(), 1, -1);
    }

    public URI getLocationURI() {
        return this.locationURI;
    }

    @Override
    public String getSystemId() {
        return this.locationURI == null ? null : this.locationURI.toString();
    }

    public void setBaseURI(String uri) {
        this.baseURI = uri;
    }

    @Override
    public String getStaticBaseURI() {
        return this.baseURI;
    }

    public SlotManager getGlobalStackFrameMap() {
        return this.getPackageData().getGlobalSlotManager();
    }

    public void declareVariable(GlobalVariable var) throws XPathException {
        GlobalVariable old;
        StructuredQName key = var.getVariableQName();
        if (this.variables.get(key) != null && (old = this.variables.get(key)) != var && old.getUltimateOriginalVariable() != var.getUltimateOriginalVariable()) {
            String oldloc = " (see line " + old.getLineNumber();
            String oldSysId = old.getSystemId();
            if (oldSysId != null && !oldSysId.equals(var.getSystemId())) {
                oldloc = oldloc + " in module " + old.getSystemId();
            }
            oldloc = oldloc + ")";
            XPathException err2 = new XPathException("Duplicate definition of global variable " + var.getVariableQName().getDisplayName() + oldloc);
            err2.setErrorCode("XQST0049");
            err2.setIsStaticError(true);
            err2.setLocation(var);
            throw err2;
        }
        this.variables.put(key, var);
        this.getPackageData().addGlobalVariable(var);
        HashMap<StructuredQName, GlobalVariable> libVars = this.getTopLevelModule().libraryVariables;
        GlobalVariable old2 = libVars.get(key);
        if (old2 != null && old2 != var) {
            XPathException err3 = new XPathException("Duplicate definition of global variable " + var.getVariableQName().getDisplayName() + " (see line " + old2.getLineNumber() + " in module " + old2.getSystemId() + ')');
            err3.setErrorCode("XQST0049");
            err3.setIsStaticError(true);
            err3.setLocation(var);
            throw err3;
        }
        if (!this.isMainModule()) {
            libVars.put(key, var);
        }
    }

    public Iterable<GlobalVariable> getGlobalVariables() {
        return this.libraryVariables.values();
    }

    public List<GlobalVariable> fixupGlobalVariables(SlotManager globalVariableMap) throws XPathException {
        ArrayList<GlobalVariable> varDefinitions = new ArrayList<GlobalVariable>(20);
        ArrayList<Iterator<GlobalVariable>> iters = new ArrayList<Iterator<GlobalVariable>>();
        iters.add(this.variables.values().iterator());
        iters.add(this.libraryVariables.values().iterator());
        for (Iterator iterator2 : iters) {
            while (iterator2.hasNext()) {
                GlobalVariable var = (GlobalVariable)iterator2.next();
                if (varDefinitions.contains(var)) continue;
                int slot = globalVariableMap.allocateSlotNumber(var.getVariableQName());
                var.compile(this.getExecutable(), slot);
                varDefinitions.add(var);
            }
        }
        return varDefinitions;
    }

    public void lookForModuleCycles(Stack<QueryModule> referees, int lineNumber) throws XPathException {
        String uri;
        if (referees.contains(this)) {
            int s2 = referees.indexOf(this);
            referees.push(this);
            String message = "Circular dependency between modules. ";
            for (int i = s2; i < referees.size() - 1; ++i) {
                QueryModule next2 = (QueryModule)referees.get(i + 1);
                message = i == s2 ? message + "Module " + this.getSystemId() + " references module " + next2.getSystemId() : message + ", which references module " + next2.getSystemId();
            }
            message = message + '.';
            XPathException err2 = new XPathException(message);
            err2.setErrorCode("XQST0093");
            err2.setIsStaticError(true);
            ExplicitLocation loc = new ExplicitLocation(this.getSystemId(), lineNumber, -1);
            err2.setLocator(loc);
            throw err2;
        }
        referees.push(this);
        Iterator<GlobalVariable> viter = this.getModuleVariables();
        while (viter.hasNext()) {
            GlobalVariable gv = viter.next();
            Expression select = gv.getSelectExpression();
            if (select == null) continue;
            ArrayList<Binding> list2 = new ArrayList<Binding>(10);
            ExpressionTool.gatherReferencedVariables(select, list2);
            for (Binding binding : list2) {
                QueryModule sqc;
                if (!(binding instanceof GlobalVariable)) continue;
                String uri2 = ((GlobalVariable)binding).getSystemId();
                StructuredQName qName = binding.getVariableQName();
                boolean synthetic = qName.hasURI("http://saxon.sf.net/generated-variable");
                if (synthetic || uri2 == null || uri2.equals(this.getSystemId()) || (sqc = this.executable.getQueryModuleWithSystemId(uri2, this.topModule)) == null) continue;
                sqc.lookForModuleCycles(referees, ((GlobalVariable)binding).getLineNumber());
            }
            ArrayList<UserFunction> fList = new ArrayList<UserFunction>(5);
            ExpressionTool.gatherCalledFunctions(select, fList);
            for (UserFunction f : fList) {
                QueryModule sqc;
                uri = f.getSystemId();
                if (uri == null || uri.equals(this.getSystemId()) || (sqc = this.executable.getQueryModuleWithSystemId(uri, this.topModule)) == null) continue;
                sqc.lookForModuleCycles(referees, f.getLineNumber());
            }
        }
        Iterator<XQueryFunction> fiter = this.getLocalFunctionLibrary().getFunctionDefinitions();
        while (fiter.hasNext()) {
            XQueryFunction gf = fiter.next();
            Expression body = gf.getUserFunction().getBody();
            if (body == null) continue;
            ArrayList<Binding> vList = new ArrayList<Binding>(10);
            ExpressionTool.gatherReferencedVariables(body, vList);
            for (Binding b : vList) {
                QueryModule sqc;
                if (!(b instanceof GlobalVariable)) continue;
                uri = ((GlobalVariable)b).getSystemId();
                StructuredQName qName = b.getVariableQName();
                boolean synthetic = qName.hasURI("http://saxon.sf.net/") && "gg".equals(qName.getPrefix());
                if (synthetic || uri == null || uri.equals(this.getSystemId()) || (sqc = this.executable.getQueryModuleWithSystemId(uri, this.topModule)) == null) continue;
                sqc.lookForModuleCycles(referees, ((GlobalVariable)b).getLineNumber());
            }
            ArrayList<UserFunction> arrayList = new ArrayList<UserFunction>(10);
            ExpressionTool.gatherCalledFunctions(body, arrayList);
            for (UserFunction f : arrayList) {
                QueryModule sqc;
                String uri3 = f.getSystemId();
                if (uri3 == null || uri3.equals(this.getSystemId()) || (sqc = this.executable.getQueryModuleWithSystemId(uri3, this.topModule)) == null) continue;
                sqc.lookForModuleCycles(referees, f.getLineNumber());
            }
        }
        referees.pop();
    }

    public Iterator<GlobalVariable> getModuleVariables() {
        return this.variables.values().iterator();
    }

    public void checkForCircularities(List<GlobalVariable> compiledVars, XQueryFunctionLibrary globalFunctionLibrary) throws XPathException {
        Iterator<GlobalVariable> iter2 = compiledVars.iterator();
        Stack<Object> stack = null;
        while (iter2.hasNext()) {
            GlobalVariable gv;
            if (stack == null) {
                stack = new Stack<Object>();
            }
            if ((gv = iter2.next()) == null) continue;
            gv.lookForCycles(stack, globalFunctionLibrary);
        }
    }

    public void typeCheckGlobalVariables(List<GlobalVariable> compiledVars) throws XPathException {
        GlobalContextRequirement gcr;
        ExpressionVisitor visitor = ExpressionVisitor.make(this);
        for (GlobalVariable compiledVar : compiledVars) {
            compiledVar.typeCheck(visitor);
        }
        if (this.isMainModule() && (gcr = this.executable.getGlobalContextRequirement()) != null && gcr.getDefaultValue() != null) {
            ContextItemStaticInfo info = this.getConfiguration().makeContextItemStaticInfo(AnyItemType.getInstance(), true);
            gcr.setDefaultValue(gcr.getDefaultValue().typeCheck(visitor, info));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Expression bindVariable(StructuredQName qName) throws XPathException {
        GlobalVariable var = this.variables.get(qName);
        if (var == null) {
            String uri = qName.getURI();
            if (!(uri.equals("") && this.isMainModule() || uri.equals(this.moduleNamespace) || this.importsNamespace(uri))) {
                XPathException err2 = new XPathException("Variable $" + qName.getDisplayName() + " has not been declared");
                err2.setErrorCode("XPST0008");
                err2.setIsStaticError(true);
                throw err2;
            }
            QueryModule main2 = this.getTopLevelModule();
            var = main2.libraryVariables.get(qName);
            if (var == null) {
                UndeclaredVariable uvar = this.undeclaredVariables.get(qName);
                if (uvar != null) {
                    GlobalVariableReference ref = new GlobalVariableReference(qName);
                    uvar.registerReference(ref);
                    return ref;
                }
                uvar = new UndeclaredVariable();
                uvar.setPackageData(main2.getPackageData());
                uvar.setVariableQName(qName);
                GlobalVariableReference ref = new GlobalVariableReference(qName);
                uvar.registerReference(ref);
                this.undeclaredVariables.put(qName, uvar);
                return ref;
            }
            if (var.isPrivate()) {
                XPathException err3 = new XPathException("Variable $" + qName.getDisplayName() + " is private");
                err3.setErrorCode("XPST0008");
                err3.setIsStaticError(true);
                throw err3;
            }
            this.checkImportedType(var.getRequiredType(), var);
        } else if (var.isPrivate() && (var.getSystemId() == null || !var.getSystemId().equals(this.getSystemId()))) {
            String message = "Variable $" + qName.getDisplayName() + " is private";
            if (var.getSystemId() == null) {
                message = message + " (no base URI known)";
            }
            XPathException err4 = new XPathException(message, "XPST0008");
            err4.setIsStaticError(true);
            throw err4;
        }
        GlobalVariableReference vref = new GlobalVariableReference(qName);
        var.registerReference(vref);
        return vref;
    }

    @Override
    public FunctionLibrary getFunctionLibrary() {
        return this.functionLibraryList;
    }

    public XQueryFunctionLibrary getLocalFunctionLibrary() {
        return (XQueryFunctionLibrary)this.functionLibraryList.get(this.localFunctionLibraryNr);
    }

    public void declareFunction(XQueryFunction function) throws XPathException {
        StructuredQName name;
        SchemaType t;
        Configuration config = this.getConfiguration();
        if (function.getNumberOfArguments() == 1 && (t = config.getSchemaType(name = function.getFunctionName())) != null && t.isAtomicType()) {
            XPathException err2 = new XPathException("Function name " + function.getDisplayName() + " clashes with the name of the constructor function for an atomic type");
            err2.setErrorCode("XQST0034");
            err2.setIsStaticError(true);
            throw err2;
        }
        XQueryFunctionLibrary local = this.getLocalFunctionLibrary();
        local.declareFunction(function);
        QueryModule main2 = this.getTopLevelModule();
        main2.globalFunctionLibrary.declareFunction(function);
    }

    public void bindUnboundFunctionCalls() throws XPathException {
        UnboundFunctionLibrary lib = (UnboundFunctionLibrary)this.functionLibraryList.get(this.unboundFunctionLibraryNr);
        lib.bindUnboundFunctionReferences(this.functionLibraryList, this.getConfiguration());
    }

    public void fixupGlobalFunctions() throws XPathException {
        this.globalFunctionLibrary.fixupGlobalFunctions(this);
    }

    public void optimizeGlobalFunctions() throws XPathException {
        this.globalFunctionLibrary.optimizeGlobalFunctions(this);
    }

    public void explainGlobalFunctions(ExpressionPresenter out) throws XPathException {
        this.globalFunctionLibrary.explainGlobalFunctions(out);
    }

    public UserFunction getUserDefinedFunction(String uri, String localName, int arity) {
        return this.globalFunctionLibrary.getUserDefinedFunction(uri, localName, arity);
    }

    public void bindUnboundVariables() throws XPathException {
        for (UndeclaredVariable uv : this.undeclaredVariables.values()) {
            XPathException err2;
            String uri;
            StructuredQName qName = uv.getVariableQName();
            GlobalVariable var = this.variables.get(qName);
            if (var == null && this.importsNamespace(uri = qName.getURI())) {
                QueryModule main2 = this.getTopLevelModule();
                var = main2.libraryVariables.get(qName);
            }
            if (var == null) {
                err2 = new XPathException("Unresolved reference to variable $" + uv.getVariableQName().getDisplayName());
                err2.setErrorCode("XPST0008");
                err2.setIsStaticError(true);
                throw err2;
            }
            if (var.isPrivate() && !var.getSystemId().equals(this.getSystemId())) {
                err2 = new XPathException("Cannot reference a private variable in a different module");
                err2.setErrorCode("XPST0008");
                err2.setIsStaticError(true);
                throw err2;
            }
            this.checkImportedType(var.getRequiredType(), var);
            uv.transferReferences(var);
        }
    }

    public void addImportedSchema(String targetNamespace, String baseURI, List<String> locationURIs) {
        HashSet<String> entries;
        if (this.importedSchemata == null) {
            this.importedSchemata = new HashSet(5);
        }
        this.importedSchemata.add(targetNamespace);
        HashMap<String, HashSet<String>> loadedSchemata = this.getTopLevelModule().loadedSchemata;
        if (loadedSchemata == null) {
            loadedSchemata = new HashMap(5);
            this.getTopLevelModule().loadedSchemata = loadedSchemata;
        }
        if ((entries = loadedSchemata.get(targetNamespace)) == null) {
            entries = new HashSet(locationURIs.size());
            loadedSchemata.put(targetNamespace, entries);
        }
        for (String relative : locationURIs) {
            try {
                URI abs = ResolveURI.makeAbsolute(relative, baseURI);
                entries.add(abs.toString());
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
    }

    @Override
    public boolean isImportedSchema(String namespace) {
        return this.importedSchemata != null && this.importedSchemata.contains(namespace);
    }

    @Override
    public Set<String> getImportedSchemaNamespaces() {
        if (this.importedSchemata == null) {
            return Collections.emptySet();
        }
        return this.importedSchemata;
    }

    public void reportStaticError(XPathException err2) {
        if (!err2.hasBeenReported()) {
            if (this.userQueryContext == null) {
                this.config.getErrorListener().fatalError(err2);
            } else {
                this.userQueryContext.getErrorListener().fatalError(err2);
            }
            err2.setHasBeenReported(true);
        }
    }

    public void checkImportedFunctionSignature(XQueryFunction fd) throws XPathException {
        this.checkImportedType(fd.getResultType(), fd);
        for (int a = 0; a < fd.getNumberOfArguments(); ++a) {
            SequenceType argType = fd.getArgumentTypes()[a];
            this.checkImportedType(argType, fd);
        }
    }

    public void checkImportedType(SequenceType importedType, final Declaration declaration) throws XPathException {
        ItemType type = importedType.getPrimaryType();
        type.visitNamedSchemaComponents(new SchemaComponentVisitor(){

            public void visitSchemaComponent(SchemaComponent component) throws XPathException {
                StructuredQName f;
                if (component instanceof SchemaDeclaration) {
                    StructuredQName f2 = ((SchemaDeclaration)((Object)component)).getComponentName();
                    if (f2 != null) {
                        QueryModule.this.checkSchemaNamespaceImported(f2, declaration);
                    }
                } else if (component instanceof SchemaType && (f = ((SchemaType)component).getStructuredQName()) != null) {
                    QueryModule.this.checkSchemaNamespaceImported(f, declaration);
                }
            }
        });
    }

    @Override
    public XPathContext makeEarlyEvaluationContext() {
        return new EarlyEvaluationContext(this.getConfiguration());
    }

    @Override
    public String getDefaultCollationName() {
        if (this.defaultCollationName == null) {
            this.defaultCollationName = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
        }
        return this.defaultCollationName;
    }

    public void setDefaultCollationName(String collation) {
        this.defaultCollationName = collation;
    }

    public void declarePrologNamespace(String prefix, String uri) throws XPathException {
        if (prefix == null) {
            throw new NullPointerException("Null prefix supplied to declarePrologNamespace()");
        }
        if (uri == null) {
            throw new NullPointerException("Null namespace URI supplied to declarePrologNamespace()");
        }
        if (prefix.equals("xml") != uri.equals("http://www.w3.org/XML/1998/namespace")) {
            XPathException err2 = new XPathException("Invalid declaration of the XML namespace");
            err2.setErrorCode("XQST0070");
            err2.setIsStaticError(true);
            throw err2;
        }
        if (this.explicitPrologNamespaces.get(prefix) != null) {
            XPathException err3 = new XPathException("Duplicate declaration of namespace prefix \"" + prefix + '\"');
            err3.setErrorCode("XQST0033");
            err3.setIsStaticError(true);
            throw err3;
        }
        this.explicitPrologNamespaces.put(prefix, uri);
    }

    public void declareActiveNamespace(String prefix, String uri) {
        if (prefix == null) {
            throw new NullPointerException("Null prefix supplied to declareActiveNamespace()");
        }
        if (uri == null) {
            throw new NullPointerException("Null namespace URI supplied to declareActiveNamespace()");
        }
        ActiveNamespace entry2 = new ActiveNamespace();
        entry2.prefix = prefix;
        entry2.uri = uri;
        this.activeNamespaces.push(entry2);
    }

    public void undeclareNamespace() {
        this.activeNamespaces.pop();
    }

    public NamespaceResolver getLiveNamespaceResolver() {
        return new NamespaceResolver(){

            @Override
            public String getURIForPrefix(String prefix, boolean useDefault) {
                return QueryModule.this.checkURIForPrefix(prefix);
            }

            @Override
            public Iterator<String> iteratePrefixes() {
                return QueryModule.this.getNamespaceResolver().iteratePrefixes();
            }
        };
    }

    public String checkURIForPrefix(String prefix) {
        if (this.activeNamespaces != null) {
            for (int i = this.activeNamespaces.size() - 1; i >= 0; --i) {
                if (!((ActiveNamespace)this.activeNamespaces.get((int)i)).prefix.equals(prefix)) continue;
                String uri = ((ActiveNamespace)this.activeNamespaces.get((int)i)).uri;
                if (uri.equals("") && !prefix.equals("")) {
                    return null;
                }
                return uri;
            }
        }
        if (prefix.isEmpty()) {
            return this.defaultElementNamespace;
        }
        String uri = this.explicitPrologNamespaces.get(prefix);
        if (uri != null) {
            return uri.isEmpty() ? null : uri;
        }
        if (this.userQueryContext != null) {
            uri = this.userQueryContext.getNamespaceForPrefix(prefix);
            if (uri != null) {
                return uri;
            }
            NamespaceResolver externalResolver = this.userQueryContext.getExternalNamespaceResolver();
            if (externalResolver != null) {
                return externalResolver.getURIForPrefix(prefix, true);
            }
        }
        return null;
    }

    @Override
    public String getDefaultElementNamespace() {
        return this.checkURIForPrefix("");
    }

    public void setDefaultElementNamespace(String uri) {
        this.defaultElementNamespace = uri;
    }

    @Override
    public String getDefaultFunctionNamespace() {
        return this.defaultFunctionNamespace;
    }

    public void setDefaultFunctionNamespace(String uri) {
        this.defaultFunctionNamespace = uri;
    }

    public void setRevalidationMode(int mode) {
        if (mode != 1 && mode != 2 && mode != 4) {
            throw new IllegalArgumentException("Invalid mode " + mode);
        }
        this.revalidationMode = mode;
    }

    public int getRevalidationMode() {
        return this.revalidationMode;
    }

    public NamespaceBinding[] getActiveNamespaceCodes() {
        if (this.activeNamespaces == null) {
            return NamespaceBinding.EMPTY_ARRAY;
        }
        NamespaceBinding[] nsBindings = new NamespaceBinding[this.activeNamespaces.size()];
        int used = 0;
        HashSet<String> prefixes = new HashSet<String>(10);
        for (int n = this.activeNamespaces.size() - 1; n >= 0; --n) {
            ActiveNamespace an = (ActiveNamespace)this.activeNamespaces.get(n);
            if (prefixes.contains(an.prefix)) continue;
            prefixes.add(an.prefix);
            nsBindings[used++] = new NamespaceBinding(an.prefix, an.uri);
        }
        if (used < nsBindings.length) {
            nsBindings = Arrays.copyOf(nsBindings, used);
        }
        return nsBindings;
    }

    @Override
    public NamespaceResolver getNamespaceResolver() {
        ArrayList<NamespaceBinding> externalNamespaceCodes = null;
        NamespaceResolver externalResolver = this.userQueryContext.getExternalNamespaceResolver();
        if (externalResolver != null) {
            externalNamespaceCodes = new ArrayList<NamespaceBinding>();
            Iterator<String> iter2 = externalResolver.iteratePrefixes();
            while (iter2.hasNext()) {
                String prefix = iter2.next();
                String uri = externalResolver.getURIForPrefix(prefix, true);
                NamespaceBinding nscode = new NamespaceBinding(prefix, uri);
                externalNamespaceCodes.add(nscode);
            }
        }
        HashMap<String, String> userDeclaredNamespaces = this.userQueryContext.getUserDeclaredNamespaces();
        ArrayList<NamespaceBinding> nsBindings = new ArrayList<NamespaceBinding>();
        for (Map.Entry<String, String> e : userDeclaredNamespaces.entrySet()) {
            nsBindings.add(new NamespaceBinding(e.getKey(), e.getValue()));
        }
        for (Map.Entry<String, String> e : this.explicitPrologNamespaces.entrySet()) {
            nsBindings.add(new NamespaceBinding(e.getKey(), e.getValue()));
        }
        if (this.defaultElementNamespace.length() != 0) {
            nsBindings.add(new NamespaceBinding("", this.defaultElementNamespace));
        }
        nsBindings.addAll(Arrays.asList(this.getActiveNamespaceCodes()));
        if (externalNamespaceCodes != null) {
            for (NamespaceBinding externalNamespaceCode : externalNamespaceCodes) {
                nsBindings.add(externalNamespaceCode);
            }
        }
        return new SavedNamespaceContext(nsBindings);
    }

    @Override
    public ItemType getRequiredContextItemType() {
        return this.requiredContextItemType;
    }

    @Override
    public DecimalFormatManager getDecimalFormatManager() {
        if (this.decimalFormatManager == null) {
            this.decimalFormatManager = new DecimalFormatManager(51, this.getLanguageVersion());
        }
        return this.decimalFormatManager;
    }

    @Override
    public void issueWarning(String s2, Location locator) {
        XPathException err2 = new XPathException(s2);
        err2.setLocator(locator);
        if (this.userQueryContext != null) {
            this.userQueryContext.getErrorListener().warning(err2);
        } else {
            this.getConfiguration().getErrorListener().warning(err2);
        }
    }

    @Override
    public boolean isInBackwardsCompatibleMode() {
        return false;
    }

    public boolean isUpdating() {
        return this.isUpdating;
    }

    public int getLanguageVersion() {
        return 31;
    }

    @Override
    public int getXPathVersion() {
        return 31;
    }

    public CodeInjector getCodeInjector() {
        return this.codeInjector;
    }

    private void checkSchemaNamespaceImported(StructuredQName componentName, Declaration declaration) throws XPathException {
        String uri = componentName.getURI();
        if (!(uri.equals("http://www.w3.org/2001/XMLSchema") || uri.equals("http://ns.saxonica.com/anonymous-type") || uri.equals("http://saxon.sf.net/java-type") || this.isImportedSchema(uri))) {
            String msg = "Schema component " + componentName.getDisplayName() + " used in ";
            msg = declaration instanceof GlobalVariable ? msg + "declaration of imported variable " + ((GlobalVariable)declaration).getVariableQName().getDisplayName() : msg + "signature of imported function " + ((XQueryFunction)declaration).getDisplayName();
            msg = msg + " is not declared in any schema imported by ";
            String module = this.getModuleNamespace();
            msg = module == null ? msg + "the main query module" : msg + "query module " + module;
            XPathException err2 = new XPathException(msg);
            err2.setErrorCode("XQST0036");
            err2.setIsStaticError(true);
            err2.setLocator(declaration);
            throw err2;
        }
    }

    @Override
    public KeyManager getKeyManager() {
        KeyManager mgr = this.executable.getKeyManager();
        this.packageData.setKeyManager(mgr);
        return mgr;
    }

    @Override
    public ItemType resolveTypeAlias(StructuredQName typeName) {
        return this.getPackageData().obtainTypeAliasManager().getItemType(typeName);
    }

    private static class ActiveNamespace {
        public String prefix;
        public String uri;

        private ActiveNamespace() {
        }
    }
}

