/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.LocalBinding;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.PseudoExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.functions.Current;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pattern.MultipleNodeKindTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.PatternParser;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.ConcatenatingAxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingleNodeIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.UType;

public abstract class Pattern
extends PseudoExpression {
    private double priority = 0.5;

    public static Pattern make(String pattern, StaticContext env, PackageData packageData) throws XPathException {
        int languageLevel = 30;
        int lineNumber = env instanceof ExpressionContext ? ((ExpressionContext)env).getStyleElement().getLineNumber() : -1;
        PatternParser parser = (PatternParser)((Object)env.getConfiguration().newExpressionParser("PATTERN", false, 30));
        ((XPathParser)((Object)parser)).setLanguage(1, 30);
        Pattern pat = parser.parsePattern(pattern, env, lineNumber);
        pat.setRetainedStaticContext(env.makeRetainedStaticContext());
        pat.setOriginalText(pattern);
        pat = pat.simplify();
        return pat;
    }

    protected static void replaceCurrent(Expression exp, LocalBinding binding) {
        for (Operand o : exp.operands()) {
            Expression child = o.getChildExpression();
            if (child.isCallOn(Current.class)) {
                LocalVariableReference ref = new LocalVariableReference(binding);
                o.setChildExpression(ref);
                continue;
            }
            Pattern.replaceCurrent(child, binding);
        }
    }

    public static boolean patternContainsVariable(Pattern pattern) {
        return pattern != null && (pattern.getDependencies() & 0x80) != 0;
    }

    public boolean isLiftable(boolean forStreaming) {
        return false;
    }

    public void bindCurrent(LocalBinding binding) {
    }

    public boolean matchesCurrentGroup() {
        return false;
    }

    public void setOriginalText(String text2) {
    }

    public Pattern simplify() throws XPathException {
        return this;
    }

    public Pattern typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.typeCheckChildren(visitor, contextInfo);
        return this;
    }

    public int getDependencies() {
        return 0;
    }

    public int allocateSlots(SlotManager slotManager, int nextFree) {
        return nextFree;
    }

    public boolean isMotionless() {
        return true;
    }

    public final boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        return this.matches(context.getContextItem(), context);
    }

    public abstract boolean matches(Item var1, XPathContext var2) throws XPathException;

    public boolean matchesBeneathAnchor(NodeInfo node, NodeInfo anchor, XPathContext context) throws XPathException {
        return this.matches(node, context);
    }

    public SequenceIterator selectNodes(TreeInfo document2, final XPathContext context) throws XPathException {
        NodeInfo doc = document2.getRootNode();
        final UType uType = this.getUType();
        if (UType.DOCUMENT.subsumes(uType)) {
            if (this.matches(doc, context)) {
                return SingletonIterator.makeIterator(doc);
            }
            return EmptyIterator.getInstance();
        }
        if (UType.ATTRIBUTE.subsumes(uType)) {
            AxisIterator allElements = doc.iterateAxis((byte)4, NodeKindTest.ELEMENT);
            MappingFunction atts = new MappingFunction(){

                public SequenceIterator map(Item item) {
                    return ((NodeInfo)item).iterateAxis((byte)2);
                }
            };
            MappingIterator allAttributes = new MappingIterator(allElements, atts);
            ItemMappingFunction test = new ItemMappingFunction(){

                public Item mapItem(Item item) throws XPathException {
                    if (Pattern.this.matches(item, context)) {
                        return item;
                    }
                    return null;
                }
            };
            return new ItemMappingIterator(allAttributes, test);
        }
        if (UType.NAMESPACE.subsumes(uType)) {
            AxisIterator allElements = doc.iterateAxis((byte)4, NodeKindTest.ELEMENT);
            MappingFunction atts = new MappingFunction(){

                public SequenceIterator map(Item item) {
                    return ((NodeInfo)item).iterateAxis((byte)8);
                }
            };
            MappingIterator allNamespaces = new MappingIterator(allElements, atts);
            ItemMappingFunction test = new ItemMappingFunction(){

                public Item mapItem(Item item) throws XPathException {
                    if (Pattern.this.matches(item, context)) {
                        return item;
                    }
                    return null;
                }
            };
            return new ItemMappingIterator(allNamespaces, test);
        }
        if (UType.CHILD_NODE_KINDS.subsumes(uType)) {
            AxisIterator allChildren = doc.iterateAxis((byte)4, new MultipleNodeKindTest(uType));
            ItemMappingFunction test = new ItemMappingFunction(){

                public Item mapItem(Item item) throws XPathException {
                    if (Pattern.this.matches(item, context)) {
                        return item;
                    }
                    return null;
                }
            };
            return new ItemMappingIterator(allChildren, test);
        }
        byte axis = uType.subsumes(UType.DOCUMENT) ? (byte)5 : 4;
        AxisIterator allChildren = doc.iterateAxis(axis);
        MappingFunction processElement = new MappingFunction(){

            public SequenceIterator map(Item item) {
                AxisIterator mapper = SingleNodeIterator.makeIterator((NodeInfo)item);
                if (uType.subsumes(UType.NAMESPACE)) {
                    mapper = new ConcatenatingAxisIterator(mapper, ((NodeInfo)item).iterateAxis((byte)8));
                }
                if (uType.subsumes(UType.ATTRIBUTE)) {
                    mapper = new ConcatenatingAxisIterator(mapper, ((NodeInfo)item).iterateAxis((byte)2));
                }
                return mapper;
            }
        };
        MappingIterator attributesOrSelf = new MappingIterator(allChildren, processElement);
        ItemMappingFunction test = new ItemMappingFunction(){

            public Item mapItem(Item item) throws XPathException {
                if (Pattern.this.matches(item, context)) {
                    return item;
                }
                return null;
            }
        };
        return new ItemMappingIterator(attributesOrSelf, test);
    }

    public abstract UType getUType();

    public int getFingerprint() {
        return -1;
    }

    public abstract ItemType getItemType();

    public void setPriority(double priority) {
        this.priority = priority;
    }

    public double getDefaultPriority() {
        return this.priority;
    }

    public String toString() {
        return "pattern matching " + this.getItemType().toString();
    }

    public int getHostLanguage() {
        return 50;
    }

    public Pattern convertToTypedPattern(String val) throws XPathException {
        return null;
    }

    public abstract void export(ExpressionPresenter var1) throws XPathException;

    public abstract Pattern copy(RebindingMap var1);

    public Pattern optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        return this;
    }

    public String toShortString() {
        return this.toString();
    }
}

