/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.LinkedList;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.tiny.NodeVectorTree;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.PrimitiveUType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.UType;
import net.sf.saxon.z.IntPredicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultipleNodeKindTest
extends NodeTest {
    public static final MultipleNodeKindTest PARENT_NODE = new MultipleNodeKindTest(UType.DOCUMENT.union(UType.ELEMENT));
    public static final MultipleNodeKindTest DOC_ELEM_ATTR = new MultipleNodeKindTest(UType.DOCUMENT.union(UType.ELEMENT).union(UType.ATTRIBUTE));
    public static final MultipleNodeKindTest LEAF = new MultipleNodeKindTest(UType.TEXT.union(UType.COMMENT).union(UType.PI).union(UType.NAMESPACE).union(UType.ATTRIBUTE));
    UType uType;
    int nodeKindMask;

    public MultipleNodeKindTest(UType u) {
        this.uType = u;
        if (UType.DOCUMENT.overlaps(u)) {
            this.nodeKindMask |= 0x200;
        }
        if (UType.ELEMENT.overlaps(u)) {
            this.nodeKindMask |= 2;
        }
        if (UType.ATTRIBUTE.overlaps(u)) {
            this.nodeKindMask |= 4;
        }
        if (UType.TEXT.overlaps(u)) {
            this.nodeKindMask |= 8;
        }
        if (UType.COMMENT.overlaps(u)) {
            this.nodeKindMask |= 0x100;
        }
        if (UType.PI.overlaps(u)) {
            this.nodeKindMask |= 0x80;
        }
        if (UType.NAMESPACE.overlaps(u)) {
            this.nodeKindMask |= 0x2000;
        }
    }

    @Override
    public UType getUType() {
        return this.uType;
    }

    @Override
    public boolean matches(int nodeKind, NodeName name, SchemaType annotation) {
        return (this.nodeKindMask & 1 << nodeKind) != 0;
    }

    @Override
    public IntPredicate getMatcher(NodeVectorTree tree) {
        final byte[] nodeKindArray = tree.getNodeKindArray();
        return new IntPredicate(){

            public boolean matches(int nodeNr) {
                int nodeKind = nodeKindArray[nodeNr];
                if (nodeKind == 4) {
                    nodeKind = 3;
                }
                return (MultipleNodeKindTest.this.nodeKindMask & 1 << nodeKind) != 0;
            }
        };
    }

    @Override
    public boolean matchesNode(NodeInfo node) {
        int nodeKind = node.getNodeKind();
        return (this.nodeKindMask & 1 << nodeKind) != 0;
    }

    @Override
    public double getDefaultPriority() {
        return -0.5;
    }

    @Override
    public int getNodeKindMask() {
        return this.nodeKindMask;
    }

    @Override
    public String toString() {
        FastStringBuffer fsb = new FastStringBuffer(64);
        LinkedList<PrimitiveUType> types = new LinkedList<PrimitiveUType>(this.uType.decompose());
        this.format(types, fsb);
        return fsb.toString();
    }

    @Override
    public String toExportString() {
        FastStringBuffer fsb = new FastStringBuffer(64);
        LinkedList<PrimitiveUType> types = new LinkedList<PrimitiveUType>(this.uType.decompose());
        this.formatForExport(types, fsb);
        return fsb.toString();
    }

    private void format(LinkedList<PrimitiveUType> list2, FastStringBuffer fsb) {
        if (list2.size() == 1) {
            fsb.append(list2.get(0).toItemType().toString());
        } else {
            fsb.append('(');
            fsb.append(list2.removeFirst().toItemType().toString());
            fsb.append('|');
            this.format(list2, fsb);
            fsb.append(')');
        }
    }

    private void formatForExport(LinkedList<PrimitiveUType> list2, FastStringBuffer fsb) {
        if (list2.size() == 1) {
            fsb.append(list2.get(0).toItemType().toExportString());
        } else {
            fsb.append('(');
            fsb.append(list2.removeFirst().toItemType().toExportString());
            fsb.append('|');
            this.format(list2, fsb);
            fsb.append(')');
        }
    }

    public int hashCode() {
        return this.uType.hashCode();
    }

    @Override
    public String generateJavaScriptItemTypeTest(ItemType knownToBe, int targetVersion) {
        FastStringBuffer fsb = new FastStringBuffer(256);
        fsb.append("return SaxonJS.U.isNode(item) && (");
        String or = "";
        UType u = this.uType;
        if (UType.DOCUMENT.overlaps(u)) {
            fsb.append(or + "item.nodeType===9||item.nodeType===11");
            or = "||";
        }
        if (UType.ELEMENT.overlaps(u)) {
            fsb.append(or + "item.nodeType===1");
            or = "||";
        }
        if (UType.ATTRIBUTE.overlaps(u)) {
            fsb.append(or + "item.nodeType===2");
            or = "||";
        }
        if (UType.TEXT.overlaps(u)) {
            fsb.append(or + "item.nodeType===3");
            or = "||";
        }
        if (UType.COMMENT.overlaps(u)) {
            fsb.append(or + "item.nodeType===8");
            or = "||";
        }
        if (UType.PI.overlaps(u)) {
            fsb.append(or + "item.nodeType===7");
            or = "||";
        }
        if (UType.NAMESPACE.overlaps(u)) {
            fsb.append(or + "item.nodeType===13");
            or = "||";
        }
        fsb.append(");");
        return fsb.toString().replace("false||", "");
    }
}

