/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.RangeIterator;
import net.sf.saxon.expr.ReverseRangeIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.functions.Count;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.MemoSequence;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.wrapper.VirtualNode;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.MemoClosure;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.SingletonClosure;

public class SequenceTool {
    public static final int INDETERMINATE_ORDERING = Integer.MIN_VALUE;

    public static GroundedValue toGroundedValue(Sequence sequence2) throws XPathException {
        if (sequence2 instanceof GroundedValue) {
            return (GroundedValue)sequence2;
        }
        return SequenceExtent.makeSequenceExtent(sequence2.iterate());
    }

    public static GroundedValue toGroundedValue(SequenceIterator iterator2) throws XPathException {
        if ((iterator2.getProperties() & 1) != 0) {
            return ((GroundedIterator)iterator2).materialize();
        }
        return SequenceExtent.makeSequenceExtent(iterator2);
    }

    public static Sequence toMemoSequence(SequenceIterator iterator2) throws XPathException {
        if ((iterator2.getProperties() & 1) != 0) {
            return ((GroundedIterator)iterator2).materialize();
        }
        return new MemoSequence(iterator2);
    }

    public static Sequence toLazySequence(SequenceIterator iterator2) throws XPathException {
        if ((iterator2.getProperties() & 1) != 0 && !(iterator2 instanceof RangeIterator) && !(iterator2 instanceof ReverseRangeIterator)) {
            return ((GroundedIterator)iterator2).materialize();
        }
        return new LazySequence(iterator2);
    }

    public static boolean isUnrepeatable(Sequence seq) {
        return seq instanceof LazySequence || seq instanceof Closure && !(seq instanceof MemoClosure) && !(seq instanceof SingletonClosure);
    }

    public static Sequence makeRepeatable(Sequence seq) throws XPathException {
        if (SequenceTool.isUnrepeatable(seq)) {
            return SequenceTool.toMemoSequence(seq.iterate());
        }
        return seq;
    }

    public static int getLength(Sequence sequence2) throws XPathException {
        if (sequence2 instanceof GroundedValue) {
            return ((GroundedValue)sequence2).getLength();
        }
        return Count.count(sequence2.iterate());
    }

    public static boolean hasLength(SequenceIterator iter2, int length) throws XPathException {
        if ((iter2.getProperties() & 2) != 0) {
            return ((LastPositionFinder)((Object)iter2)).getLength() == length;
        }
        int n = 0;
        while (iter2.next() != null) {
            if (n++ != length) continue;
            iter2.close();
            return false;
        }
        return length == 0;
    }

    public static boolean sameLength(SequenceIterator a, SequenceIterator b) throws XPathException {
        Item itB;
        Item itA;
        if ((a.getProperties() & 2) != 0) {
            return SequenceTool.hasLength(b, ((LastPositionFinder)((Object)a)).getLength());
        }
        if ((b.getProperties() & 2) != 0) {
            return SequenceTool.hasLength(a, ((LastPositionFinder)((Object)b)).getLength());
        }
        do {
            itA = a.next();
            itB = b.next();
        } while (itA != null && itB != null);
        if (itA != null) {
            a.close();
        }
        if (itB != null) {
            b.close();
        }
        return itA == null && itB == null;
    }

    public static Item itemAt(Sequence sequence2, int index2) throws XPathException {
        if (sequence2 instanceof Item && index2 == 0) {
            return (Item)sequence2;
        }
        return SequenceTool.toGroundedValue(sequence2).itemAt(index2);
    }

    public static Item asItem(Sequence sequence2) throws XPathException {
        if (sequence2 instanceof Item) {
            return (Item)sequence2;
        }
        SequenceIterator iter2 = sequence2.iterate();
        Item first = iter2.next();
        if (first == null) {
            return null;
        }
        if (iter2.next() != null) {
            throw new XPathException("Sequence contains more than one item");
        }
        return first;
    }

    public static Object convertToJava(Item item) throws XPathException {
        if (item instanceof NodeInfo) {
            Object node = item;
            while (node instanceof VirtualNode) {
                node = ((VirtualNode)node).getRealNode();
            }
            return node;
        }
        if (item instanceof Function) {
            return item;
        }
        if (item instanceof ObjectValue) {
            return ((ObjectValue)item).getObject();
        }
        AtomicValue value2 = (AtomicValue)item;
        switch (value2.getItemType().getPrimitiveType()) {
            case 513: 
            case 518: 
            case 529: 
            case 631: {
                return value2.getStringValue();
            }
            case 514: {
                return ((BooleanValue)value2).getBooleanValue() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 515: {
                return ((BigDecimalValue)value2).getDecimalValue();
            }
            case 533: {
                return ((NumericValue)value2).longValue();
            }
            case 517: {
                return ((DoubleValue)value2).getDoubleValue();
            }
            case 516: {
                return Float.valueOf(((FloatValue)value2).getFloatValue());
            }
            case 519: {
                return ((DateTimeValue)value2).getCalendar().getTime();
            }
            case 521: {
                return ((DateValue)value2).getCalendar().getTime();
            }
            case 520: {
                return value2.getStringValue();
            }
            case 528: {
                return ((Base64BinaryValue)value2).getBinaryValue();
            }
            case 527: {
                return ((HexBinaryValue)value2).getBinaryValue();
            }
        }
        return item;
    }

    public static String getStringValue(Sequence sequence2) throws XPathException {
        Item item;
        FastStringBuffer fsb = new FastStringBuffer(64);
        SequenceIterator iter2 = sequence2.iterate();
        boolean first = true;
        while ((item = iter2.next()) != null) {
            if (first) {
                first = false;
            } else {
                fsb.append(' ');
            }
            fsb.append(item.getStringValueCS());
        }
        return fsb.toString();
    }

    public static ItemType getItemType(Sequence sequence2, TypeHierarchy th) {
        if (sequence2 instanceof Item) {
            return Type.getItemType((Item)sequence2, th);
        }
        if (sequence2 instanceof GroundedValue) {
            try {
                Item item;
                ItemType type = null;
                SequenceIterator iter2 = sequence2.iterate();
                while ((item = iter2.next()) != null && (type = type == null ? Type.getItemType(item, th) : Type.getCommonSuperType(type, Type.getItemType(item, th), th)) != AnyItemType.getInstance()) {
                }
                return type == null ? ErrorType.getInstance() : type;
            }
            catch (XPathException err2) {
                return AnyItemType.getInstance();
            }
        }
        return AnyItemType.getInstance();
    }

    public static SequenceType getSequenceType(Sequence value2, TypeHierarchy th) {
        return SequenceType.makeSequenceType(SequenceTool.getItemType(value2, th), SequenceTool.getCardinality(value2));
    }

    public static UType getUType(Sequence sequence2) {
        if (sequence2 instanceof Item) {
            return UType.getUType((Item)sequence2);
        }
        if (sequence2 instanceof GroundedValue) {
            Item item;
            UType type = UType.VOID;
            UnfailingIterator iter2 = ((GroundedValue)sequence2).iterate();
            while ((item = iter2.next()) != null && (type = type.union(UType.getUType(item))) != UType.ANY) {
            }
            return type;
        }
        return UType.ANY;
    }

    public static int getCardinality(Sequence sequence2) {
        if (sequence2 instanceof Item) {
            return 16384;
        }
        if (sequence2 instanceof GroundedValue) {
            int len = ((GroundedValue)sequence2).getLength();
            switch (len) {
                case 0: {
                    return 8192;
                }
                case 1: {
                    return 16384;
                }
            }
            return 49152;
        }
        try {
            SequenceIterator iter2 = sequence2.iterate();
            Item item = iter2.next();
            if (item == null) {
                return 8192;
            }
            item = iter2.next();
            return item == null ? 16384 : 49152;
        }
        catch (XPathException err2) {
            return 49152;
        }
    }

    public static void process(Sequence value2, XPathContext context, Location locationId) throws XPathException {
        Item it;
        SequenceIterator iter2 = value2.iterate();
        SequenceReceiver out = context.getReceiver();
        while ((it = iter2.next()) != null) {
            out.append(it, locationId, 2);
        }
    }
}

