/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.Arrays;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;

public class MemoSequence
implements Sequence {
    SequenceIterator inputIterator;
    private Item[] reservoir = null;
    private int used;
    protected int state;
    private static final int UNREAD = 0;
    private static final int MAYBE_MORE = 1;
    private static final int ALL_READ = 3;
    private static final int BUSY = 4;
    protected static final int EMPTY = 5;

    public MemoSequence(SequenceIterator iterator2) {
        this.inputIterator = iterator2;
    }

    public Item head() throws XPathException {
        return this.iterate().next();
    }

    public synchronized SequenceIterator iterate() throws XPathException {
        switch (this.state) {
            case 0: {
                this.state = 4;
                if (this.inputIterator instanceof EmptyIterator) {
                    this.state = 5;
                    return this.inputIterator;
                }
                this.reservoir = new Item[50];
                this.used = 0;
                this.state = 1;
                return new ProgressiveIterator();
            }
            case 1: {
                return new ProgressiveIterator();
            }
            case 3: {
                switch (this.used) {
                    case 0: {
                        this.state = 5;
                        return EmptyIterator.emptyIterator();
                    }
                    case 1: {
                        assert (this.reservoir != null);
                        return SingletonIterator.makeIterator(this.reservoir[0]);
                    }
                }
                return new ArrayIterator(this.reservoir, 0, this.used);
            }
            case 4: {
                XPathException de = new XPathException("Attempt to access a variable while it is being evaluated");
                de.setErrorCode("XTDE0640");
                throw de;
            }
            case 5: {
                return EmptyIterator.emptyIterator();
            }
        }
        throw new IllegalStateException("Unknown iterator state");
    }

    public synchronized Item itemAt(int n) throws XPathException {
        if (n < 0) {
            return null;
        }
        if (this.reservoir != null && n < this.used) {
            return this.reservoir[n];
        }
        if (this.state == 3 || this.state == 5) {
            return null;
        }
        if (this.state == 0) {
            Item item = this.inputIterator.next();
            if (item == null) {
                this.state = 5;
                return null;
            }
            this.state = 1;
            this.reservoir = new Item[50];
            this.append(item);
            if (n == 0) {
                return item;
            }
        }
        int diff2 = n - this.used + 1;
        while (diff2-- > 0) {
            Item i = this.inputIterator.next();
            if (i == null) {
                this.state = 3;
                this.condense();
                return null;
            }
            this.append(i);
            this.state = 1;
        }
        return this.reservoir[n];
    }

    private void append(Item item) {
        assert (this.reservoir != null);
        if (this.used >= this.reservoir.length) {
            this.reservoir = Arrays.copyOf(this.reservoir, this.used * 2);
        }
        this.reservoir[this.used++] = item;
    }

    private void condense() {
        if (this.reservoir != null && this.reservoir.length - this.used > 30) {
            this.reservoir = Arrays.copyOf(this.reservoir, this.used);
        }
    }

    public final class ProgressiveIterator
    implements SequenceIterator,
    LastPositionFinder,
    GroundedIterator {
        int position = -1;

        public MemoSequence getMemoSequence() {
            return MemoSequence.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Item next() throws XPathException {
            MemoSequence memoSequence = MemoSequence.this;
            synchronized (memoSequence) {
                if (this.position == -2) {
                    return null;
                }
                if (++this.position < MemoSequence.this.used) {
                    assert (MemoSequence.this.reservoir != null);
                    return MemoSequence.this.reservoir[this.position];
                }
                if (MemoSequence.this.state == 3) {
                    this.position = -2;
                    return null;
                }
                assert (MemoSequence.this.inputIterator != null);
                Item i = MemoSequence.this.inputIterator.next();
                if (i == null) {
                    MemoSequence.this.state = 3;
                    MemoSequence.this.condense();
                    this.position = -2;
                    return null;
                }
                this.position = MemoSequence.this.used;
                MemoSequence.this.append(i);
                MemoSequence.this.state = 1;
                return i;
            }
        }

        public void close() {
        }

        public int getLength() throws XPathException {
            if (MemoSequence.this.state == 3) {
                return MemoSequence.this.used;
            }
            if (MemoSequence.this.state == 5) {
                return 0;
            }
            int savePos = this.position;
            while (this.next() != null) {
            }
            this.position = savePos;
            return MemoSequence.this.used;
        }

        public GroundedValue materialize() throws XPathException {
            if (MemoSequence.this.state == 3) {
                return this.makeExtent();
            }
            if (MemoSequence.this.state == 5) {
                return EmptySequence.getInstance();
            }
            int savePos = this.position;
            while (this.next() != null) {
            }
            this.position = savePos;
            return this.makeExtent();
        }

        private GroundedValue makeExtent() {
            if (MemoSequence.this.used == MemoSequence.this.reservoir.length) {
                return new SequenceExtent(MemoSequence.this.reservoir);
            }
            return SequenceExtent.makeSequenceExtent(Arrays.asList(MemoSequence.this.reservoir).subList(0, MemoSequence.this.used));
        }

        public GroundedValue getResidue() throws XPathException {
            if (MemoSequence.this.state == 5 || this.position >= MemoSequence.this.used || this.position == -2) {
                return EmptySequence.getInstance();
            }
            if (MemoSequence.this.state == 3) {
                return SequenceExtent.makeSequenceExtent(Arrays.asList(MemoSequence.this.reservoir).subList(this.position + 1, MemoSequence.this.used));
            }
            int savePos = this.position;
            while (this.next() != null) {
            }
            this.position = savePos;
            return SequenceExtent.makeSequenceExtent(Arrays.asList(MemoSequence.this.reservoir).subList(this.position + 1, MemoSequence.this.used));
        }

        public int getProperties() {
            return 3;
        }
    }
}

