/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.tree.util.DocumentNumberAllocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericTreeInfo
implements TreeInfo {
    private Configuration config;
    private NodeInfo root;
    private String systemId;
    private Map<String, Object> userData;
    private long documentNumber = -1L;

    public GenericTreeInfo(Configuration config) {
        this.config = config;
    }

    public GenericTreeInfo(Configuration config, NodeInfo root2) {
        this.config = config;
        this.setRootNode(root2);
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    public void setRootNode(NodeInfo root2) {
        if (root2.getParent() != null) {
            throw new IllegalArgumentException("The root node of a tree must be parentless");
        }
        this.root = root2;
    }

    @Override
    public NodeInfo getRootNode() {
        return this.root;
    }

    @Override
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    public String getPublicId() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getDocumentNumber() {
        if (this.documentNumber == -1L) {
            DocumentNumberAllocator dna = this.config.getDocumentNumberAllocator();
            GenericTreeInfo genericTreeInfo = this;
            synchronized (genericTreeInfo) {
                if (this.documentNumber == -1L) {
                    this.documentNumber = dna.allocateDocumentNumber();
                }
            }
        }
        return this.documentNumber;
    }

    public synchronized void setDocumentNumber(long documentNumber) {
        this.documentNumber = documentNumber;
    }

    @Override
    public boolean isTyped() {
        return false;
    }

    @Override
    public NodeInfo selectID(String id, boolean getParent) {
        return null;
    }

    @Override
    public Iterator<String> getUnparsedEntityNames() {
        List e = Collections.emptyList();
        return e.iterator();
    }

    @Override
    public String[] getUnparsedEntity(String name) {
        return null;
    }

    @Override
    public void setUserData(String key, Object value2) {
        if (this.userData == null) {
            this.userData = new HashMap<String, Object>();
        }
        this.userData.put(key, value2);
    }

    @Override
    public Object getUserData(String key) {
        if (this.userData == null) {
            return this.userData;
        }
        return this.userData.get(key);
    }

    public boolean isStreamed() {
        return false;
    }
}

