/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.trie;

import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ImmutableList<T>
implements Iterable<T> {
    private static final EmptyList EMPTY_LIST = new EmptyList();

    public abstract T head();

    public abstract ImmutableList<T> tail();

    public abstract boolean isEmpty();

    public final int size() {
        ImmutableList<T> input2 = this;
        int size2 = 0;
        while (!input2.isEmpty()) {
            ++size2;
            input2 = input2.tail();
        }
        return size2;
    }

    public ImmutableList<T> prepend(T element) {
        return new NonEmptyList(element, this);
    }

    public static <T> ImmutableList<T> nil() {
        return EMPTY_LIST;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ImmutableList)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        Iterator<T> thisIter = this.iterator();
        Iterator<T> otherIter = ((ImmutableList)o).iterator();
        while (thisIter.hasNext() && otherIter.hasNext()) {
            if (thisIter.next().equals(otherIter.next())) continue;
            return false;
        }
        return thisIter.hasNext() == otherIter.hasNext();
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private ImmutableList<T> list;
            {
                this.list = ImmutableList.this;
            }

            @Override
            public boolean hasNext() {
                return !this.list.isEmpty();
            }

            @Override
            public T next() {
                Object element = this.list.head();
                this.list = this.list.tail();
                return element;
            }

            @Override
            public void remove() {
                throw new RuntimeException("Cannot remove from immutable list");
            }
        };
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        boolean first = true;
        for (T elem2 : this) {
            if (!first) {
                builder.append(", ");
            }
            builder.append(elem2);
            first = false;
        }
        builder.append(']');
        return builder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NonEmptyList<T>
    extends ImmutableList<T> {
        private final T element;
        private final ImmutableList<T> tail;

        private NonEmptyList(T element, ImmutableList<T> tail2) {
            this.element = element;
            this.tail = tail2;
        }

        @Override
        public T head() {
            return this.element;
        }

        @Override
        public ImmutableList<T> tail() {
            return this.tail;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }

    private static class EmptyList
    extends ImmutableList {
        private EmptyList() {
        }

        public Object head() {
            throw new NoSuchElementException("head() called on empty list");
        }

        public ImmutableList tail() {
            throw new NoSuchElementException("head() called on empty list");
        }

        public boolean isEmpty() {
            return true;
        }
    }
}

