/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.map;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaComponentVisitor;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TupleItemType
extends AnyFunctionType {
    private Map<String, SequenceType> fields = new HashMap<String, SequenceType>();

    public TupleItemType(List<String> names, List<SequenceType> types) {
        for (int i = 0; i < names.size(); ++i) {
            this.fields.put(names.get(i), types.get(i));
        }
    }

    @Override
    public boolean isMapType() {
        return true;
    }

    @Override
    public boolean isArrayType() {
        return false;
    }

    public SequenceType getFieldType(String field2) {
        return this.fields.get(field2);
    }

    @Override
    public boolean matches(Item item, TypeHierarchy th) throws XPathException {
        if (!(item instanceof MapItem)) {
            return false;
        }
        MapItem map2 = (MapItem)item;
        for (Map.Entry<String, SequenceType> field2 : this.fields.entrySet()) {
            Sequence val = map2.get(new StringValue(field2.getKey()));
            if (val == null) {
                val = EmptySequence.getInstance();
            }
            if (field2.getValue().matches(val, th)) continue;
            return false;
        }
        return true;
    }

    public int getArity() {
        return 1;
    }

    @Override
    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_ATOMIC};
    }

    @Override
    public SequenceType getResultType() {
        return SequenceType.ANY_SEQUENCE;
    }

    @Override
    public String toString() {
        FastStringBuffer sb = new FastStringBuffer(100);
        sb.append("tuple(");
        boolean first = true;
        for (Map.Entry<String, SequenceType> field2 : this.fields.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(field2.getKey());
            sb.append(": ");
            sb.append(field2.getValue().toString());
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object other) {
        return this == other || other instanceof TupleItemType && this.fields.equals(((TupleItemType)other).fields);
    }

    public int hashCode() {
        return this.fields.hashCode();
    }

    @Override
    public int relationship(FunctionItemType other, TypeHierarchy th) {
        if (other == AnyFunctionType.getInstance()) {
            return 2;
        }
        if (this.equals(other)) {
            return 0;
        }
        if (other == MapType.ANY_MAP_TYPE) {
            return 2;
        }
        if (other.isArrayType()) {
            return 4;
        }
        if (other instanceof MapType) {
            MapType f2 = (MapType)other;
            int keyRel = th.relationship(BuiltInAtomicType.STRING, f2.getKeyType());
            if (keyRel == 4) {
                return 4;
            }
            if (f2.getValueType().getPrimaryType().equals(AnyItemType.getInstance()) && f2.getValueType().getCardinality() == 57344) {
                return 2;
            }
            for (SequenceType entry2 : this.fields.values()) {
                int rel = th.sequenceTypeRelationship(entry2, f2.getValueType());
                if (rel == 2 || rel == 0) continue;
                return 3;
            }
            return 2;
        }
        int rel = new SpecificFunctionType(this.getArgumentTypes(), this.getResultType()).relationship(other, th);
        return rel;
    }

    @Override
    public Expression makeFunctionSequenceCoercer(Expression exp, RoleDiagnostic role) throws XPathException {
        Expression result2 = exp;
        result2 = new SpecificFunctionType(this.getArgumentTypes(), this.getResultType()).makeFunctionSequenceCoercer(exp, role);
        return result2;
    }

    @Override
    public void visitNamedSchemaComponents(SchemaComponentVisitor visitor) throws XPathException {
        for (SequenceType t : this.fields.values()) {
            t.getPrimaryType().visitNamedSchemaComponents(visitor);
        }
    }

    @Override
    public String generateJavaScriptItemTypeTest(ItemType knownToBe, int targetVersion) throws XPathException {
        throw new UnsupportedOperationException();
    }
}

