/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.map;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;

public class MapCreate
extends SystemFunction {
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        MapItem next2;
        SequenceIterator iter2 = arguments[0].iterate();
        MapItem baseMap = (MapItem)iter2.next();
        if (baseMap == null) {
            return new HashTrieMap();
        }
        if (!(baseMap instanceof HashTrieMap)) {
            baseMap = HashTrieMap.copy(baseMap);
        }
        while ((next2 = (MapItem)iter2.next()) != null) {
            for (KeyValuePair pair2 : next2) {
                if (baseMap.get(pair2.key) != null) {
                    throw new XPathException("Duplicate key value (" + pair2.key + ") in map", "XQDY0137");
                }
                baseMap = ((HashTrieMap)baseMap).addEntry(pair2.key, pair2.value);
            }
        }
        return baseMap;
    }

    public String getStreamerName() {
        return "NewMap";
    }
}

