/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.map;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.functions.DeepEqual;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.ma.map.TupleItemType;
import net.sf.saxon.ma.trie.ImmutableHashTrieMap;
import net.sf.saxon.ma.trie.ImmutableMap;
import net.sf.saxon.ma.trie.Tuple2;
import net.sf.saxon.om.AbstractItem;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.query.AnnotationList;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashTrieMap
extends AbstractItem
implements MapItem,
GroundedValue {
    public static final SequenceType SINGLE_MAP_TYPE = SequenceType.makeSequenceType(MapType.ANY_MAP_TYPE, 16384);
    private ImmutableMap<AtomicMatchKey, KeyValuePair> imap;
    private UType keyUType = UType.VOID;
    private UType valueUType = UType.VOID;
    private AtomicType keyAtomicType = ErrorType.getInstance();
    private ItemType valueItemType = ErrorType.getInstance();
    private int valueCardinality = 0;
    private int entries = -1;

    public HashTrieMap() {
        this.imap = ImmutableHashTrieMap.empty();
        this.entries = 0;
    }

    public static HashTrieMap singleton(AtomicValue key, Sequence value2, XPathContext context) throws XPathException {
        return new HashTrieMap().addEntry(key, value2);
    }

    public HashTrieMap(ImmutableMap<AtomicMatchKey, KeyValuePair> imap) {
        this.imap = imap;
        this.entries = -1;
    }

    public static HashTrieMap copy(MapItem map2) {
        if (map2 instanceof HashTrieMap) {
            return (HashTrieMap)map2;
        }
        HashTrieMap m2 = new HashTrieMap();
        for (KeyValuePair pair2 : map2) {
            m2 = m2.addEntry(pair2.key, pair2.value);
        }
        return m2;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isMap() {
        return true;
    }

    @Override
    public AnnotationList getAnnotations() {
        return AnnotationList.EMPTY;
    }

    @Override
    public AtomicSequence atomize() throws XPathException {
        throw new XPathException("Maps cannot be atomized", "FOTY0013");
    }

    private void updateTypeInformation(AtomicValue key, Sequence val, boolean wasEmpty) {
        if (wasEmpty) {
            this.keyUType = key.getUType();
            this.valueUType = SequenceTool.getUType(val);
            this.keyAtomicType = key.getItemType();
            this.valueItemType = this.getItemTypeOfSequence(val);
            this.valueCardinality = SequenceTool.getCardinality(val);
        } else {
            this.keyUType = this.keyUType.union(key.getUType());
            this.valueUType = this.valueUType.union(SequenceTool.getUType(val));
            this.valueCardinality = Cardinality.union(this.valueCardinality, SequenceTool.getCardinality(val));
            if (key.getItemType() != this.keyAtomicType) {
                this.keyAtomicType = null;
            }
            if (!HashTrieMap.isKnownToConform(val, this.valueItemType)) {
                this.valueItemType = null;
            }
        }
    }

    private static boolean isKnownToConform(Sequence value2, ItemType itemType) {
        if (itemType == AnyItemType.getInstance()) {
            return true;
        }
        try {
            Item item;
            SequenceIterator iter2 = value2.iterate();
            while ((item = iter2.next()) != null) {
                if (item instanceof AtomicValue) {
                    if (itemType instanceof AtomicType) {
                        if (Type.isSubType(((AtomicValue)item).getItemType(), (AtomicType)itemType)) continue;
                        return false;
                    }
                    return false;
                }
                if (item instanceof NodeInfo) {
                    if (itemType instanceof NodeTest) {
                        if (((NodeTest)itemType).matchesNode((NodeInfo)item)) continue;
                        return false;
                    }
                    return false;
                }
                return false;
            }
            return true;
        }
        catch (XPathException e) {
            return false;
        }
    }

    private ItemType getItemTypeOfSequence(Sequence val) {
        try {
            Item first = val.head();
            if (first == null) {
                return AnyItemType.getInstance();
            }
            ItemType type = first instanceof AtomicValue ? ((AtomicValue)first).getItemType() : (first instanceof NodeInfo ? NodeKindTest.makeNodeKindTest(((NodeInfo)first).getNodeKind()) : AnyFunctionType.getInstance());
            if (HashTrieMap.isKnownToConform(val, type)) {
                return type;
            }
            return AnyItemType.getInstance();
        }
        catch (XPathException e) {
            return AnyItemType.getInstance();
        }
    }

    @Override
    public int size() {
        if (this.entries >= 0) {
            return this.entries;
        }
        int count2 = 0;
        for (KeyValuePair entry2 : this) {
            ++count2;
        }
        this.entries = count2;
        return this.entries;
    }

    @Override
    public boolean isEmpty() {
        return this.entries == 0 || !this.imap.iterator().hasNext();
    }

    @Override
    public boolean conforms(AtomicType requiredKeyType, SequenceType requiredValueType, TypeHierarchy th) {
        int requiredValueCard;
        ItemType upperBoundValueType;
        int rel;
        ItemType requiredValueItemType;
        ItemType upperBoundKeyType;
        int rel2;
        if (this.isEmpty()) {
            return true;
        }
        if (this.keyAtomicType == requiredKeyType && this.valueItemType == requiredValueType.getPrimaryType() && Cardinality.subsumes(requiredValueType.getCardinality(), this.valueCardinality)) {
            return true;
        }
        boolean needFullCheck = false;
        if (requiredKeyType != BuiltInAtomicType.ANY_ATOMIC && (rel2 = th.relationship(requiredKeyType, upperBoundKeyType = this.keyUType.toItemType())) != 0 && rel2 != 1) {
            if (rel2 == 4) {
                return false;
            }
            needFullCheck = true;
        }
        if ((requiredValueItemType = requiredValueType.getPrimaryType()) != BuiltInAtomicType.ANY_ATOMIC && (rel = th.relationship(requiredValueItemType, upperBoundValueType = this.valueUType.toItemType())) != 0 && rel != 1) {
            if (rel == 4) {
                return false;
            }
            needFullCheck = true;
        }
        if (!Cardinality.subsumes(requiredValueCard = requiredValueType.getCardinality(), this.valueCardinality)) {
            needFullCheck = true;
        }
        if (needFullCheck) {
            AtomicValue key;
            AtomicIterator keyIter = this.keys();
            while ((key = keyIter.next()) != null) {
                if (!requiredKeyType.matches(key, th)) {
                    return false;
                }
                Sequence val = this.get(key);
                try {
                    if (requiredValueType.matches(val, th)) continue;
                    return false;
                }
                catch (XPathException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }
        return true;
    }

    @Override
    public MapType getItemType(TypeHierarchy th) {
        AtomicValue key;
        ItemType keyType = null;
        ItemType valueType = null;
        int valueCard = 0;
        AtomicIterator keyIter = this.keys();
        while ((key = keyIter.next()) != null) {
            Sequence val = this.get(key);
            if (keyType == null) {
                keyType = key.getItemType();
                valueType = SequenceTool.getItemType(val, th);
                valueCard = SequenceTool.getCardinality(val);
                continue;
            }
            keyType = (AtomicType)Type.getCommonSuperType(keyType, key.getItemType(), th);
            valueType = Type.getCommonSuperType(valueType, SequenceTool.getItemType(val, th), th);
            valueCard = Cardinality.union(valueCard, SequenceTool.getCardinality(val));
        }
        if (keyType == null) {
            this.keyUType = UType.VOID;
            this.valueUType = UType.VOID;
            this.valueCardinality = 0;
            return MapType.ANY_MAP_TYPE;
        }
        this.keyUType = keyType.getUType();
        this.valueUType = valueType.getUType();
        this.valueCardinality = valueCard;
        return new MapType((AtomicType)keyType, SequenceType.makeSequenceType(valueType, valueCard));
    }

    @Override
    public UType getKeyUType() {
        return this.keyUType;
    }

    @Override
    public OperandRole[] getOperandRoles() {
        return new OperandRole[]{OperandRole.SINGLE_ATOMIC};
    }

    @Override
    public HashTrieMap addEntry(AtomicValue key, Sequence value2) {
        boolean empty = this.isEmpty();
        ImmutableMap<AtomicMatchKey, KeyValuePair> imap2 = this.imap.put(this.makeKey(key), new KeyValuePair(key, value2));
        HashTrieMap t2 = new HashTrieMap(imap2);
        t2.valueCardinality = this.valueCardinality;
        t2.keyUType = this.keyUType;
        t2.valueUType = this.valueUType;
        t2.keyAtomicType = this.keyAtomicType;
        t2.valueItemType = this.valueItemType;
        t2.updateTypeInformation(key, value2, empty);
        return t2;
    }

    public boolean initialPut(AtomicValue key, Sequence value2) {
        boolean empty = this.isEmpty();
        boolean exists2 = this.get(key) != null;
        this.imap = this.imap.put(this.makeKey(key), new KeyValuePair(key, value2));
        this.updateTypeInformation(key, value2, empty);
        this.entries = -1;
        return exists2;
    }

    private AtomicMatchKey makeKey(AtomicValue key) {
        return key.asMapKey();
    }

    @Override
    public HashTrieMap remove(AtomicValue key) {
        ImmutableMap<AtomicMatchKey, KeyValuePair> m2 = this.imap.remove(this.makeKey(key));
        if (m2 == this.imap) {
            return this;
        }
        HashTrieMap result2 = new HashTrieMap(m2);
        result2.keyUType = this.keyUType;
        result2.valueUType = this.valueUType;
        result2.valueCardinality = this.valueCardinality;
        result2.entries = this.entries - 1;
        return result2;
    }

    @Override
    public Sequence get(AtomicValue key) {
        KeyValuePair o = this.imap.get(this.makeKey(key));
        return o == null ? null : o.value;
    }

    public KeyValuePair getKeyValuePair(AtomicValue key) {
        return this.imap.get(this.makeKey(key));
    }

    @Override
    public AtomicIterator keys() {
        return new AtomicIterator(){
            Iterator<Tuple2<AtomicMatchKey, KeyValuePair>> base;
            {
                this.base = HashTrieMap.this.imap.iterator();
            }

            public AtomicValue next() {
                if (this.base.hasNext()) {
                    return ((KeyValuePair)this.base.next()._2).key;
                }
                return null;
            }

            public void close() {
            }

            public int getProperties() {
                return 0;
            }
        };
    }

    @Override
    public Iterator<KeyValuePair> iterator() {
        return new Iterator<KeyValuePair>(){
            Iterator<Tuple2<AtomicMatchKey, KeyValuePair>> base;
            {
                this.base = HashTrieMap.this.imap.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.base.hasNext();
            }

            @Override
            public KeyValuePair next() {
                return (KeyValuePair)this.base.next()._2;
            }

            @Override
            public void remove() {
                this.base.remove();
            }
        };
    }

    @Override
    public FunctionItemType getFunctionItemType() {
        return MapType.ANY_MAP_TYPE;
    }

    @Override
    public StructuredQName getFunctionName() {
        return null;
    }

    @Override
    public String getDescription() {
        return "map";
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    public Sequence call(XPathContext context, Sequence[] args) throws XPathException {
        AtomicValue key = (AtomicValue)args[0].head();
        Sequence value2 = this.get(key);
        if (value2 == null) {
            return EmptySequence.getInstance();
        }
        return value2;
    }

    @Override
    public String getStringValue() {
        throw new UnsupportedOperationException("A map has no string value");
    }

    @Override
    public CharSequence getStringValueCS() {
        throw new UnsupportedOperationException("A map has no string value");
    }

    public SequenceIterator getTypedValue() throws XPathException {
        throw new XPathException("A map has no typed value");
    }

    @Override
    public boolean deepEquals(Function other, XPathContext context, AtomicComparer comparer, int flags) throws XPathException {
        if (other instanceof MapItem && ((MapItem)other).size() == this.size()) {
            AtomicValue key;
            AtomicIterator keys = this.keys();
            while ((key = keys.next()) != null) {
                Sequence thisValue = this.get(key);
                Sequence otherValue = ((MapItem)other).get(key);
                if (otherValue == null) {
                    return false;
                }
                if (DeepEqual.deepEqual(otherValue.iterate(), thisValue.iterate(), comparer, context, flags)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public MapItem itemAt(int n) {
        return n == 0 ? this : null;
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        throw new XPathException("A map item has no effective boolean value");
    }

    public TupleItemType asTupleType(TypeHierarchy th) {
        AtomicValue key;
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<SequenceType> types = new ArrayList<SequenceType>();
        AtomicIterator keys = this.keys();
        while ((key = keys.next()) != null) {
            Sequence thisValue = this.get(key);
            if (!(key instanceof StringValue)) {
                return null;
            }
            SequenceType thisType = SequenceTool.getSequenceType(thisValue, th);
            names.add(key.getStringValue());
            types.add(thisType);
        }
        return new TupleItemType(names, types);
    }

    public String toString() {
        FastStringBuffer buffer = new FastStringBuffer(256);
        buffer.append("map{");
        for (KeyValuePair pair2 : this) {
            if (buffer.length() > 4) {
                buffer.append(",");
            }
            buffer.append(pair2.key.toString());
            buffer.append(":");
            buffer.append(pair2.value.toString());
        }
        buffer.append("}");
        return buffer.toString();
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("map");
        out.emitAttribute("size", this.size() + "");
        out.endElement();
    }

    @Override
    public boolean isTrustedResultType() {
        return true;
    }

    public void diagnosticDump() {
        System.err.println("Map details:");
        Iterator<Tuple2<AtomicMatchKey, KeyValuePair>> iter2 = this.imap.iterator();
        while (iter2.hasNext()) {
            Tuple2<AtomicMatchKey, KeyValuePair> entry2 = iter2.next();
            AtomicMatchKey k1 = (AtomicMatchKey)entry2._1;
            AtomicValue k2 = ((KeyValuePair)entry2._2).key;
            Sequence v = ((KeyValuePair)entry2._2).value;
            System.err.println(k1.getClass() + " " + k1 + " #:" + k1.hashCode() + " = (" + k2.getClass() + " " + k2 + " : " + v + ")");
        }
    }
}

