/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.json;

import java.util.ArrayList;
import java.util.Stack;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.SimpleArrayItem;
import net.sf.saxon.ma.json.JsonHandler;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.StringValue;

public class JsonHandlerMap
extends JsonHandler {
    Stack<Sequence> stack;
    protected Stack<String> keys;

    public JsonHandlerMap(XPathContext context, int flags) {
        this.setContext(context);
        this.stack = new Stack();
        this.keys = new Stack();
        this.escape = (flags & 1) != 0;
        this.charChecker = context.getConfiguration().getValidCharacterChecker();
    }

    public Sequence getResult() throws XPathException {
        return this.stack.peek();
    }

    public boolean setKey(String unEscaped, String reEscaped) {
        this.keys.push(reEscaped);
        HashTrieMap map2 = (HashTrieMap)this.stack.peek();
        return map2.get(new StringValue(reEscaped)) != null;
    }

    public void startArray() throws XPathException {
        SimpleArrayItem map2 = new SimpleArrayItem(new ArrayList<Sequence>());
        this.stack.push(map2);
    }

    public void endArray() throws XPathException {
        ArrayItem map2 = (ArrayItem)this.stack.pop();
        if (this.stack.empty()) {
            this.stack.push(map2);
        } else {
            this.writeItem(map2);
        }
    }

    public void startMap() throws XPathException {
        HashTrieMap map2 = new HashTrieMap();
        this.stack.push(map2);
    }

    public void endMap() throws XPathException {
        HashTrieMap map2 = (HashTrieMap)this.stack.pop();
        if (this.stack.empty()) {
            this.stack.push(map2);
        } else {
            this.writeItem(map2);
        }
    }

    private void writeItem(Sequence val) throws XPathException {
        if (this.stack.empty()) {
            this.stack.push(val);
        } else if (this.stack.peek() instanceof ArrayItem) {
            SimpleArrayItem array = (SimpleArrayItem)this.stack.peek();
            array.getMembers().add(val);
        } else {
            HashTrieMap map2 = (HashTrieMap)this.stack.peek();
            StringValue key = new StringValue(this.keys.pop());
            map2.initialPut(key, val);
        }
    }

    public void writeNumeric(String asString, double asDouble) throws XPathException {
        this.writeItem(new DoubleValue(asDouble));
    }

    public void writeString(String val) throws XPathException {
        this.writeItem(new StringValue(this.reEscape(val)));
    }

    public void writeBoolean(boolean value2) throws XPathException {
        this.writeItem(BooleanValue.get(value2));
    }

    public void writeNull() throws XPathException {
        this.writeItem(EmptySequence.getInstance());
    }
}

