/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.arrays;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.SchemaComponentVisitor;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public class ArrayItemType
extends AnyFunctionType {
    public static final ArrayItemType ANY_ARRAY_TYPE = new ArrayItemType(SequenceType.ANY_SEQUENCE);
    private SequenceType memberType;

    public ArrayItemType(SequenceType memberType) {
        this.memberType = memberType;
    }

    public SequenceType getMemberType() {
        return this.memberType;
    }

    public boolean isMapType() {
        return false;
    }

    public boolean isArrayType() {
        return true;
    }

    public boolean isAtomizable() {
        return true;
    }

    public PlainType getAtomizedItemType() {
        return this.memberType.getPrimaryType().getAtomizedItemType();
    }

    public int getArity() {
        return 1;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{BuiltInAtomicType.INTEGER.one()};
    }

    public boolean matches(Item item, TypeHierarchy th) throws XPathException {
        if (!(item instanceof ArrayItem)) {
            return false;
        }
        if (this == ANY_ARRAY_TYPE) {
            return true;
        }
        for (Sequence s2 : (ArrayItem)item) {
            if (this.memberType.matches(s2, th)) continue;
            return false;
        }
        return true;
    }

    public SequenceType getResultType() {
        return this.memberType;
    }

    public String toString() {
        if (this.equals(ANY_ARRAY_TYPE)) {
            return "array(*)";
        }
        FastStringBuffer sb = new FastStringBuffer(100);
        sb.append("array(");
        sb.append(this.memberType.toString());
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ArrayItemType) {
            ArrayItemType f2 = (ArrayItemType)other;
            return this.memberType.equals(f2.memberType);
        }
        return false;
    }

    public int hashCode() {
        return this.memberType.hashCode();
    }

    public int relationship(FunctionItemType other, TypeHierarchy th) {
        if (other == AnyFunctionType.getInstance()) {
            return 2;
        }
        if (this.equals(other)) {
            return 0;
        }
        if (other == ANY_ARRAY_TYPE) {
            return 2;
        }
        if (other.isMapType()) {
            return 4;
        }
        if (other instanceof ArrayItemType) {
            ArrayItemType f2 = (ArrayItemType)other;
            int rel = th.sequenceTypeRelationship(this.memberType, f2.memberType);
            return rel == 4 ? 3 : rel;
        }
        int rel = 4;
        return rel;
    }

    public Expression makeFunctionSequenceCoercer(Expression exp, RoleDiagnostic role) throws XPathException {
        Expression result2 = exp;
        return result2;
    }

    public void visitNamedSchemaComponents(SchemaComponentVisitor visitor) throws XPathException {
        this.memberType.getPrimaryType().visitNamedSchemaComponents(visitor);
    }

    public String generateJavaScriptItemTypeTest(ItemType knownToBe, int targetVersion) throws XPathException {
        if (this == ANY_ARRAY_TYPE) {
            return "return SaxonJS.U.isArray(item)";
        }
        if (targetVersion == 1) {
            FastStringBuffer fsb = new FastStringBuffer(256);
            fsb.append("function v(item) {" + this.memberType.getPrimaryType().generateJavaScriptItemTypeTest(AnyItemType.getInstance(), targetVersion) + "};");
            fsb.append(Cardinality.generateJavaScriptChecker(this.memberType.getCardinality()));
            fsb.append("return SaxonJS.U.isArray(item) && SaxonJS.U.ForArray(item.value).every(function(seq){return c(seq.length) && SaxonJS.U.ForArray(seq).every(v)});");
            return fsb.toString();
        }
        FastStringBuffer fsb = new FastStringBuffer(256);
        fsb.append("function v(item) {" + this.memberType.getPrimaryType().generateJavaScriptItemTypeTest(AnyItemType.getInstance(), targetVersion) + "};");
        fsb.append(Cardinality.generateJavaScriptChecker(this.memberType.getCardinality()));
        fsb.append("return SaxonJS.U.isConstrainedArray(item, v, c);");
        return fsb.toString();
    }
}

