/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.net.UnknownServiceException;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.lib.OutputURIResolver;
import net.sf.saxon.trans.XPathException;

public class StandardOutputResolver
implements OutputURIResolver {
    private static StandardOutputResolver theInstance = new StandardOutputResolver();

    public static StandardOutputResolver getInstance() {
        return theInstance;
    }

    public StandardOutputResolver newInstance() {
        return this;
    }

    public Result resolve(String href, String base) throws XPathException {
        String which = "base";
        try {
            URI absoluteURI;
            if (href.isEmpty()) {
                if (base == null) {
                    throw new XPathException("The system identifier of the principal output file is unknown");
                }
                absoluteURI = new URI(base);
            } else {
                which = "relative";
                absoluteURI = new URI(href);
            }
            if (!absoluteURI.isAbsolute()) {
                if (base == null) {
                    throw new XPathException("The system identifier of the principal output file is unknown");
                }
                which = "base";
                URI baseURI = new URI(base);
                which = "relative";
                absoluteURI = baseURI.resolve(href);
            }
            return this.createResult(absoluteURI);
        }
        catch (URISyntaxException err2) {
            throw new XPathException("Invalid syntax for " + which + " URI", err2);
        }
        catch (IllegalArgumentException err2) {
            throw new XPathException("Invalid " + which + " URI syntax", err2);
        }
        catch (MalformedURLException err3) {
            throw new XPathException("Resolved URL is malformed", err3);
        }
        catch (UnknownServiceException err5) {
            throw new XPathException("Specified protocol does not allow output", err5);
        }
        catch (IOException err4) {
            throw new XPathException("Cannot open connection to specified URL", err4);
        }
    }

    protected Result createResult(URI absoluteURI) throws XPathException, IOException {
        if ("file".equals(absoluteURI.getScheme())) {
            return StandardOutputResolver.makeOutputFile(absoluteURI);
        }
        URLConnection connection = absoluteURI.toURL().openConnection();
        connection.setDoInput(false);
        connection.setDoOutput(true);
        connection.connect();
        OutputStream stream = connection.getOutputStream();
        StreamResult result2 = new StreamResult(stream);
        result2.setSystemId(absoluteURI.toASCIIString());
        return result2;
    }

    public static synchronized Result makeOutputFile(URI absoluteURI) throws XPathException {
        try {
            return new StreamResult(new File(absoluteURI));
        }
        catch (IllegalArgumentException err2) {
            throw new XPathException("Cannot write to URI " + absoluteURI + " (" + err2.getMessage() + ")");
        }
    }

    public void close(Result result2) throws XPathException {
        if (result2 instanceof StreamResult) {
            Writer writer;
            OutputStream stream = ((StreamResult)result2).getOutputStream();
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException err2) {
                    throw new XPathException("Failed while closing output file", err2);
                }
            }
            if ((writer = ((StreamResult)result2).getWriter()) != null) {
                try {
                    writer.close();
                }
                catch (IOException err3) {
                    throw new XPathException("Failed while closing output file", err3);
                }
            }
        }
    }
}

