/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import javax.xml.transform.dom.DOMLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.instruct.Actor;
import net.sf.saxon.expr.instruct.AttributeSet;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.NamedTemplate;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.lib.Invalidity;
import net.sf.saxon.lib.InvalidityHandler;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.EmptySequence;

public class StandardInvalidityHandler
implements InvalidityHandler {
    private Configuration config;
    private Logger logger;

    public StandardInvalidityHandler(Configuration config) {
        this.config = config;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void startReporting(String systemId) throws XPathException {
    }

    public void reportInvalidity(Invalidity failure2) throws XPathException {
        Logger localLogger = this.logger;
        if (localLogger == null) {
            localLogger = this.config.getLogger();
        }
        String explanation = this.getExpandedMessage(failure2);
        String constraintReference = StandardInvalidityHandler.getConstraintReferenceMessage(failure2);
        String validationLocation = ((ValidationFailure)failure2).getValidationLocationText();
        String contextLocation = ((ValidationFailure)failure2).getContextLocationText();
        String finalMessage = "Validation error " + this.getLocationMessage(failure2) + "\n  " + StandardInvalidityHandler.wordWrap(explanation) + StandardInvalidityHandler.wordWrap(contextLocation.isEmpty() ? "" : "\n  " + contextLocation) + StandardInvalidityHandler.wordWrap(constraintReference == null ? "" : "\n  " + constraintReference) + StandardErrorListener.getOffenderListText((ValidationFailure)failure2);
        localLogger.error(finalMessage);
    }

    public String getLocationMessage(Invalidity err2) {
        boolean containsLineNumber;
        String path;
        String locMessage = "";
        String systemId = null;
        NodeInfo node = ((ValidationFailure)err2).getInvalidNode();
        String nodeMessage = null;
        int lineNumber = -1;
        Invalidity loc = err2;
        if (loc instanceof DOMLocator) {
            nodeMessage = "at " + ((DOMLocator)((Object)loc)).getOriginatingNode().getNodeName() + ' ';
        } else if (loc instanceof ValidationException && loc.getLineNumber() == -1 && (path = ((ValidationException)((Object)loc)).getPath()) != null) {
            nodeMessage = "at " + path + ' ';
        } else if (loc instanceof Instruction) {
            String instructionName = StandardErrorListener.getInstructionName((Instruction)((Object)loc));
            if (!"".equals(instructionName)) {
                nodeMessage = "at " + instructionName + ' ';
            }
            systemId = loc.getSystemId();
            lineNumber = loc.getLineNumber();
        } else if (loc instanceof Actor) {
            String kind = "procedure";
            if (loc instanceof UserFunction) {
                kind = "function";
            } else if (loc instanceof NamedTemplate) {
                kind = "template";
            } else if (loc instanceof AttributeSet) {
                kind = "attribute-set";
            } else if (loc instanceof KeyDefinition) {
                kind = "key";
            }
            systemId = loc.getSystemId();
            lineNumber = loc.getLineNumber();
            nodeMessage = "at " + kind + " ";
            StructuredQName name = ((InstructionInfo)((Object)loc)).getObjectName();
            if (name != null) {
                nodeMessage = nodeMessage + name.toString();
                nodeMessage = nodeMessage + " ";
            }
        }
        if (lineNumber == -1) {
            lineNumber = loc.getLineNumber();
        }
        boolean bl = containsLineNumber = lineNumber != -1;
        if (node != null) {
            nodeMessage = "at " + Navigator.getPath(node) + ' ';
        }
        if (nodeMessage != null) {
            locMessage = locMessage + nodeMessage;
        }
        if (containsLineNumber) {
            locMessage = locMessage + "on line " + lineNumber + ' ';
            if (loc.getColumnNumber() != -1) {
                locMessage = locMessage + "column " + loc.getColumnNumber() + ' ';
            }
        }
        if (systemId != null && systemId.isEmpty()) {
            systemId = null;
        }
        if (systemId == null) {
            systemId = loc.getSystemId();
        }
        if (systemId != null && systemId.length() != 0) {
            locMessage = locMessage + (containsLineNumber ? "of " : "in ") + StandardInvalidityHandler.abbreviatePath(systemId) + ':';
        }
        return locMessage;
    }

    public static String abbreviatePath(String uri) {
        if (uri == null) {
            return "*unknown*";
        }
        int slash = uri.lastIndexOf(47);
        if (slash >= 0 && slash < uri.length() - 1) {
            return uri.substring(slash + 1);
        }
        return uri;
    }

    public String getExpandedMessage(Invalidity err2) {
        String code = err2.getErrorCode();
        return (code == null ? "" : code + ": ") + err2.getMessage();
    }

    private static String wordWrap(String message) {
        return StandardErrorListener.wordWrap(message);
    }

    public static String getConstraintReferenceMessage(Invalidity err2) {
        if (err2.getSchemaPart() == -1) {
            return null;
        }
        return "See http://www.w3.org/TR/xmlschema-" + err2.getSchemaPart() + "/#" + err2.getConstraintName() + " clause " + err2.getConstraintClauseNumber();
    }

    public Sequence endReporting() throws XPathException {
        return EmptySequence.getInstance();
    }
}

