/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.ContentHandlerProxy;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceNormalizer;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.SequenceWriter;
import net.sf.saxon.event.Sink;
import net.sf.saxon.event.StreamWriterToReceiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.lib.ExternalObjectModel;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.SaxonOutputKeys;
import net.sf.saxon.lib.StAXResultHandler;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.query.SequenceWrapper;
import net.sf.saxon.serialize.AdaptiveEmitter;
import net.sf.saxon.serialize.CDATAFilter;
import net.sf.saxon.serialize.CharacterMap;
import net.sf.saxon.serialize.CharacterMapExpander;
import net.sf.saxon.serialize.CharacterMapIndex;
import net.sf.saxon.serialize.Emitter;
import net.sf.saxon.serialize.HTML40Emitter;
import net.sf.saxon.serialize.HTML50Emitter;
import net.sf.saxon.serialize.HTMLEmitter;
import net.sf.saxon.serialize.HTMLIndenter;
import net.sf.saxon.serialize.HTMLURIEscaper;
import net.sf.saxon.serialize.JSONEmitter;
import net.sf.saxon.serialize.MetaTagAdjuster;
import net.sf.saxon.serialize.SerializationParamsHandler;
import net.sf.saxon.serialize.TEXTEmitter;
import net.sf.saxon.serialize.UncommittedSerializer;
import net.sf.saxon.serialize.UnicodeNormalizer;
import net.sf.saxon.serialize.XHTML1Emitter;
import net.sf.saxon.serialize.XHTML5Emitter;
import net.sf.saxon.serialize.XHTMLPrefixRemover;
import net.sf.saxon.serialize.XHTMLURIEscaper;
import net.sf.saxon.serialize.XML10ContentChecker;
import net.sf.saxon.serialize.XMLEmitter;
import net.sf.saxon.serialize.XMLIndenter;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BigDecimalValue;

public class SerializerFactory {
    Configuration config;
    private static Class staxResultClass;
    private static Pattern publicIdPattern;

    public SerializerFactory(Configuration config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public StreamWriterToReceiver getXMLStreamWriter(StreamResult result2, Properties properties) throws XPathException {
        SequenceReceiver r = this.getReceiver(result2, this.config.makePipelineConfiguration(), properties);
        r = new NamespaceReducer(r);
        return new StreamWriterToReceiver(r);
    }

    public SequenceReceiver getReceiver(Result result2, PipelineConfiguration pipe, Properties props) throws XPathException {
        if (pipe.getController() != null) {
            return this.getReceiver(result2, pipe, props, pipe.getController().getExecutable().getCharacterMapIndex());
        }
        return this.getReceiver(result2, pipe, props, null);
    }

    public SequenceReceiver getReceiver(Result result2, PipelineConfiguration pipe, Properties props, CharacterMapIndex charMapIndex) throws XPathException {
        String nextInChain = props.getProperty("{http://saxon.sf.net/}next-in-chain");
        if (nextInChain != null && !nextInChain.isEmpty()) {
            String href = props.getProperty("{http://saxon.sf.net/}next-in-chain");
            String base = props.getProperty("{http://saxon.sf.net/}next-in-chain-base-uri");
            if (base == null) {
                base = "";
            }
            Properties sansNext = new Properties(props);
            sansNext.setProperty("{http://saxon.sf.net/}next-in-chain", "");
            return this.prepareNextStylesheet(pipe, href, base, result2);
        }
        String paramDoc = props.getProperty("parameter-document");
        if (paramDoc != null) {
            Source source;
            String base = props.getProperty("{http://saxon.sf.net/}parameter-document-base-uri");
            if (base == null) {
                base = result2.getSystemId();
            }
            Properties props2 = new Properties(props);
            try {
                source = pipe.getConfiguration().getURIResolver().resolve(paramDoc, base);
            }
            catch (TransformerException e) {
                throw XPathException.makeXPathException(e);
            }
            ParseOptions options = new ParseOptions();
            options.setSchemaValidationMode(2);
            TreeInfo doc = pipe.getConfiguration().buildDocumentTree(source);
            SerializationParamsHandler ph = new SerializationParamsHandler();
            ph.setSerializationParams(doc.getRootNode());
            Properties paramDocProps = ph.getSerializationProperties();
            Enumeration<?> names = paramDocProps.propertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value2 = paramDocProps.getProperty(name);
                props2.setProperty(name, value2);
            }
            props = props2;
            CharacterMap characterMap = ph.getCharacterMap();
            if (characterMap != null) {
                CharacterMapIndex index2 = new CharacterMapIndex();
                charMapIndex.putCharacterMap(characterMap.getName(), characterMap);
                props.setProperty("use-character-maps", characterMap.getName().getClarkName());
            }
        }
        if (result2 instanceof Emitter) {
            if (((Emitter)result2).getOutputProperties() == null) {
                ((Emitter)result2).setOutputProperties(props);
            }
            return (Emitter)result2;
        }
        if (result2 instanceof JSONEmitter) {
            if (((JSONEmitter)result2).getOutputProperties() == null) {
                ((JSONEmitter)result2).setOutputProperties(props);
            }
            return (JSONEmitter)result2;
        }
        if (result2 instanceof AdaptiveEmitter) {
            if (((AdaptiveEmitter)result2).getOutputProperties() == null) {
                ((AdaptiveEmitter)result2).setOutputProperties(props);
            }
            return (AdaptiveEmitter)result2;
        }
        if (result2 instanceof ComplexContentOutputter) {
            return (ComplexContentOutputter)result2;
        }
        if (result2 instanceof Receiver) {
            Receiver receiver = (Receiver)result2;
            receiver.setSystemId(result2.getSystemId());
            receiver.setPipelineConfiguration(pipe);
            ComplexContentOutputter out = new ComplexContentOutputter(pipe);
            out.setHostLanguage(pipe.getHostLanguage());
            out.setReceiver(receiver);
            return out;
        }
        if (result2 instanceof SAXResult) {
            ContentHandlerProxy proxy = this.newContentHandlerProxy();
            proxy.setUnderlyingContentHandler(((SAXResult)result2).getHandler());
            proxy.setPipelineConfiguration(pipe);
            proxy.setOutputProperties(props);
            if ("yes".equals(props.getProperty("{http://saxon.sf.net/}supply-source-locator"))) {
                if (pipe.getConfiguration().isCompileWithTracing()) {
                    pipe.getController().addTraceListener(proxy.getTraceListener());
                } else {
                    throw new XPathException("Cannot use saxon:supply-source-locator unless tracing was enabled at compile time", "SXSE0002");
                }
            }
            return this.makeSequenceNormalizer(proxy, props);
        }
        if (result2 instanceof StreamResult) {
            StreamResult sr;
            SequenceReceiver target;
            String method = props.getProperty("method");
            if (method == null) {
                return this.newUncommittedSerializer(result2, new Sink(pipe), props, charMapIndex);
            }
            Emitter emitter = null;
            CharacterMapExpander characterMapExpander = null;
            String useMaps = props.getProperty("use-character-maps");
            if (useMaps != null) {
                if (charMapIndex == null) {
                    XPathException de = new XPathException("Cannot use character maps in an environment with no Controller");
                    de.setErrorCode("SXSE0001");
                    throw de;
                }
                characterMapExpander = charMapIndex.makeCharacterMapExpander(useMaps, new Sink(pipe), this);
            }
            ProxyReceiver normalizer = null;
            String normForm = props.getProperty("normalization-form");
            if (normForm != null && !normForm.equals("none")) {
                normalizer = this.newUnicodeNormalizer(new Sink(pipe), props);
            }
            if ("html".equals(method)) {
                emitter = this.newHTMLEmitter(props);
                emitter.setPipelineConfiguration(pipe);
                target = this.createHTMLSerializer(emitter, props, pipe, characterMapExpander, normalizer);
            } else if ("xml".equals(method)) {
                emitter = this.newXMLEmitter(props);
                emitter.setPipelineConfiguration(pipe);
                target = this.createXMLSerializer((XMLEmitter)emitter, props, pipe, characterMapExpander, normalizer);
            } else if ("xhtml".equals(method)) {
                emitter = this.newXHTMLEmitter(props);
                emitter.setPipelineConfiguration(pipe);
                target = this.createXHTMLSerializer(emitter, props, pipe, characterMapExpander, normalizer);
            } else if ("text".equals(method)) {
                emitter = this.newTEXTEmitter();
                emitter.setPipelineConfiguration(pipe);
                target = this.createTextSerializer(emitter, props, characterMapExpander, normalizer);
            } else {
                if ("json".equals(method)) {
                    sr = (StreamResult)result2;
                    props.setProperty("omit-xml-declaration", "yes");
                    JSONEmitter je = new JSONEmitter(pipe, sr, props);
                    return this.customizeJSONSerializer(je, props, characterMapExpander, normalizer);
                }
                if ("adaptive".equals(method)) {
                    TEXTEmitter te = new TEXTEmitter();
                    te.setPipelineConfiguration(pipe);
                    te.setOutputProperties(props);
                    Writer writer = ((StreamResult)result2).getWriter();
                    if (writer == null) {
                        OutputStream os = ((StreamResult)result2).getOutputStream();
                        String encoding = props.getProperty("encoding");
                        if (encoding == null) {
                            encoding = "UTF-8";
                        }
                        try {
                            writer = new OutputStreamWriter(os, encoding);
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new XPathException(e);
                        }
                    }
                    AdaptiveEmitter je = new AdaptiveEmitter(pipe, writer);
                    je.setOutputProperties(props);
                    StreamResult sr2 = (StreamResult)result2;
                    te.setStreamResult(sr2);
                    return this.customizeAdaptiveSerializer(je, props, characterMapExpander, normalizer);
                }
                if (method.startsWith("{http://saxon.sf.net/}")) {
                    target = this.createSaxonSerializationMethod(method, props, pipe, characterMapExpander, normalizer);
                    if (target instanceof Emitter) {
                        emitter = (Emitter)target;
                    }
                } else {
                    SequenceReceiver userReceiver;
                    if (pipe == null) {
                        throw new XPathException("Unsupported serialization method " + method);
                    }
                    target = userReceiver = this.createUserDefinedOutputMethod(method, props, pipe);
                    if (userReceiver instanceof Emitter) {
                        emitter = (Emitter)userReceiver;
                    } else {
                        return userReceiver;
                    }
                }
            }
            if (emitter != null) {
                emitter.setOutputProperties(props);
                sr = (StreamResult)result2;
                emitter.setStreamResult(sr);
            }
            return target;
        }
        if (staxResultClass != null && staxResultClass.isAssignableFrom(result2.getClass())) {
            StAXResultHandler handler = (StAXResultHandler)this.config.getDynamicLoader().getInstance("net.sf.saxon.stax.StAXResultHandlerImpl", this.getClass().getClassLoader());
            Receiver r = handler.getReceiver(result2, props);
            r.setPipelineConfiguration(pipe);
            return this.makeSequenceNormalizer(r, props);
        }
        if (pipe != null) {
            List<ExternalObjectModel> externalObjectModels = pipe.getConfiguration().getExternalObjectModels();
            for (ExternalObjectModel externalObjectModel : externalObjectModels) {
                ExternalObjectModel model = externalObjectModel;
                Receiver builder = model.getDocumentBuilder(result2);
                if (builder == null) continue;
                builder.setSystemId(result2.getSystemId());
                builder.setPipelineConfiguration(pipe);
                return new TreeReceiver(builder);
            }
        }
        throw new IllegalArgumentException("Unknown type of result: " + result2.getClass());
    }

    protected SequenceReceiver makeSequenceNormalizer(Receiver receiver, Properties properties) {
        NamespaceReducer ne = new NamespaceReducer(receiver);
        ne.setSystemId(receiver.getSystemId());
        PipelineConfiguration pipe = receiver.getPipelineConfiguration();
        if (properties.getProperty("item-separator") == null) {
            ComplexContentOutputter out = new ComplexContentOutputter(pipe);
            out.setHostLanguage(pipe.getHostLanguage());
            out.setSerializing(true);
            out.setReceiver(ne);
            return out;
        }
        SequenceNormalizer sn = new SequenceNormalizer(ne, properties.getProperty("item-separator"));
        sn.setPipelineConfiguration(pipe);
        return sn;
    }

    protected SequenceReceiver createHTMLSerializer(Emitter emitter, Properties props, PipelineConfiguration pipe, CharacterMapExpander characterMapExpander, ProxyReceiver normalizer) throws XPathException {
        String attributeOrder;
        String cdataElements;
        Receiver target = emitter;
        if (!"no".equals(props.getProperty("indent"))) {
            target = this.newHTMLIndenter(target, props);
        }
        if (normalizer != null) {
            normalizer.setUnderlyingReceiver(target);
            target = normalizer;
        }
        if (characterMapExpander != null) {
            characterMapExpander.setUnderlyingReceiver(target);
            target = characterMapExpander;
        }
        if ((cdataElements = props.getProperty("cdata-section-elements")) != null && cdataElements.length() > 0) {
            target = this.newCDATAFilter(target, props);
        }
        if (SaxonOutputKeys.isHtmlVersion5(props)) {
            target = this.addHtml5Component(target, props);
        }
        if (!"no".equals(props.getProperty("escape-uri-attributes"))) {
            target = this.newHTMLURIEscaper(target, props);
        }
        if (!"no".equals(props.getProperty("include-content-type"))) {
            target = this.newHTMLMetaTagAdjuster(target, props);
        }
        if ((attributeOrder = props.getProperty("{http://saxon.sf.net/}attribute-order")) != null && attributeOrder.length() > 0) {
            target = this.newAttributeSorter(target, props);
        }
        return this.makeSequenceNormalizer(target, props);
    }

    protected SequenceReceiver createTextSerializer(Emitter emitter, Properties props, CharacterMapExpander characterMapExpander, ProxyReceiver normalizer) throws XPathException {
        Receiver target = emitter;
        if (characterMapExpander != null) {
            characterMapExpander.setUnderlyingReceiver(target);
            characterMapExpander.setUseNullMarkers(false);
            target = characterMapExpander;
        }
        if (normalizer != null) {
            normalizer.setUnderlyingReceiver(target);
            target = normalizer;
        }
        target = this.addTextOutputFilter(target, props);
        return this.makeSequenceNormalizer(target, props);
    }

    protected SequenceReceiver customizeJSONSerializer(JSONEmitter emitter, Properties props, CharacterMapExpander characterMapExpander, ProxyReceiver normalizer) throws XPathException {
        if (normalizer instanceof UnicodeNormalizer) {
            emitter.setNormalizer(((UnicodeNormalizer)normalizer).getNormalizer());
        }
        if (characterMapExpander != null) {
            emitter.setCharacterMap(characterMapExpander.getCharacterMap());
        }
        return emitter;
    }

    protected SequenceReceiver customizeAdaptiveSerializer(AdaptiveEmitter emitter, Properties props, CharacterMapExpander characterMapExpander, ProxyReceiver normalizer) throws XPathException {
        return emitter;
    }

    protected SequenceReceiver createXHTMLSerializer(Emitter emitter, Properties props, PipelineConfiguration pipe, CharacterMapExpander characterMapExpander, ProxyReceiver normalizer) throws XPathException {
        String attributeOrder;
        String cdataElements;
        Receiver target = emitter;
        if (!"no".equals(props.getProperty("indent"))) {
            target = this.newXHTMLIndenter(target, props);
        }
        if (normalizer != null) {
            normalizer.setUnderlyingReceiver(target);
            target = normalizer;
        }
        if (characterMapExpander != null) {
            characterMapExpander.setUnderlyingReceiver(target);
            characterMapExpander.setPipelineConfiguration(pipe);
            target = characterMapExpander;
        }
        if ((cdataElements = props.getProperty("cdata-section-elements")) != null && cdataElements.length() > 0) {
            target = this.newCDATAFilter(target, props);
        }
        if (SaxonOutputKeys.isXhtmlHtmlVersion5(props)) {
            target = this.addHtml5Component(target, props);
        }
        if (!"no".equals(props.getProperty("escape-uri-attributes"))) {
            target = this.newXHTMLURIEscaper(target, props);
        }
        if (!"no".equals(props.getProperty("include-content-type"))) {
            target = this.newXHTMLMetaTagAdjuster(target, props);
        }
        if ((attributeOrder = props.getProperty("{http://saxon.sf.net/}attribute-order")) != null && attributeOrder.length() > 0) {
            target = this.newAttributeSorter(target, props);
        }
        return this.makeSequenceNormalizer(target, props);
    }

    public Receiver addHtml5Component(Receiver target, Properties outputProperties) {
        target = new NamespaceReducer(target);
        target = new XHTMLPrefixRemover(target);
        return target;
    }

    protected SequenceReceiver createXMLSerializer(XMLEmitter emitter, Properties props, PipelineConfiguration pipe, CharacterMapExpander characterMapExpander, ProxyReceiver normalizer) throws XPathException {
        String attributeOrder;
        String cdataElements;
        Receiver target = "yes".equals(props.getProperty("indent")) ? this.newXMLIndenter(emitter, props) : emitter;
        if ("1.0".equals(props.getProperty("version")) && pipe.getConfiguration().getXMLVersion() == 11) {
            target = this.newXML10ContentChecker(target, props);
        }
        if (normalizer != null) {
            normalizer.setUnderlyingReceiver(target);
            target = normalizer;
        }
        if (characterMapExpander != null) {
            characterMapExpander.setUnderlyingReceiver(target);
            target = characterMapExpander;
        }
        if ((cdataElements = props.getProperty("cdata-section-elements")) != null && cdataElements.length() > 0) {
            target = this.newCDATAFilter(target, props);
        }
        if ((attributeOrder = props.getProperty("{http://saxon.sf.net/}attribute-order")) != null && attributeOrder.length() > 0) {
            target = this.newAttributeSorter(target, props);
        }
        return this.makeSequenceNormalizer(target, props);
    }

    protected SequenceReceiver createSaxonSerializationMethod(String method, Properties props, PipelineConfiguration pipe, CharacterMapExpander characterMapExpander, ProxyReceiver normalizer) throws XPathException {
        throw new XPathException("Saxon serialization methods require Saxon-PE to be enabled");
    }

    protected SequenceReceiver createUserDefinedOutputMethod(String method, Properties props, PipelineConfiguration pipe) throws XPathException {
        Receiver userReceiver = pipe.getConfiguration().makeEmitter(method, props);
        userReceiver.setPipelineConfiguration(pipe);
        if (userReceiver instanceof ContentHandlerProxy && "yes".equals(props.getProperty("{http://saxon.sf.net/}supply-source-locator"))) {
            if (pipe.getConfiguration().isCompileWithTracing()) {
                pipe.getController().addTraceListener(((ContentHandlerProxy)userReceiver).getTraceListener());
            } else {
                throw new XPathException("Cannot use saxon:supply-source-locator unless tracing was enabled at compile time", "SXSE0002");
            }
        }
        return userReceiver instanceof SequenceReceiver ? (SequenceReceiver)userReceiver : new TreeReceiver(userReceiver);
    }

    protected ContentHandlerProxy newContentHandlerProxy() {
        return new ContentHandlerProxy();
    }

    protected UncommittedSerializer newUncommittedSerializer(Result result2, Receiver next2, Properties properties, CharacterMapIndex charMap) {
        return new UncommittedSerializer(result2, next2, properties, charMap);
    }

    protected Emitter newXMLEmitter(Properties properties) {
        return new XMLEmitter();
    }

    protected Emitter newHTMLEmitter(Properties properties) {
        HTMLEmitter emitter = SaxonOutputKeys.isHtmlVersion5(properties) ? new HTML50Emitter() : new HTML40Emitter();
        return emitter;
    }

    protected Emitter newXHTMLEmitter(Properties properties) {
        boolean is5 = SaxonOutputKeys.isXhtmlHtmlVersion5(properties);
        XMLEmitter emitter = is5 ? new XHTML5Emitter() : new XHTML1Emitter();
        return emitter;
    }

    public Receiver addTextOutputFilter(Receiver next2, Properties properties) throws XPathException {
        return next2;
    }

    protected Emitter newTEXTEmitter() {
        return new TEXTEmitter();
    }

    protected SequenceWriter newAdaptiveEmitter(PipelineConfiguration pipe, Writer writer) {
        return new AdaptiveEmitter(pipe, writer);
    }

    protected ProxyReceiver newXMLIndenter(XMLEmitter next2, Properties outputProperties) {
        XMLIndenter r = new XMLIndenter(next2);
        r.setOutputProperties(outputProperties);
        return r;
    }

    protected ProxyReceiver newHTMLIndenter(Receiver next2, Properties outputProperties) {
        return new HTMLIndenter(next2, "html");
    }

    protected ProxyReceiver newXHTMLIndenter(Receiver next2, Properties outputProperties) {
        return new HTMLIndenter(next2, "xhtml");
    }

    protected MetaTagAdjuster newXHTMLMetaTagAdjuster(Receiver next2, Properties outputProperties) {
        MetaTagAdjuster r = new MetaTagAdjuster(next2);
        r.setIsXHTML(true);
        r.setOutputProperties(outputProperties);
        return r;
    }

    protected MetaTagAdjuster newHTMLMetaTagAdjuster(Receiver next2, Properties outputProperties) {
        MetaTagAdjuster r = new MetaTagAdjuster(next2);
        r.setIsXHTML(false);
        r.setOutputProperties(outputProperties);
        return r;
    }

    protected ProxyReceiver newHTMLURIEscaper(Receiver next2, Properties outputProperties) {
        return new HTMLURIEscaper(next2);
    }

    protected ProxyReceiver newXHTMLURIEscaper(Receiver next2, Properties outputProperties) {
        return new XHTMLURIEscaper(next2);
    }

    protected ProxyReceiver newCDATAFilter(Receiver next2, Properties outputProperties) throws XPathException {
        CDATAFilter r = new CDATAFilter(next2);
        r.setOutputProperties(outputProperties);
        return r;
    }

    protected Receiver newAttributeSorter(Receiver next2, Properties outputProperties) throws XPathException {
        return next2;
    }

    protected ProxyReceiver newXML10ContentChecker(Receiver next2, Properties outputProperties) {
        return new XML10ContentChecker(next2);
    }

    protected ProxyReceiver newUnicodeNormalizer(Receiver next2, Properties outputProperties) throws XPathException {
        String normForm = outputProperties.getProperty("normalization-form");
        return new UnicodeNormalizer(normForm, next2);
    }

    public CharacterMapExpander newCharacterMapExpander(Receiver next2) {
        return new CharacterMapExpander(next2);
    }

    public SequenceReceiver prepareNextStylesheet(PipelineConfiguration pipe, String href, String baseURI, Result result2) throws XPathException {
        pipe.getConfiguration().checkLicensedFeature(8, "saxon:next-in-chain", -1);
        return null;
    }

    public SequenceWrapper newSequenceWrapper(Receiver destination) {
        return new SequenceWrapper(destination);
    }

    public String checkOutputProperty(String key, String value2) throws XPathException {
        if (!key.startsWith("{")) {
            if (key.equals("allow-duplicate-names")) {
                if (value2 != null) {
                    value2 = SerializerFactory.checkYesOrNo(key, value2);
                }
            } else if (key.equals("build-tree")) {
                if (value2 != null) {
                    value2 = SerializerFactory.checkYesOrNo(key, value2);
                }
            } else if (key.equals("byte-order-mark")) {
                if (value2 != null) {
                    value2 = SerializerFactory.checkYesOrNo(key, value2);
                }
            } else if (key.equals("cdata-section-elements")) {
                if (value2 != null) {
                    SerializerFactory.checkListOfClarkNames(key, value2);
                }
            } else if (key.equals("doctype-public")) {
                if (value2 != null) {
                    SerializerFactory.checkPublicIdentifier(value2);
                }
            } else if (key.equals("doctype-system")) {
                if (value2 != null) {
                    SerializerFactory.checkSystemIdentifier(value2);
                }
            } else if (!key.equals("encoding")) {
                if (key.equals("escape-uri-attributes")) {
                    if (value2 != null) {
                        value2 = SerializerFactory.checkYesOrNo(key, value2);
                    }
                } else if (key.equals("html-version")) {
                    if (value2 != null) {
                        SerializerFactory.checkDecimal(key, value2);
                    }
                } else if (key.equals("include-content-type")) {
                    if (value2 != null) {
                        value2 = SerializerFactory.checkYesOrNo(key, value2);
                    }
                } else if (key.equals("indent")) {
                    if (value2 != null) {
                        value2 = SerializerFactory.checkYesOrNo(key, value2);
                    }
                } else if (!key.equals("item-separator")) {
                    if (key.equals("method") || key.equals("json-node-output-method")) {
                        if (value2 != null) {
                            this.checkMethod(key, value2);
                        }
                    } else if (!key.equals("media-type")) {
                        if (key.equals("normalization-form")) {
                            if (value2 != null) {
                                SerializerFactory.checkNormalizationForm(value2);
                            }
                        } else if (key.equals("omit-xml-declaration")) {
                            if (value2 != null) {
                                value2 = SerializerFactory.checkYesOrNo(key, value2);
                            }
                        } else if (key.equals("standalone")) {
                            if (value2 != null && !value2.equals("omit")) {
                                value2 = SerializerFactory.checkYesOrNo(key, value2);
                            }
                        } else if (key.equals("suppress-indentation")) {
                            if (value2 != null) {
                                SerializerFactory.checkListOfClarkNames(key, value2);
                            }
                        } else if (key.equals("undeclare-prefixes")) {
                            if (value2 != null) {
                                value2 = SerializerFactory.checkYesOrNo(key, value2);
                            }
                        } else if (key.equals("use-character-maps")) {
                            if (value2 != null) {
                                SerializerFactory.checkListOfClarkNames(key, value2);
                            }
                        } else if (!key.equals("version") && !key.equals("parameter-document")) {
                            throw new XPathException("Unknown serialization parameter " + Err.wrap(key), "XQST0109");
                        }
                    }
                }
            }
        } else if (key.startsWith("{http://saxon.sf.net/}") && !key.equals("{http://saxon.sf.net/}stylesheet-version") && !key.equals("{http://saxon.sf.net/}parameter-document-base-uri")) {
            if (key.equals("{http://saxon.sf.net/}supply-source-locator")) {
                if (value2 != null) {
                    value2 = SerializerFactory.checkYesOrNo(key, value2);
                }
            } else if (key.equals("{http://saxon.sf.net/}unfailing")) {
                if (value2 != null) {
                    value2 = SerializerFactory.checkYesOrNo(key, value2);
                }
            } else {
                throw new XPathException("Serialization parameter " + Err.wrap(key) + " not available in Saxon-HE", "XQST0109");
            }
        }
        return value2;
    }

    protected static String checkYesOrNo(String key, String value2) throws XPathException {
        if ("yes".equals(value2) || "true".equals(value2) || "1".equals(value2)) {
            return "yes";
        }
        if ("no".equals(value2) || "false".equals(value2) || "0".equals(value2)) {
            return "no";
        }
        throw new XPathException("Serialization parameter " + Err.wrap(key) + " must have the value yes|no, true|false, or 1|0", "SEPM0016");
    }

    private void checkMethod(String key, String value2) throws XPathException {
        if (!("xml".equals(value2) || "html".equals(value2) || "xhtml".equals(value2) || "text".equals(value2))) {
            if (!"json-node-output-method".equals(key) && ("json".equals(value2) || "adaptive".equals(value2))) {
                return;
            }
            if (SerializerFactory.isValidClarkName(value2)) {
                this.checkExtensions(value2);
            } else {
                throw new XPathException("Invalid value for serialization method: must be xml|html|xhtml|text|json|adaptive, or a QName in '{uri}local' form", "SEPM0016");
            }
        }
    }

    private static void checkNormalizationForm(String value2) throws XPathException {
        if (!NameChecker.isValidNmtoken(value2)) {
            throw new XPathException("Invalid value for normalization-form: must be NFC, NFD, NFKC, NFKD, fully-normalized, or none", "SEPM0016");
        }
    }

    private static boolean isValidClarkName(String value2) {
        if (value2.isEmpty() || value2.charAt(0) != '{') {
            return false;
        }
        int closer = value2.indexOf(125);
        return closer >= 1 && closer != value2.length() - 1 && NameChecker.isValidNCName(value2.substring(closer + 1));
    }

    protected static void checkNonNegativeInteger(String key, String value2) throws XPathException {
        try {
            int n = Integer.parseInt(value2);
            if (n < 0) {
                throw new XPathException("Value of " + Err.wrap(key) + " must be a non-negative integer", "SEPM0016");
            }
        }
        catch (NumberFormatException err2) {
            throw new XPathException("Value of " + Err.wrap(key) + " must be a non-negative integer", "SEPM0016");
        }
    }

    private static void checkDecimal(String key, String value2) throws XPathException {
        if (!BigDecimalValue.castableAsDecimal(value2)) {
            throw new XPathException("Value of " + Err.wrap(key) + " must be a decimal number", "SEPM0016");
        }
    }

    protected static void checkListOfClarkNames(String key, String value2) throws XPathException {
        StringTokenizer tok = new StringTokenizer(value2, " \t\n\r", false);
        while (tok.hasMoreTokens()) {
            String s2 = tok.nextToken();
            if (SerializerFactory.isValidClarkName(s2) || NameChecker.isValidNCName(s2)) continue;
            throw new XPathException("Value of " + Err.wrap(key) + " must be a list of QNames in '{uri}local' notation", "SEPM0016");
        }
    }

    private static void checkPublicIdentifier(String value2) throws XPathException {
        if (!publicIdPattern.matcher(value2).matches()) {
            throw new XPathException("Invalid character in doctype-public parameter", "SEPM0016");
        }
    }

    private static void checkSystemIdentifier(String value2) throws XPathException {
        if (value2.contains("'") && value2.contains("\"")) {
            throw new XPathException("The doctype-system parameter must not contain both an apostrophe and a quotation mark", "SEPM0016");
        }
    }

    public static String parseListOfNodeNames(String value2, NamespaceResolver nsResolver, boolean useDefaultNS, boolean prevalidated, String errorCode) throws XPathException {
        String s2 = "";
        StringTokenizer st = new StringTokenizer(value2, " \t\n\r", false);
        while (st.hasMoreTokens()) {
            String displayname = st.nextToken();
            if (prevalidated || nsResolver == null) {
                s2 = s2 + ' ' + displayname;
                continue;
            }
            if (displayname.startsWith("Q{")) {
                s2 = s2 + ' ' + displayname.substring(1);
                continue;
            }
            try {
                String[] parts = NameChecker.getQNameParts(displayname);
                String muri = nsResolver.getURIForPrefix(parts[0], useDefaultNS);
                if (muri == null) {
                    throw new XPathException("Namespace prefix '" + parts[0] + "' has not been declared", errorCode);
                }
                s2 = s2 + " {" + muri + '}' + parts[1];
            }
            catch (QNameException err2) {
                throw new XPathException("Invalid element name. " + err2.getMessage(), errorCode);
            }
        }
        return s2;
    }

    protected void checkExtensions(String key) throws XPathException {
        throw new XPathException("Serialization property " + Err.wrap(key) + " is not available in Saxon-HE");
    }

    static {
        try {
            staxResultClass = Class.forName("javax.xml.transform.stax.StAXResult");
        }
        catch (Exception exception) {
            // empty catch block
        }
        publicIdPattern = Pattern.compile("^[\\s\\r\\na-zA-Z0-9\\-'()+,./:=?;!*#@$_%]*$");
    }
}

