/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.jaxp;

import java.io.IOException;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Version;
import net.sf.saxon.jaxp.AbstractXMLFilter;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.SAXDestination;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Xslt30Transformer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class StreamingFilterImpl
extends AbstractXMLFilter {
    private Xslt30Transformer transformer;

    StreamingFilterImpl(Xslt30Transformer transformer) {
        this.transformer = transformer;
    }

    public void parse(InputSource input2) throws IOException, SAXException {
        if (this.parser == null) {
            try {
                this.parser = Version.platform.loadParser();
            }
            catch (Exception err2) {
                throw new SAXException(err2);
            }
        }
        if (this.lexicalHandler != null && this.lexicalHandler != this.contentHandler) {
            throw new IllegalStateException("ContentHandler and LexicalHandler must be the same object");
        }
        SAXSource source = new SAXSource();
        source.setInputSource(input2);
        source.setXMLReader(this.parser);
        SAXDestination result2 = new SAXDestination(this.contentHandler);
        try {
            this.transformer.applyTemplates(source, (Destination)result2);
        }
        catch (SaxonApiException err3) {
            throw new SAXException(err3);
        }
    }

    public Xslt30Transformer getTransformer() {
        return this.transformer;
    }
}

