/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.jaxp;

import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.jaxp.IdentityTransformer;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.om.AllElementsSpaceStrippingRule;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.SAXException;

public class IdentityTransformerHandler
extends ReceivingContentHandler
implements TransformerHandler {
    private Result result;
    private String systemId;
    private IdentityTransformer controller;

    protected IdentityTransformerHandler(IdentityTransformer controller) {
        this.controller = controller;
        this.setPipelineConfiguration(controller.getConfiguration().makePipelineConfiguration());
    }

    public Transformer getTransformer() {
        return this.controller;
    }

    public void setSystemId(String url) {
        this.systemId = url;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setResult(Result result2) {
        if (result2 == null) {
            throw new IllegalArgumentException("Result must not be null");
        }
        this.result = result2;
    }

    public Result getResult() {
        return this.result;
    }

    public void startDocument() throws SAXException {
        if (this.result == null) {
            this.result = new StreamResult(System.out);
        }
        try {
            Properties props = this.controller.getOutputProperties();
            Configuration config = this.getConfiguration();
            PipelineConfiguration pipe = config.makePipelineConfiguration();
            SerializerFactory sf = config.getSerializerFactory();
            SequenceReceiver out = sf.getReceiver(this.result, pipe, props);
            this.setPipelineConfiguration(pipe);
            if (config.isStripsAllWhiteSpace()) {
                out = new Stripper(AllElementsSpaceStrippingRule.getInstance(), out);
            }
            this.setReceiver(out);
        }
        catch (XPathException err2) {
            throw new SAXException(err2);
        }
        super.startDocument();
    }
}

