/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.jaxp;

import java.util.Enumeration;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.lib.DelegatingErrorListener;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.SAXParseException;

public class IdentityTransformer
extends Transformer {
    private Configuration configuration;
    private Properties localOutputProperties;
    private URIResolver uriResolver;
    private ErrorListener errorListener;

    protected IdentityTransformer(Configuration config) {
        this.configuration = config;
        this.uriResolver = config.getURIResolver();
    }

    public void reset() {
        this.localOutputProperties = null;
        this.uriResolver = this.getConfiguration().getURIResolver();
        this.errorListener = null;
    }

    public void setURIResolver(URIResolver resolver) {
        this.uriResolver = resolver;
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public void setErrorListener(ErrorListener listener) throws IllegalArgumentException {
        this.errorListener = listener;
    }

    public ErrorListener getErrorListener() {
        if (this.errorListener instanceof DelegatingErrorListener) {
            return ((DelegatingErrorListener)this.errorListener).getBaseErrorListener();
        }
        return this.errorListener;
    }

    public void setOutputProperties(Properties properties) {
        if (properties == null) {
            this.localOutputProperties = null;
        } else {
            for (String key : properties.stringPropertyNames()) {
                this.setOutputProperty(key, properties.getProperty(key));
            }
        }
    }

    public Properties getOutputProperties() {
        String key;
        Properties newProps = new Properties();
        Properties sheetProperties = this.getStylesheetOutputProperties();
        Enumeration<?> keys = sheetProperties.propertyNames();
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            newProps.setProperty(key, sheetProperties.getProperty(key));
        }
        if (this.localOutputProperties != null) {
            keys = this.localOutputProperties.propertyNames();
            while (keys.hasMoreElements()) {
                key = (String)keys.nextElement();
                newProps.setProperty(key, this.localOutputProperties.getProperty(key));
            }
        }
        return newProps;
    }

    protected Properties getStylesheetOutputProperties() {
        return new Properties();
    }

    protected Properties getLocalOutputProperties() {
        if (this.localOutputProperties == null) {
            this.makeLocalOutputProperties();
        }
        return this.localOutputProperties;
    }

    private void makeLocalOutputProperties() {
        this.localOutputProperties = new Properties();
    }

    public String getOutputProperty(String name) throws IllegalArgumentException {
        try {
            this.getConfiguration().getSerializerFactory().checkOutputProperty(name, null);
        }
        catch (XPathException err2) {
            throw new IllegalArgumentException(err2.getMessage());
        }
        String value2 = null;
        if (this.localOutputProperties != null) {
            value2 = this.localOutputProperties.getProperty(name);
        }
        if (value2 == null) {
            value2 = this.getStylesheetOutputProperties().getProperty(name);
        }
        return value2;
    }

    public void setOutputProperty(String name, String value2) throws IllegalArgumentException {
        if (this.localOutputProperties == null) {
            this.makeLocalOutputProperties();
        }
        try {
            value2 = this.getConfiguration().getSerializerFactory().checkOutputProperty(name, value2);
        }
        catch (XPathException err2) {
            throw new IllegalArgumentException(err2.getMessage());
        }
        this.localOutputProperties.setProperty(name, value2);
    }

    public void setParameter(String name, Object value2) {
    }

    public Object getParameter(String name) {
        return null;
    }

    public void clearParameters() {
    }

    public void transform(Source source, Result result2) throws TransformerException {
        try {
            PipelineConfiguration pipe = this.getConfiguration().makePipelineConfiguration();
            SerializerFactory sf = this.getConfiguration().getSerializerFactory();
            SequenceReceiver receiver = sf.getReceiver(result2, pipe, this.getOutputProperties());
            ParseOptions options = pipe.getParseOptions();
            options.setContinueAfterValidationErrors(true);
            Sender.send(source, receiver, options);
        }
        catch (XPathException err2) {
            Throwable cause = err2.getException();
            if (cause != null && cause instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)cause;
                if ((cause = spe.getException()) instanceof RuntimeException) {
                    this.reportFatalError(err2);
                }
            } else {
                this.reportFatalError(err2);
            }
            throw err2;
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    protected void reportFatalError(XPathException err2) {
        try {
            if (this.errorListener != null) {
                this.errorListener.error(err2);
            } else {
                this.getConfiguration().getErrorListener().error(err2);
            }
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }
}

