/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.jaxp;

import java.io.IOException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Version;
import net.sf.saxon.event.ContentHandlerProxy;
import net.sf.saxon.jaxp.AbstractXMLFilter;
import net.sf.saxon.jaxp.TransformerImpl;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FilterImpl
extends AbstractXMLFilter {
    private TransformerImpl transformer;

    FilterImpl(TransformerImpl transformer) {
        this.transformer = transformer;
    }

    public void parse(InputSource input2) throws IOException, SAXException {
        if (this.parser == null) {
            try {
                this.parser = Version.platform.loadParser();
            }
            catch (Exception err2) {
                throw new SAXException(err2);
            }
        }
        SAXSource source = new SAXSource();
        source.setInputSource(input2);
        source.setXMLReader(this.parser);
        ContentHandlerProxy result2 = new ContentHandlerProxy();
        result2.setPipelineConfiguration(this.transformer.getConfiguration().makePipelineConfiguration());
        result2.setUnderlyingContentHandler(this.contentHandler);
        if (this.lexicalHandler != null) {
            result2.setLexicalHandler(this.lexicalHandler);
        }
        try {
            result2.setOutputProperties(this.transformer.getOutputProperties());
            this.transformer.transform(source, result2);
        }
        catch (TransformerException err3) {
            Throwable cause = err3.getException();
            if (cause != null && cause instanceof SAXException) {
                throw (SAXException)cause;
            }
            if (cause != null && cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new SAXException(err3);
        }
    }

    public Transformer getTransformer() {
        return this.transformer;
    }
}

