/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.EncodeForUri;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.regex.LatinString;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.z.IntPredicate;

public abstract class UnparsedTextFunction
extends SystemFunction {
    public int getSpecialProperties(Expression[] arguments) {
        int p = super.getSpecialProperties(arguments);
        if (this.getRetainedStaticContext().getConfiguration().getBooleanProperty("http://saxon.sf.net/feature/stableUnparsedText")) {
            return p;
        }
        return p & 0xFFBFFFFF;
    }

    protected static String getErrorCodePrefix(XPathContext context) {
        return "FOUT";
    }

    public static CharSequence readFile(URI absoluteURI, String encoding, XPathContext context) throws XPathException {
        Reader reader;
        Configuration config = context.getConfiguration();
        IntPredicate checker = config.getValidCharacterChecker();
        try {
            reader = context.getController().getUnparsedTextURIResolver().resolve(absoluteURI, encoding, config);
        }
        catch (XPathException err2) {
            err2.maybeSetErrorCode(UnparsedTextFunction.getErrorCodePrefix(context) + "1170");
            throw err2;
        }
        try {
            return UnparsedTextFunction.readFile(checker, reader, context);
        }
        catch (UnsupportedEncodingException encErr) {
            XPathException e = new XPathException("Unknown encoding " + Err.wrap(encoding), encErr);
            e.setErrorCode(UnparsedTextFunction.getErrorCodePrefix(context) + "1190");
            throw e;
        }
        catch (IOException ioErr) {
            XPathException e = UnparsedTextFunction.handleIOError(absoluteURI, ioErr, context);
            throw e;
        }
    }

    public static URI getAbsoluteURI(String href, String baseURI, XPathContext context) throws XPathException {
        URI absoluteURI;
        try {
            absoluteURI = ResolveURI.makeAbsolute(href, baseURI);
        }
        catch (URISyntaxException err2) {
            XPathException e = new XPathException(err2.getReason() + ": " + err2.getInput(), err2);
            e.setErrorCode(UnparsedTextFunction.getErrorCodePrefix(context) + "1170");
            throw e;
        }
        if (absoluteURI.getFragment() != null) {
            XPathException e = new XPathException("URI for unparsed-text() must not contain a fragment identifier");
            e.setErrorCode(UnparsedTextFunction.getErrorCodePrefix(context) + "1170");
            throw e;
        }
        EncodeForUri.checkPercentEncoding(absoluteURI.toString());
        return absoluteURI;
    }

    public static XPathException handleIOError(URI absoluteURI, IOException ioErr, XPathContext context) {
        String message = "Failed to read input file";
        if (absoluteURI != null && !ioErr.getMessage().equals(absoluteURI.toString())) {
            message = message + ' ' + absoluteURI.toString();
        }
        message = message + " (" + ioErr.getClass().getName() + ')';
        XPathException e = new XPathException(message, ioErr);
        String errorCode = "FOUT1200";
        if (context != null) {
            errorCode = ioErr instanceof MalformedInputException ? UnparsedTextFunction.getErrorCodePrefix(context) + "1200" : (ioErr instanceof CharacterCodingException ? UnparsedTextFunction.getErrorCodePrefix(context) + "1200" : (ioErr instanceof UnmappableCharacterException ? UnparsedTextFunction.getErrorCodePrefix(context) + "1190" : UnparsedTextFunction.getErrorCodePrefix(context) + "1170"));
        }
        e.setErrorCode(errorCode);
        return e;
    }

    public static CharSequence readFile(IntPredicate checker, Reader reader, XPathContext context) throws IOException, XPathException {
        int actual;
        FastStringBuffer sb = new FastStringBuffer(2048);
        char[] buffer = new char[2048];
        boolean first = true;
        int line = 1;
        int column = 1;
        boolean latin = true;
        while ((actual = reader.read(buffer, 0, 2048)) >= 0) {
            int c = 0;
            while (c < actual) {
                int ch32;
                if ((ch32 = buffer[c++]) == 10) {
                    ++line;
                    column = 0;
                }
                ++column;
                if (ch32 > 255) {
                    latin = false;
                    if (UTF16CharacterSet.isHighSurrogate(ch32)) {
                        if (c == actual) {
                            actual = reader.read(buffer, 0, 2048);
                            c = 0;
                        }
                        char low = buffer[c++];
                        ch32 = UTF16CharacterSet.combinePair((char)ch32, low);
                    }
                }
                if (checker.matches(ch32)) continue;
                XPathException err2 = new XPathException("The unparsed-text file contains a character that is illegal in XML (line=" + line + " column=" + column + " value=hex " + Integer.toHexString(ch32) + ')');
                err2.setErrorCode(UnparsedTextFunction.getErrorCodePrefix(context) + "1190");
                throw err2;
            }
            if (first) {
                first = false;
                if (buffer[0] == '\ufeff') {
                    sb.append(buffer, 1, actual - 1);
                    continue;
                }
                sb.append(buffer, 0, actual);
                continue;
            }
            sb.append(buffer, 0, actual);
        }
        reader.close();
        if (latin) {
            return new LatinString(sb);
        }
        return sb.condense();
    }
}

