/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.AllElementsSpaceStrippingRule;
import net.sf.saxon.om.IgnorableSpaceStrippingRule;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.regex.ARegularExpression;
import net.sf.saxon.regex.JavaRegularExpression;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.trans.Instantiator;
import net.sf.saxon.trans.Maker;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIQueryParameters {
    FilenameFilter filter = null;
    Boolean recurse = null;
    Integer validation = null;
    SpaceStrippingRule strippingRule = null;
    Integer onError = null;
    Maker<XMLReader> parserMaker = null;
    Boolean xinclude = null;
    boolean unparsed;
    Boolean stable = null;
    Boolean metadata = null;
    public static final int ON_ERROR_FAIL = 1;
    public static final int ON_ERROR_WARNING = 2;
    public static final int ON_ERROR_IGNORE = 3;

    public URIQueryParameters(String query, Configuration config) throws XPathException {
        if (query != null) {
            StringTokenizer t = new StringTokenizer(query, ";&");
            while (t.hasMoreTokens()) {
                String tok = t.nextToken();
                int eq2 = tok.indexOf(61);
                if (eq2 <= 0 || eq2 >= tok.length() - 1) continue;
                String keyword2 = tok.substring(0, eq2);
                String value2 = tok.substring(eq2 + 1);
                this.processParameter(config, keyword2, value2);
            }
        }
    }

    private void processParameter(Configuration config, String keyword2, String value2) throws XPathException {
        if (keyword2.equals("select")) {
            this.filter = URIQueryParameters.makeGlobFilter(value2);
        } else if (keyword2.equals("match")) {
            ARegularExpression regex = new ARegularExpression(value2, "", "XP", new ArrayList<String>());
            this.filter = new RegexFilter(regex);
        } else if (keyword2.equals("recurse")) {
            this.recurse = "yes".equals(value2);
        } else if (keyword2.equals("validation")) {
            int v = Validation.getCode(value2);
            if (v != -1) {
                this.validation = v;
            }
        } else if (keyword2.equals("strip-space")) {
            if (value2.equals("yes")) {
                this.strippingRule = AllElementsSpaceStrippingRule.getInstance();
            } else if (value2.equals("ignorable")) {
                this.strippingRule = IgnorableSpaceStrippingRule.getInstance();
            } else if (value2.equals("no")) {
                this.strippingRule = NoElementsSpaceStrippingRule.getInstance();
            }
        } else if (keyword2.equals("stable")) {
            if (value2.equals("yes")) {
                this.stable = Boolean.TRUE;
            } else if (value2.equals("no")) {
                this.stable = Boolean.FALSE;
            }
        } else if (keyword2.equals("metadata")) {
            if (value2.equals("yes")) {
                this.metadata = Boolean.TRUE;
            } else if (value2.equals("no")) {
                this.metadata = Boolean.FALSE;
            }
        } else if (keyword2.equals("xinclude")) {
            if (value2.equals("yes")) {
                this.xinclude = Boolean.TRUE;
            } else if (value2.equals("no")) {
                this.xinclude = Boolean.FALSE;
            }
        } else if (keyword2.equals("unparsed")) {
            if (value2.equals("yes")) {
                this.unparsed = true;
            } else if (value2.equals("no")) {
                this.unparsed = false;
            }
        } else if (keyword2.equals("on-error")) {
            if (value2.equals("warning")) {
                this.onError = 2;
            } else if (value2.equals("ignore")) {
                this.onError = 3;
            } else if (value2.equals("fail")) {
                this.onError = 1;
            }
        } else if (keyword2.equals("parser") && config != null) {
            this.parserMaker = new Instantiator<XMLReader>(value2, config);
        }
    }

    public static FilenameFilter makeGlobFilter(String value2) throws XPathException {
        FastStringBuffer sb = new FastStringBuffer(value2.length() + 6);
        sb.append('^');
        for (int i = 0; i < value2.length(); ++i) {
            char c = value2.charAt(i);
            if (c == '.') {
                sb.append("\\.");
                continue;
            }
            if (c == '*') {
                sb.append(".*");
                continue;
            }
            if (c == '?') {
                sb.append(".?");
                continue;
            }
            sb.append(c);
        }
        sb.append('$');
        try {
            return new RegexFilter(new JavaRegularExpression(sb, ""));
        }
        catch (XPathException e) {
            throw new XPathException("Invalid glob " + value2 + " in collection URI", "FODC0004");
        }
    }

    public SpaceStrippingRule getSpaceStrippingRule() {
        return this.strippingRule;
    }

    public Integer getValidationMode() {
        return this.validation;
    }

    public FilenameFilter getFilenameFilter() {
        return this.filter;
    }

    public Boolean getRecurse() {
        return this.recurse;
    }

    public Integer getOnError() {
        return this.onError;
    }

    public Boolean getXInclude() {
        return this.xinclude;
    }

    public Boolean getMetaData() {
        return this.metadata;
    }

    public boolean isUnparsed() {
        return this.unparsed;
    }

    public Boolean getStable() {
        return this.stable;
    }

    public Maker<XMLReader> getXMLReaderMaker() {
        return this.parserMaker;
    }

    public static class RegexFilter
    implements FilenameFilter {
        private RegularExpression pattern;

        public RegexFilter(RegularExpression regex) {
            this.pattern = regex;
        }

        public boolean accept(File dir, String name) {
            return new File(dir, name).isDirectory() || this.pattern.matches(name);
        }

        public boolean matches(String name) {
            return this.pattern.matches(name);
        }
    }
}

