/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.AtomicSortComparer;
import net.sf.saxon.expr.sort.GenericSorter;
import net.sf.saxon.expr.sort.Sortable;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.ma.arrays.ArraySort;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sort_1
extends SystemFunction {
    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        List<ItemToBeSorted> inputList = this.getItemsToBeSorted(arguments[0]);
        StringCollator collation = context.getConfiguration().getCollation(this.getRetainedStaticContext().getDefaultCollationName());
        return this.doSort(inputList, collation, context);
    }

    @NotNull
    protected List<ItemToBeSorted> getItemsToBeSorted(Sequence input2) throws XPathException {
        Item item;
        ArrayList<ItemToBeSorted> inputList = new ArrayList<ItemToBeSorted>();
        int i = 0;
        SequenceIterator iterator2 = input2.iterate();
        while ((item = iterator2.next()) != null) {
            ItemToBeSorted member = new ItemToBeSorted();
            member.value = item;
            member.originalPosition = i++;
            member.sortKey = item.atomize();
            inputList.add(member);
        }
        return inputList;
    }

    protected Sequence doSort(final List<ItemToBeSorted> inputList, StringCollator collation, XPathContext context) throws XPathException {
        final AtomicComparer atomicComparer = AtomicSortComparer.makeSortComparer(collation, 632, context);
        Sortable sortable = new Sortable(){

            public int compare(int a, int b) {
                int result2 = ArraySort.compareSortKeys(((ItemToBeSorted)inputList.get((int)a)).sortKey, ((ItemToBeSorted)inputList.get((int)b)).sortKey, atomicComparer);
                if (result2 == 0) {
                    return ((ItemToBeSorted)inputList.get((int)a)).originalPosition - ((ItemToBeSorted)inputList.get((int)b)).originalPosition;
                }
                return result2;
            }

            public void swap(int a, int b) {
                ItemToBeSorted temp = (ItemToBeSorted)inputList.get(a);
                inputList.set(a, inputList.get(b));
                inputList.set(b, temp);
            }
        };
        try {
            GenericSorter.quickSort(0, inputList.size(), sortable);
        }
        catch (ClassCastException e) {
            XPathException err2 = new XPathException("Non-comparable types found while sorting: " + e.getMessage());
            err2.setErrorCode("XPTY0004");
            throw err2;
        }
        ArrayList<Item> outputList = new ArrayList<Item>(inputList.size());
        for (ItemToBeSorted member : inputList) {
            outputList.add(member.value);
        }
        return new SequenceExtent(outputList);
    }

    public static class ItemToBeSorted {
        public Item value;
        public GroundedValue sortKey;
        public int originalPosition;
    }
}

