/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.GDateValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.TimeValue;
import net.sf.saxon.value.Whitespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseIetfDate
extends SystemFunction
implements Callable {
    private String[] dayNames = new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"};
    private String[] monthNames = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private String[] timezoneNames = new String[]{"UT", "UTC", "GMT", "EST", "EDT", "CST", "CDT", "MST", "MDT", "PST", "PDT"};
    private static final String EOF = "";

    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        StringValue stringValue = (StringValue)arguments[0].head();
        if (stringValue == null) {
            return EmptySequence.getInstance();
        }
        return this.parse(stringValue.getStringValue(), context);
    }

    private boolean isDayName(String string2) {
        for (String s2 : this.dayNames) {
            if (!s2.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    private boolean isMonthName(String string2) {
        for (String s2 : this.monthNames) {
            if (!s2.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    private byte getMonthNumber(String string2) {
        if ("Jan".equalsIgnoreCase(string2)) {
            return 1;
        }
        if ("Feb".equalsIgnoreCase(string2)) {
            return 2;
        }
        if ("Mar".equalsIgnoreCase(string2)) {
            return 3;
        }
        if ("Apr".equalsIgnoreCase(string2)) {
            return 4;
        }
        if ("May".equalsIgnoreCase(string2)) {
            return 5;
        }
        if ("Jun".equalsIgnoreCase(string2)) {
            return 6;
        }
        if ("Jul".equalsIgnoreCase(string2)) {
            return 7;
        }
        if ("Aug".equalsIgnoreCase(string2)) {
            return 8;
        }
        if ("Sep".equalsIgnoreCase(string2)) {
            return 9;
        }
        if ("Oct".equalsIgnoreCase(string2)) {
            return 10;
        }
        if ("Nov".equalsIgnoreCase(string2)) {
            return 11;
        }
        if ("Dec".equalsIgnoreCase(string2)) {
            return 12;
        }
        return 0;
    }

    private int requireDSep(List<String> tokens, int i, String input2) throws XPathException {
        boolean found = false;
        if (" ".equals(tokens.get(i))) {
            ++i;
            found = true;
        }
        if ("-".equals(tokens.get(i))) {
            ++i;
            found = true;
        }
        if (" ".equals(tokens.get(i))) {
            ++i;
            found = true;
        }
        if (!found) {
            ParseIetfDate.badDate("Date separator missing", input2);
        }
        return i;
    }

    private static void badDate(String msg, String value2) throws XPathException {
        XPathException err2 = new XPathException("Invalid IETF date value " + value2 + " (" + msg + ")");
        err2.setErrorCode("FORG0010");
        throw err2;
    }

    private boolean isTimezoneName(String string2) {
        for (String s2 : this.timezoneNames) {
            if (!s2.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    private int getTimezoneOffsetFromName(String string2) {
        if ("UT".equalsIgnoreCase(string2) | "UTC".equalsIgnoreCase(string2) | "GMT".equalsIgnoreCase(string2)) {
            return 0;
        }
        if ("EST".equalsIgnoreCase(string2)) {
            return -300;
        }
        if ("EDT".equalsIgnoreCase(string2)) {
            return -240;
        }
        if ("CST".equalsIgnoreCase(string2)) {
            return -360;
        }
        if ("CDT".equalsIgnoreCase(string2)) {
            return -300;
        }
        if ("MST".equalsIgnoreCase(string2)) {
            return -420;
        }
        if ("MDT".equalsIgnoreCase(string2)) {
            return -360;
        }
        if ("PST".equalsIgnoreCase(string2)) {
            return -480;
        }
        if ("PDT".equalsIgnoreCase(string2)) {
            return -420;
        }
        return 0;
    }

    public DateTimeValue parse(String input2, XPathContext context) throws XPathException {
        List<String> tokens = this.tokenize(input2);
        int year = 0;
        byte month = 0;
        byte day = 0;
        ArrayList<TimeValue> timeValue = new ArrayList<TimeValue>();
        int i = 0;
        String currentToken = tokens.get(i);
        if (currentToken.matches("[A-Za-z]+") && this.isDayName(currentToken)) {
            if (",".equals(currentToken = tokens.get(++i))) {
                currentToken = tokens.get(++i);
            }
            if (!" ".equals(currentToken)) {
                ParseIetfDate.badDate("Space missing after day name", input2);
            }
            currentToken = tokens.get(++i);
        }
        if (this.isMonthName(currentToken)) {
            month = this.getMonthNumber(currentToken);
            currentToken = tokens.get(i = this.requireDSep(tokens, i + 1, input2));
            if (!currentToken.matches("[0-9]+")) {
                ParseIetfDate.badDate("Day number expected after month name", input2);
            }
            if (currentToken.length() > 2) {
                ParseIetfDate.badDate("Day number exceeds two digits", input2);
            }
            day = (byte)Integer.parseInt(currentToken);
            if (!" ".equals(currentToken = tokens.get(++i))) {
                ParseIetfDate.badDate("Space missing after day number", input2);
            }
            ++i;
            i = this.parseTime(tokens, i, timeValue, input2);
            if (!" ".equals(currentToken = tokens.get(++i))) {
                ParseIetfDate.badDate("Space missing after time string", input2);
            }
            if (!(currentToken = tokens.get(++i)).matches("[0-9]+")) {
                ParseIetfDate.badDate("Year number expected after time", input2);
            } else if (currentToken.length() == 4) {
                year = Integer.parseInt(currentToken);
            } else if (currentToken.length() == 2) {
                year = Integer.parseInt(currentToken) + 1900;
            } else if (currentToken.length() != 4 && currentToken.length() != 4) {
                ParseIetfDate.badDate("Year number must be two or four digits", input2);
            }
        } else if (currentToken.matches("[0-9]+")) {
            if (currentToken.length() > 2) {
                ParseIetfDate.badDate("First number in string expected to be day in two digits", input2);
            }
            day = (byte)Integer.parseInt(currentToken);
            ++i;
            currentToken = tokens.get(i = this.requireDSep(tokens, i, input2));
            if (!this.isMonthName(currentToken)) {
                ParseIetfDate.badDate("Abbreviated month name expected after day number", input2);
            }
            month = this.getMonthNumber(currentToken);
            ++i;
            currentToken = tokens.get(i = this.requireDSep(tokens, i, input2));
            if (!currentToken.matches("[0-9]+")) {
                ParseIetfDate.badDate("Year number expected after month name", input2);
            } else if (currentToken.length() == 4) {
                year = Integer.parseInt(currentToken);
            } else if (currentToken.length() == 2) {
                year = Integer.parseInt(currentToken) + 1900;
            } else if (currentToken.length() != 4 && currentToken.length() != 4) {
                ParseIetfDate.badDate("Year number must be two or four digits", input2);
            }
            currentToken = tokens.get(++i);
            if (!" ".equals(currentToken)) {
                ParseIetfDate.badDate("Space missing after year number", input2);
            }
            ++i;
            i = this.parseTime(tokens, i, timeValue, input2);
        } else {
            ParseIetfDate.badDate("String expected to begin with month name or day name (or day number)", input2);
        }
        if (!GDateValue.isValidDate(year, month, day)) {
            ParseIetfDate.badDate("Date is not valid", input2);
        }
        if (!(currentToken = tokens.get(++i)).equals(EOF)) {
            ParseIetfDate.badDate("Extra content found in string after date", input2);
        }
        DateValue date = new DateValue(year, month, day);
        TimeValue time = (TimeValue)timeValue.get(0);
        if (time.getHour() == 24) {
            date = DateValue.tomorrow(date.getYear(), date.getMonth(), date.getDay());
            time = new TimeValue(0, 0, 0, 0, time.getTimezoneInMinutes());
        }
        return DateTimeValue.makeDateTimeValue(date, time);
    }

    public int parseTime(List<String> tokens, int currentPosition, List<TimeValue> result2, String input2) throws XPathException {
        byte second = 0;
        int microsecond = 0;
        int tz = 0;
        int i = currentPosition;
        int n = currentPosition;
        String currentToken = tokens.get(i);
        if (!currentToken.matches("[0-9]+")) {
            ParseIetfDate.badDate("Hour number expected", input2);
        }
        if (currentToken.length() > 2) {
            ParseIetfDate.badDate("Hour number exceeds two digits", input2);
        }
        byte hour = (byte)Integer.parseInt(currentToken);
        if (!":".equals(currentToken = tokens.get(++i))) {
            ParseIetfDate.badDate("Separator ':' missing after hour", input2);
        }
        if (!(currentToken = tokens.get(++i)).matches("[0-9]+")) {
            ParseIetfDate.badDate("Minutes expected after hour", input2);
        }
        if (currentToken.length() != 2) {
            ParseIetfDate.badDate("Minutes must be exactly two digits", input2);
        }
        byte minute = (byte)Integer.parseInt(currentToken);
        currentToken = tokens.get(++i);
        boolean finished = false;
        if (currentToken.equals(EOF)) {
            n = i - 1;
            finished = true;
        } else if (":".equals(currentToken)) {
            if (!(currentToken = tokens.get(++i)).matches("[0-9]+")) {
                ParseIetfDate.badDate("Seconds expected after ':' separator after minutes", input2);
            }
            if (currentToken.length() != 2) {
                ParseIetfDate.badDate("Seconds number must have exactly two digits (before decimal point)", input2);
            }
            second = (byte)Integer.parseInt(currentToken);
            if ((currentToken = tokens.get(++i)).equals(EOF)) {
                n = i - 1;
                finished = true;
            } else if (".".equals(currentToken)) {
                if (!(currentToken = tokens.get(++i)).matches("[0-9]+")) {
                    ParseIetfDate.badDate("Fractional part of seconds expected after decimal point", input2);
                }
                int len = Math.min(6, currentToken.length());
                currentToken = currentToken.substring(0, len);
                while (currentToken.length() < 6) {
                    currentToken = currentToken + "0";
                }
                microsecond = Integer.parseInt(currentToken);
                if (i < tokens.size() - 1) {
                    currentToken = tokens.get(++i);
                }
            }
        }
        if (!finished) {
            if (" ".equals(currentToken) && (currentToken = tokens.get(++i)).matches("[0-9]+")) {
                n = i - 2;
                finished = true;
            }
            if (!finished) {
                if (currentToken.matches("[A-Za-z]+")) {
                    if (!this.isTimezoneName(currentToken)) {
                        ParseIetfDate.badDate("Timezone name not recognised", input2);
                    }
                    tz = this.getTimezoneOffsetFromName(currentToken);
                    n = i;
                    finished = true;
                } else if ("+".equals(currentToken) | "-".equals(currentToken)) {
                    int tLength;
                    String sign2 = currentToken;
                    int tzOffsetHours = 0;
                    int tzOffsetMinutes = 0;
                    if (!(currentToken = tokens.get(++i)).matches("[0-9]+")) {
                        ParseIetfDate.badDate("Parsing timezone offset, number expected after '" + sign2 + "'", input2);
                    }
                    if ((tLength = currentToken.length()) > 4) {
                        ParseIetfDate.badDate("Timezone offset does not have the correct number of digits", input2);
                    } else if (tLength >= 3) {
                        tzOffsetHours = Integer.parseInt(currentToken.substring(0, tLength - 2));
                        tzOffsetMinutes = Integer.parseInt(currentToken.substring(tLength - 2, tLength));
                        currentToken = tokens.get(++i);
                    } else {
                        tzOffsetHours = Integer.parseInt(currentToken);
                        if (":".equals(currentToken = tokens.get(++i)) && (currentToken = tokens.get(++i)).matches("[0-9]+")) {
                            if (currentToken.length() != 2) {
                                ParseIetfDate.badDate("Parsing timezone offset, minutes must be two digits", input2);
                            } else {
                                tzOffsetMinutes = Integer.parseInt(currentToken);
                            }
                            currentToken = tokens.get(++i);
                        }
                    }
                    if (tzOffsetMinutes > 59) {
                        ParseIetfDate.badDate("Timezone offset minutes out of range", input2);
                    }
                    tz = tzOffsetHours * 60 + tzOffsetMinutes;
                    if (sign2.equals("-")) {
                        tz = -tz;
                    }
                    if (currentToken.equals(EOF)) {
                        n = i - 1;
                        finished = true;
                    } else if (" ".equals(currentToken) && (currentToken = tokens.get(++i)).matches("[0-9]+")) {
                        n = i - 2;
                        finished = true;
                    }
                    if (!finished && "(".equals(currentToken)) {
                        if (" ".equals(currentToken = tokens.get(++i))) {
                            currentToken = tokens.get(++i);
                        }
                        if (!currentToken.matches("[A-Za-z]+")) {
                            ParseIetfDate.badDate("Timezone name expected after '('", input2);
                        } else if (currentToken.matches("[A-Za-z]+")) {
                            if (!this.isTimezoneName(currentToken)) {
                                ParseIetfDate.badDate("Timezone name not recognised", input2);
                            }
                            currentToken = tokens.get(++i);
                        }
                        if (" ".equals(currentToken)) {
                            currentToken = tokens.get(++i);
                        }
                        if (!")".equals(currentToken)) {
                            ParseIetfDate.badDate("Expected ')' after timezone name", input2);
                        }
                        n = i;
                        finished = true;
                    } else if (!finished) {
                        ParseIetfDate.badDate("Unexpected content after timezone offset", input2);
                    }
                } else if (!finished) {
                    ParseIetfDate.badDate("Unexpected content in time (after minutes)", input2);
                }
            }
        }
        if (!finished) {
            throw new AssertionError((Object)"Should have finished");
        }
        if (!ParseIetfDate.isValidTime(hour, minute, second, microsecond, tz)) {
            ParseIetfDate.badDate("Time/timezone is not valid", input2);
        }
        TimeValue timeValue = new TimeValue(hour, minute, second, microsecond, tz);
        result2.add(timeValue);
        return n;
    }

    public static boolean isValidTime(int hour, int minute, int second, int microsecond, int tz) {
        return (hour >= 0 && hour <= 23 && minute >= 0 && minute < 60 && second >= 0 && second < 60 && microsecond >= 0 && microsecond < 1000000 || hour == 24 && minute == 0 && second == 0 && microsecond == 0) && tz >= -840 && tz <= 840;
    }

    private List<String> tokenize(String input2) throws XPathException {
        ArrayList<String> tokens = new ArrayList<String>();
        if ((input2 = input2.trim()).isEmpty()) {
            ParseIetfDate.badDate("Input is empty", input2);
            return tokens;
        }
        int i = 0;
        input2 = input2 + '\u0000';
        while (true) {
            int j;
            char c;
            if ((c = input2.charAt(i)) == '\u0000') {
                tokens.add(EOF);
                return tokens;
            }
            if (Whitespace.isWhite(c)) {
                j = i;
                while (Whitespace.isWhite(input2.charAt(j++))) {
                }
                tokens.add(" ");
                i = j - 1;
                continue;
            }
            if (Character.isLetter(c)) {
                j = i;
                while (Character.isLetter(input2.charAt(j++))) {
                }
                tokens.add(input2.substring(i, j - 1));
                i = j - 1;
                continue;
            }
            if (Character.isDigit(c)) {
                j = i;
                while (Character.isDigit(input2.charAt(j++))) {
                }
                tokens.add(input2.substring(i, j - 1));
                i = j - 1;
                continue;
            }
            tokens.add(input2.substring(i, i + 1));
            ++i;
        }
    }
}

