/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.Arrays;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.number.AbstractNumberer;
import net.sf.saxon.expr.number.Alphanumeric;
import net.sf.saxon.expr.number.NamedTimeZone;
import net.sf.saxon.expr.number.Numberer_en;
import net.sf.saxon.expr.number.NumericGroupFormatter;
import net.sf.saxon.functions.AccessorFn;
import net.sf.saxon.functions.FormatInteger;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.Numberer;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.regex.charclass.Categories;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.TimeValue;
import net.sf.saxon.value.Whitespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormatDate
extends SystemFunction
implements Callable {
    static String[] knownCalendars = new String[]{"AD", "AH", "AME", "AM", "AP", "AS", "BE", "CB", "CE", "CL", "CS", "EE", "FE", "ISO", "JE", "KE", "KY", "ME", "MS", "NS", "OS", "RS", "SE", "SH", "SS", "TE", "VE", "VS"};
    private boolean is30 = false;
    private static Pattern componentPattern = Pattern.compile("([YMDdWwFHhmsfZzPCE])\\s*(.*)");
    private static Pattern formatPattern = Pattern.compile("([^,]*)(,.*)?");
    private static Pattern widthPattern = Pattern.compile(",(\\*|[0-9]+)(\\-(\\*|[0-9]+))?");
    private static Pattern alphanumericPattern = Pattern.compile("([A-Za-z0-9]|\\p{L}|\\p{N})*");
    private static Pattern digitsPattern = Pattern.compile("\\p{Nd}+");
    private static Pattern digitsOrOptionalDigitsPattern = Pattern.compile("[#\\p{Nd}]+");
    private static Pattern fractionalDigitsPattern = Pattern.compile("\\p{Nd}+#*");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CharSequence adjustCalendar(StringValue calendarVal, CharSequence result2, XPathContext context) throws XPathException {
        StructuredQName cal;
        try {
            String c = calendarVal.getStringValue();
            cal = c.startsWith("Q{") ? StructuredQName.fromEQName(c) : StructuredQName.fromLexicalQName(c, true, this.is30, this.getRetainedStaticContext());
        }
        catch (XPathException e) {
            XPathException err2 = new XPathException("Invalid calendar name. " + e.getMessage());
            err2.setErrorCode("FOFD1340");
            err2.setXPathContext(context);
            throw err2;
        }
        if (!cal.hasURI("")) return "[Calendar: AD]" + result2.toString();
        String calLocal = cal.getLocalPart();
        if (calLocal.equals("AD")) return result2;
        if (calLocal.equals("ISO")) return result2;
        if (Arrays.binarySearch(knownCalendars, calLocal) >= 0) {
            return "[Calendar: AD]" + result2.toString();
        }
        XPathException err3 = new XPathException("Unknown no-namespace calendar: " + calLocal);
        err3.setErrorCode("FOFD1340");
        err3.setXPathContext(context);
        throw err3;
    }

    private static CharSequence formatDate(CalendarValue value2, String format2, String language2, String country, XPathContext context) throws XPathException {
        boolean languageDefaulted;
        Configuration config = context.getConfiguration();
        boolean bl = languageDefaulted = language2 == null;
        if (language2 == null) {
            language2 = config.getDefaultLanguage();
        }
        if (country == null) {
            country = config.getDefaultCountry();
        }
        Numberer numberer = config.makeNumberer(language2, country);
        FastStringBuffer sb = new FastStringBuffer(64);
        if (numberer.getClass() == Numberer_en.class && !"en".equals(language2) && !languageDefaulted) {
            sb.append("[Language: en]");
        }
        if (numberer.defaultedLocale() != null) {
            sb.append("[Language: " + numberer.defaultedLocale().getLanguage() + "]");
        }
        int i = 0;
        while (true) {
            int close2;
            if (i < format2.length() && format2.charAt(i) != '[') {
                sb.append(format2.charAt(i));
                if (format2.charAt(i) == ']' && (++i == format2.length() || format2.charAt(i) != ']')) {
                    XPathException e = new XPathException("Closing ']' in date picture must be written as ']]'");
                    e.setErrorCode("FOFD1340");
                    e.setXPathContext(context);
                    throw e;
                }
                ++i;
                continue;
            }
            if (i == format2.length()) break;
            if (++i < format2.length() && format2.charAt(i) == '[') {
                sb.append('[');
                ++i;
                continue;
            }
            int n = close2 = i < format2.length() ? format2.indexOf("]", i) : -1;
            if (close2 == -1) {
                XPathException e = new XPathException("Date format contains a '[' with no matching ']'");
                e.setErrorCode("FOFD1340");
                e.setXPathContext(context);
                throw e;
            }
            String componentFormat = format2.substring(i, close2);
            sb.append(FormatDate.formatComponent(value2, Whitespace.removeAllWhitespace(componentFormat), numberer, country, context));
            i = close2 + 1;
        }
        return sb;
    }

    private static CharSequence formatComponent(CalendarValue value2, CharSequence specifier, Numberer numberer, String country, XPathContext context) throws XPathException {
        boolean ignoreDate = value2 instanceof TimeValue;
        boolean ignoreTime = value2 instanceof DateValue;
        DateTimeValue dtvalue = value2.toDateTime();
        Matcher matcher = componentPattern.matcher(specifier);
        if (!matcher.matches()) {
            XPathException error = new XPathException("Unrecognized date/time component [" + specifier + ']');
            error.setErrorCode("FOFD1340");
            error.setXPathContext(context);
            throw error;
        }
        String component = matcher.group(1);
        String format2 = matcher.group(2);
        if (format2 == null) {
            format2 = "";
        }
        boolean defaultFormat = false;
        if ("".equals(format2) || format2.startsWith(",")) {
            defaultFormat = true;
            switch (component.charAt(0)) {
                case 'F': {
                    format2 = "Nn" + format2;
                    break;
                }
                case 'P': {
                    format2 = 'n' + format2;
                    break;
                }
                case 'C': 
                case 'E': {
                    format2 = 'N' + format2;
                    break;
                }
                case 'm': 
                case 's': {
                    format2 = "01" + format2;
                    break;
                }
                case 'Z': 
                case 'z': {
                    break;
                }
                default: {
                    format2 = '1' + format2;
                }
            }
        }
        switch (component.charAt(0)) {
            case 'Y': {
                if (ignoreDate) {
                    XPathException error = new XPathException("In format-time(): an xs:time value does not contain a year component");
                    error.setErrorCode("FOFD1350");
                    error.setXPathContext(context);
                    throw error;
                }
                int year = dtvalue.getYear();
                if (year < 0) {
                    year = 0 - year;
                }
                return FormatDate.formatNumber(component, year, format2, defaultFormat, numberer, context);
            }
            case 'M': {
                if (ignoreDate) {
                    XPathException error = new XPathException("In format-time(): an xs:time value does not contain a month component");
                    error.setErrorCode("FOFD1350");
                    error.setXPathContext(context);
                    throw error;
                }
                byte month = dtvalue.getMonth();
                return FormatDate.formatNumber(component, month, format2, defaultFormat, numberer, context);
            }
            case 'D': {
                if (ignoreDate) {
                    XPathException error = new XPathException("In format-time(): an xs:time value does not contain a day component");
                    error.setErrorCode("FOFD1350");
                    error.setXPathContext(context);
                    throw error;
                }
                byte day = dtvalue.getDay();
                return FormatDate.formatNumber(component, day, format2, defaultFormat, numberer, context);
            }
            case 'd': {
                if (ignoreDate) {
                    XPathException error = new XPathException("In format-time(): an xs:time value does not contain a day component");
                    error.setErrorCode("FOFD1350");
                    error.setXPathContext(context);
                    throw error;
                }
                int day = DateValue.getDayWithinYear(dtvalue.getYear(), dtvalue.getMonth(), dtvalue.getDay());
                return FormatDate.formatNumber(component, day, format2, defaultFormat, numberer, context);
            }
            case 'W': {
                if (ignoreDate) {
                    XPathException error = new XPathException("In format-time(): cannot obtain the week number from an xs:time value");
                    error.setErrorCode("FOFD1350");
                    error.setXPathContext(context);
                    throw error;
                }
                int week = DateValue.getWeekNumber(dtvalue.getYear(), dtvalue.getMonth(), dtvalue.getDay());
                return FormatDate.formatNumber(component, week, format2, defaultFormat, numberer, context);
            }
            case 'w': {
                if (ignoreDate) {
                    XPathException error = new XPathException("In format-time(): cannot obtain the week number from an xs:time value");
                    error.setErrorCode("FOFD1350");
                    error.setXPathContext(context);
                    throw error;
                }
                int week = DateValue.getWeekNumberWithinMonth(dtvalue.getYear(), dtvalue.getMonth(), dtvalue.getDay());
                return FormatDate.formatNumber(component, week, format2, defaultFormat, numberer, context);
            }
            case 'H': {
                if (ignoreTime) {
                    XPathException error = new XPathException("In format-date(): an xs:date value does not contain an hour component");
                    error.setErrorCode("FOFD1350");
                    error.setXPathContext(context);
                    throw error;
                }
                Int64Value hour = (Int64Value)value2.getComponent(AccessorFn.Component.HOURS);
                return FormatDate.formatNumber(component, (int)hour.longValue(), format2, defaultFormat, numberer, context);
            }
            case 'h': {
                if (ignoreTime) {
                    XPathException error = new XPathException("In format-date(): an xs:date value does not contain an hour component");
                    error.setErrorCode("FOFD1350");
                    error.setXPathContext(context);
                    throw error;
                }
                Int64Value hour = (Int64Value)value2.getComponent(AccessorFn.Component.HOURS);
                int hr = (int)hour.longValue();
                if (hr > 12) {
                    hr -= 12;
                }
                if (hr == 0) {
                    hr = 12;
                }
                return FormatDate.formatNumber(component, hr, format2, defaultFormat, numberer, context);
            }
            case 'm': {
                if (ignoreTime) {
                    XPathException error = new XPathException("In format-date(): an xs:date value does not contain a minutes component");
                    error.setErrorCode("FOFD1350");
                    error.setXPathContext(context);
                    throw error;
                }
                Int64Value min2 = (Int64Value)value2.getComponent(AccessorFn.Component.MINUTES);
                return FormatDate.formatNumber(component, (int)min2.longValue(), format2, defaultFormat, numberer, context);
            }
            case 's': {
                if (ignoreTime) {
                    XPathException error = new XPathException("In format-date(): an xs:date value does not contain a seconds component");
                    error.setErrorCode("FOFD1350");
                    error.setXPathContext(context);
                    throw error;
                }
                IntegerValue sec = (IntegerValue)value2.getComponent(AccessorFn.Component.WHOLE_SECONDS);
                return FormatDate.formatNumber(component, (int)sec.longValue(), format2, defaultFormat, numberer, context);
            }
            case 'f': {
                if (ignoreTime) {
                    XPathException error = new XPathException("In format-date(): an xs:date value does not contain a fractional seconds component");
                    error.setErrorCode("FOFD1350");
                    error.setXPathContext(context);
                    throw error;
                }
                int micros = (int)((Int64Value)value2.getComponent(AccessorFn.Component.MICROSECONDS)).longValue();
                return FormatDate.formatNumber(component, micros, format2, defaultFormat, numberer, context);
            }
            case 'Z': 
            case 'z': {
                return FormatDate.formatTimeZone(value2.toDateTime(), component.charAt(0), format2, country);
            }
            case 'F': {
                if (ignoreDate) {
                    XPathException error = new XPathException("In format-time(): an xs:time value does not contain day-of-week component");
                    error.setErrorCode("FOFD1350");
                    error.setXPathContext(context);
                    throw error;
                }
                int day = DateValue.getDayOfWeek(dtvalue.getYear(), dtvalue.getMonth(), dtvalue.getDay());
                return FormatDate.formatNumber(component, day, format2, defaultFormat, numberer, context);
            }
            case 'P': {
                if (ignoreTime) {
                    XPathException error = new XPathException("In format-date(): an xs:date value does not contain an am/pm component");
                    error.setErrorCode("FOFD1350");
                    error.setXPathContext(context);
                    throw error;
                }
                int minuteOfDay = dtvalue.getHour() * 60 + dtvalue.getMinute();
                return FormatDate.formatNumber(component, minuteOfDay, format2, defaultFormat, numberer, context);
            }
            case 'C': {
                return numberer.getCalendarName("AD");
            }
            case 'E': {
                if (ignoreDate) {
                    XPathException error = new XPathException("In format-time(): an xs:time value does not contain an AD/BC component");
                    error.setErrorCode("FOFD1350");
                    error.setXPathContext(context);
                    throw error;
                }
                int year = dtvalue.getYear();
                return numberer.getEraName(year);
            }
        }
        XPathException e = new XPathException("Unknown format-date/time component specifier '" + format2.charAt(0) + '\'');
        e.setErrorCode("FOFD1340");
        e.setXPathContext(context);
        throw e;
    }

    private static CharSequence formatNumber(String component, int value2, String format2, boolean defaultFormat, Numberer numberer, XPathContext context) throws XPathException {
        int len;
        NumericGroupFormatter picGroupFormat;
        int len2;
        int comma = format2.lastIndexOf(44);
        String widths = "";
        if (comma >= 0) {
            widths = format2.substring(comma);
            format2 = format2.substring(0, comma);
        }
        String primary = format2;
        String modifier = null;
        if (primary.endsWith("t")) {
            primary = primary.substring(0, primary.length() - 1);
            modifier = "t";
        } else if (primary.endsWith("o")) {
            primary = primary.substring(0, primary.length() - 1);
            modifier = "o";
        }
        String letterValue = "t".equals(modifier) ? "traditional" : null;
        String ordinal = "o".equals(modifier) ? numberer.getOrdinalSuffixForDateTime(component) : null;
        int min2 = 1;
        int max2 = Integer.MAX_VALUE;
        if (digitsPattern.matcher(primary).matches() && (len2 = StringValue.getStringLength(primary)) > 1) {
            min2 = len2;
            max2 = len2;
        }
        if ("Y".equals(component)) {
            max2 = 0;
            min2 = 0;
            if (!widths.isEmpty()) {
                max2 = FormatDate.getWidths(widths)[1];
            } else if (digitsPattern.matcher(primary).find()) {
                UnicodeString uPrimary = UnicodeString.makeUnicodeString(primary);
                for (int i = 0; i < uPrimary.uLength(); ++i) {
                    int c = uPrimary.uCharAt(i);
                    if (c == 35) {
                        ++max2;
                        continue;
                    }
                    if ((c < 48 || c > 57) && !Categories.ESCAPE_d.matches(c)) continue;
                    ++min2;
                    ++max2;
                }
            }
            if (max2 <= 1) {
                max2 = Integer.MAX_VALUE;
            }
            if (max2 < 4 || max2 < Integer.MAX_VALUE && value2 > 9999) {
                value2 %= (int)Math.pow(10.0, max2);
            }
        }
        if (primary.equals("I") || primary.equals("i")) {
            int[] range2 = FormatDate.getWidths(widths);
            min2 = range2[0];
            String s2 = numberer.format(value2, UnicodeString.makeUnicodeString(primary), null, letterValue, ordinal);
            for (int len3 = StringValue.getStringLength(s2); len3 < min2; ++len3) {
                s2 = s2 + ' ';
            }
            return s2;
        }
        if (!widths.isEmpty()) {
            int[] range3 = FormatDate.getWidths(widths);
            min2 = Math.max(min2, range3[0]);
            max2 = max2 == Integer.MAX_VALUE ? range3[1] : Math.max(max2, range3[1]);
            if (defaultFormat && primary.endsWith("1") && min2 != primary.length()) {
                FastStringBuffer sb = new FastStringBuffer(min2 + 1);
                for (int i = 1; i < min2; ++i) {
                    sb.append('0');
                }
                sb.append('1');
                primary = sb.toString();
            }
        }
        if ("P".equals(component)) {
            if (!("N".equals(primary) || "n".equals(primary) || "Nn".equals(primary))) {
                primary = "n";
            }
            if (max2 == Integer.MAX_VALUE) {
                max2 = 4;
            }
        } else if ("Y".equals(component)) {
            if (max2 < Integer.MAX_VALUE) {
                value2 %= (int)Math.pow(10.0, max2);
            }
        } else if ("f".equals(component)) {
            String s3;
            UnicodeString uFormat = UnicodeString.makeUnicodeString(format2);
            if (!digitsPattern.matcher(primary).find()) {
                return FormatDate.formatNumber(component, value2, "1", defaultFormat, numberer, context);
            }
            if (!digitsOrOptionalDigitsPattern.matcher(primary).matches()) {
                UnicodeString reverseFormat = FormatDate.reverse(uFormat);
                UnicodeString reverseValue = FormatDate.reverse(UnicodeString.makeUnicodeString("" + value2));
                CharSequence reverseResult = FormatDate.formatNumber("s", Integer.parseInt(reverseValue.toString()), reverseFormat.toString(), false, numberer, context);
                UnicodeString correctedResult = FormatDate.reverse(UnicodeString.makeUnicodeString(reverseResult));
                if (correctedResult.uLength() > max2) {
                    correctedResult = correctedResult.uSubstring(0, max2);
                }
                return correctedResult.toString();
            }
            if (!fractionalDigitsPattern.matcher(primary).matches()) {
                throw new XPathException("Invalid picture for fractional seconds: " + primary, "FOFD1340");
            }
            if (value2 == 0) {
                s3 = "0";
            } else {
                s3 = (1000000 + value2 + "").substring(1);
                if (s3.length() > max2) {
                    s3 = s3.substring(0, max2);
                }
            }
            while (s3.length() < min2) {
                s3 = s3 + '0';
            }
            while (s3.length() > min2 && s3.charAt(s3.length() - 1) == '0') {
                s3 = s3.substring(0, s3.length() - 1);
            }
            int zeroDigit = Alphanumeric.getDigitFamily(uFormat.uCharAt(0));
            if (zeroDigit >= 0 && zeroDigit != 48) {
                int[] digits = new int[10];
                for (int z = 0; z <= 9; ++z) {
                    digits[z] = zeroDigit + z;
                }
                long n = Long.parseLong(s3);
                int requiredLength = s3.length();
                s3 = AbstractNumberer.convertDigitSystem(n, digits, requiredLength).toString();
            }
            return s3;
        }
        if ("N".equals(primary) || "n".equals(primary) || "Nn".equals(primary)) {
            String s4 = "";
            if ("M".equals(component)) {
                s4 = numberer.monthName(value2, min2, max2);
            } else if ("F".equals(component)) {
                s4 = numberer.dayName(value2, min2, max2);
            } else if ("P".equals(component)) {
                s4 = numberer.halfDayName(value2, min2, max2);
            } else {
                primary = "1";
            }
            if ("N".equals(primary)) {
                return s4.toUpperCase();
            }
            if ("n".equals(primary)) {
                return s4.toLowerCase();
            }
            return s4;
        }
        try {
            picGroupFormat = FormatInteger.getPicSeparators(primary);
        }
        catch (XPathException e) {
            if ("FODF1310".equals(e.getErrorCodeLocalPart())) {
                e.setErrorCode("FOFD1340");
            }
            throw e;
        }
        UnicodeString adjustedPicture = picGroupFormat.getAdjustedPicture();
        String s5 = numberer.format(value2, adjustedPicture, picGroupFormat, letterValue, ordinal);
        if (len < min2) {
            int zeroDigit = Alphanumeric.getDigitFamily(adjustedPicture.uCharAt(0));
            FastStringBuffer fsb = new FastStringBuffer(s5);
            for (len = StringValue.getStringLength(s5); len < min2; ++len) {
                fsb.prependWideChar(zeroDigit);
            }
            s5 = fsb.toString();
        }
        return s5;
    }

    private static UnicodeString reverse(UnicodeString in) {
        int[] out = new int[in.uLength()];
        int i = in.uLength() - 1;
        int j = 0;
        while (i >= 0) {
            out[j] = in.uCharAt(i);
            --i;
            ++j;
        }
        return UnicodeString.makeUnicodeString(out);
    }

    private static int[] getWidths(String widths) throws XPathException {
        try {
            int min2 = -1;
            int max2 = -1;
            if (!"".equals(widths)) {
                Matcher widthMatcher = widthPattern.matcher(widths);
                if (widthMatcher.matches()) {
                    String smin = widthMatcher.group(1);
                    min2 = smin == null || "".equals(smin) || "*".equals(smin) ? 1 : Integer.parseInt(smin);
                    String smax = widthMatcher.group(3);
                    max2 = smax == null || "".equals(smax) || "*".equals(smax) ? Integer.MAX_VALUE : Integer.parseInt(smax);
                    if (min2 < 1) {
                        throw new XPathException("Invalid min value in format picture " + Err.wrap(widths, 4), "FOFD1340");
                    }
                    if (max2 < 1 || max2 < min2) {
                        throw new XPathException("Invalid max value in format picture " + Err.wrap(widths, 4), "FOFD1340");
                    }
                } else {
                    throw new XPathException("Unrecognized width specifier in format picture " + Err.wrap(widths, 4), "FOFD1340");
                }
            }
            if (min2 > max2 && max2 != -1) {
                XPathException e = new XPathException("Minimum width in date/time picture exceeds maximum width");
                e.setErrorCode("FOFD1340");
                throw e;
            }
            int[] result2 = new int[]{min2, max2};
            return result2;
        }
        catch (NumberFormatException err2) {
            XPathException e = new XPathException("Invalid integer used as width in date/time picture");
            e.setErrorCode("FOFD1340");
            throw e;
        }
    }

    private static String formatTimeZone(DateTimeValue value2, char component, String format2, String country) throws XPathException {
        int[] expandedFormat;
        int comma = format2.lastIndexOf(44);
        String widthModifier = "";
        if (comma >= 0) {
            widthModifier = format2.substring(comma);
            format2 = format2.substring(0, comma);
        }
        if (!value2.hasTimezone()) {
            if (format2.equals("Z")) {
                return "J";
            }
            return "";
        }
        if (format2.isEmpty() && widthModifier.length() > 0) {
            int[] widths = FormatDate.getWidths(widthModifier);
            int min2 = widths[0];
            int max2 = widths[1];
            format2 = min2 <= 1 ? (max2 >= 4 ? "0:00" : "0") : (min2 <= 4 ? (max2 >= 5 ? "00:00" : "00") : "00:00");
        }
        if (format2.isEmpty()) {
            format2 = "00:00";
        }
        int tz = value2.getTimezoneInMinutes();
        boolean useZforZero = format2.endsWith("t");
        if (useZforZero && tz == 0) {
            return "Z";
        }
        if (useZforZero) {
            format2 = format2.substring(0, format2.length() - 1);
        }
        int digits = 0;
        int separators = 0;
        int separatorChar = 58;
        int zeroDigit = -1;
        for (int ch : expandedFormat = StringValue.expand(format2)) {
            if (Character.isDigit(ch)) {
                ++digits;
                if (zeroDigit >= 0) continue;
                zeroDigit = Alphanumeric.getDigitFamily(ch);
                continue;
            }
            ++separators;
            separatorChar = ch;
        }
        int[] buffer = new int[10];
        int used = 0;
        if (digits > 0) {
            int hourDigits;
            if (component == 'z') {
                buffer[0] = 71;
                buffer[1] = 77;
                buffer[2] = 84;
                used = 3;
            }
            boolean negative = tz < 0;
            tz = Math.abs(tz);
            buffer[used++] = negative ? 45 : 43;
            int hour = tz / 60;
            int minute = tz % 60;
            boolean includeMinutes = minute != 0 || digits >= 3 || separators > 0;
            boolean includeSep = minute != 0 && digits <= 2 || separators > 0 && (minute != 0 || digits >= 3);
            int n = hourDigits = digits <= 2 ? digits : digits - 2;
            if (hour > 9 || hourDigits >= 2) {
                buffer[used++] = zeroDigit + hour / 10;
            }
            buffer[used++] = hour % 10 + zeroDigit;
            if (includeSep) {
                buffer[used++] = separatorChar;
            }
            if (includeMinutes) {
                buffer[used++] = minute / 10 + zeroDigit;
                buffer[used++] = minute % 10 + zeroDigit;
            }
            return StringValue.contract(buffer, used).toString();
        }
        if (format2.equals("Z")) {
            int hour = tz / 60;
            int minute = tz % 60;
            if (hour < -12 || hour > 12 || minute != 0) {
                return FormatDate.formatTimeZone(value2, 'Z', "00:00", country);
            }
            return Character.toString("YXWVUTSRQPONZABCDEFGHIKLM".charAt(hour + 12));
        }
        if (format2.charAt(0) == 'N' || format2.charAt(0) == 'n') {
            return FormatDate.getNamedTimeZone(value2, country, format2);
        }
        return FormatDate.formatTimeZone(value2, 'Z', "00:00", country);
    }

    private static String getNamedTimeZone(DateTimeValue value2, String country, String format2) throws XPathException {
        int min2 = 1;
        int comma = format2.indexOf(44);
        if (comma > 0) {
            String widths = format2.substring(comma);
            int[] range2 = FormatDate.getWidths(widths);
            min2 = range2[0];
        }
        if (format2.charAt(0) == 'N' || format2.charAt(0) == 'n') {
            if (min2 <= 5) {
                String tzname = NamedTimeZone.getTimeZoneNameForDate(value2, country);
                if (format2.charAt(0) == 'n') {
                    tzname = tzname.toLowerCase();
                }
                return tzname;
            }
            return NamedTimeZone.getOlsenTimeZoneName(value2, country);
        }
        FastStringBuffer sbz = new FastStringBuffer(8);
        value2.appendTimezone(sbz);
        return sbz.toString();
    }

    @Override
    public ZeroOrOne<StringValue> call(XPathContext context, Sequence[] arguments) throws XPathException {
        TimeZone zone;
        String place;
        CalendarValue value2 = (CalendarValue)arguments[0].head();
        if (value2 == null) {
            return ZeroOrOne.empty();
        }
        String format2 = arguments[1].head().getStringValue();
        StringValue calendarVal = null;
        AtomicValue countryVal = null;
        AtomicValue languageVal = null;
        if (this.getArity() > 2) {
            languageVal = (StringValue)arguments[2].head();
            calendarVal = (StringValue)arguments[3].head();
            countryVal = (StringValue)arguments[4].head();
        }
        String language2 = languageVal == null ? null : languageVal.getStringValue();
        String string2 = place = countryVal == null ? null : countryVal.getStringValue();
        if (place != null && place.contains("/") && value2.hasTimezone() && !(value2 instanceof TimeValue) && (zone = NamedTimeZone.getNamedTimeZone(place)) != null) {
            int offset = zone.getOffset(value2.toDateTime().getCalendar().getTimeInMillis());
            value2 = value2.adjustTimezone(offset / 60000);
        }
        CharSequence result2 = FormatDate.formatDate(value2, format2, language2, place, context);
        if (calendarVal != null) {
            result2 = this.adjustCalendar(calendarVal, result2, context);
        }
        return new ZeroOrOne<StringValue>(new StringValue(result2));
    }
}

