/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.GroupIterator;
import net.sf.saxon.expr.sort.MergeInstr;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;

public class CurrentMergeKey
extends SystemFunction
implements Callable {
    private MergeInstr controllingInstruction = null;

    public void setControllingInstruction(MergeInstr instruction) throws XPathException {
        this.controllingInstruction = instruction;
    }

    public MergeInstr getControllingInstruction() {
        return this.controllingInstruction;
    }

    public Expression makeFunctionCall(Expression ... arguments) {
        return new SystemFunctionCall(this, arguments){

            public Expression getScopingExpression() {
                return CurrentMergeKey.this.getControllingInstruction();
            }
        };
    }

    public SequenceIterator iterate(XPathContext c) throws XPathException {
        GroupIterator gi = c.getCurrentMergeGroupIterator();
        if (gi == null) {
            XPathException err2 = new XPathException("There is no current merge key", "XTDE3510");
            throw err2;
        }
        return gi.getCurrentGroupingKey().iterate();
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        return SequenceTool.toLazySequence(this.iterate(context));
    }
}

