/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;

public class Count
extends SystemFunction {
    public IntegerValue[] getIntegerBounds() {
        return new IntegerValue[]{Int64Value.ZERO, Expression.MAX_SEQUENCE_LENGTH};
    }

    public static int count(SequenceIterator iter2) throws XPathException {
        if ((iter2.getProperties() & 2) != 0) {
            return ((LastPositionFinder)((Object)iter2)).getLength();
        }
        int n = 0;
        while (iter2.next() != null) {
            ++n;
        }
        return n;
    }

    public static int steppingCount(SequenceIterator iter2) throws XPathException {
        int n = 0;
        while (iter2.next() != null) {
            ++n;
        }
        return n;
    }

    public IntegerValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        Sequence arg = arguments[0];
        int size2 = arg instanceof GroundedValue ? ((GroundedValue)arg).getLength() : Count.count(arg.iterate());
        return Int64Value.makeIntegerValue(size2);
    }

    public String getCompilerName() {
        return "CountCompiler";
    }

    public String getStreamerName() {
        return "Count";
    }
}

