/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.functions.CollatingFunctionFixed;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compare
extends CollatingFunctionFixed {
    private static Int64Value compare(StringValue s1, StringValue s2, AtomicComparer comparer) throws XPathException {
        if (s1 == null || s2 == null) {
            return null;
        }
        int result2 = comparer.compareAtomicValues(s1, s2);
        if (result2 < 0) {
            return Int64Value.MINUS_ONE;
        }
        if (result2 > 0) {
            return Int64Value.PLUS_ONE;
        }
        return Int64Value.ZERO;
    }

    @Override
    public ZeroOrOne<Int64Value> call(XPathContext context, Sequence[] arguments) throws XPathException {
        GenericAtomicComparer comparer;
        StringValue arg1;
        StringValue arg0 = (StringValue)arguments[0].head();
        Int64Value result2 = Compare.compare(arg0, arg1 = (StringValue)arguments[1].head(), comparer = new GenericAtomicComparer(this.getStringCollator(), context));
        if (result2 == null) {
            return ZeroOrOne.empty();
        }
        return new ZeroOrOne<Int64Value>(result2);
    }
}

