/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.ArithmeticExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Fold;
import net.sf.saxon.functions.FoldingFunction;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.YearMonthDurationValue;

public class Average
extends FoldingFunction {
    public int getCardinality(Expression[] arguments) {
        if (!Cardinality.allowsZero(arguments[0].getCardinality())) {
            return 16384;
        }
        return super.getCardinality(arguments);
    }

    public Fold getFold(XPathContext context, Sequence ... additionalArguments) throws XPathException {
        return new AverageFold(context);
    }

    private class AverageFold
    implements Fold {
        private XPathContext context;
        private AtomicValue data;
        private boolean atStart = true;
        private ConversionRules rules;
        private StringConverter toDouble;
        private int count = 0;

        public AverageFold(XPathContext context) {
            this.context = context;
            this.rules = context.getConfiguration().getConversionRules();
            this.toDouble = BuiltInAtomicType.DOUBLE.getStringConverter(this.rules);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void processItem(Item item) throws XPathException {
            AtomicValue next2 = (AtomicValue)item;
            if (next2 instanceof UntypedAtomicValue) {
                next2 = this.toDouble.convert(next2).asAtomic();
            }
            ++this.count;
            if (this.atStart) {
                if (!(next2 instanceof NumericValue) && !(next2 instanceof DayTimeDurationValue) && !(next2 instanceof YearMonthDurationValue)) throw new XPathException("Input to avg() contains a value that is neither numeric, nor a duration", "FORG0006");
                this.data = next2;
                this.atStart = false;
                return;
            }
            if (this.data instanceof NumericValue) {
                if (!(next2 instanceof NumericValue)) {
                    throw new XPathException("Input to avg() contains a mix of numeric and non-numeric values", "FORG0006");
                }
                this.data = ArithmeticExpression.compute(this.data, 0, next2, this.context);
                return;
            }
            if (!(this.data instanceof DurationValue)) throw new XPathException("Input to avg() contains a value that is neither numeric, nor a duration", "FORG0006");
            if (!(next2 instanceof DurationValue)) {
                throw new XPathException("Input to avg() contains a mix of duration and non-duration values", "FORG0006");
            }
            try {
                this.data = ((DurationValue)this.data).add((DurationValue)next2);
                return;
            }
            catch (XPathException e) {
                if (!"XPTY0004".equals(e.getErrorCodeLocalPart())) throw e;
                e.setErrorCode("FORG0006");
                throw e;
            }
        }

        public boolean isFinished() {
            return this.data instanceof DoubleValue && this.data.isNaN();
        }

        public Sequence result() throws XPathException {
            if (this.atStart) {
                return EmptySequence.getInstance();
            }
            if (this.data instanceof NumericValue) {
                return ArithmeticExpression.compute(this.data, 3, new Int64Value(this.count), this.context);
            }
            return ((DurationValue)this.data).multiply(1.0 / (double)this.count);
        }
    }
}

