/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import net.sf.saxon.expr.ErrorIterator;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.GenericSorter;
import net.sf.saxon.expr.sort.ItemToBeSorted;
import net.sf.saxon.expr.sort.ObjectToBeSorted;
import net.sf.saxon.expr.sort.SortKeyEvaluator;
import net.sf.saxon.expr.sort.Sortable;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.LookaheadIterator;

public class SortedIterator
implements SequenceIterator,
LastPositionFinder,
LookaheadIterator,
Sortable {
    protected SequenceIterator base;
    protected SortKeyEvaluator sortKeyEvaluator;
    protected AtomicComparer[] comparators;
    protected ObjectToBeSorted[] values;
    protected int count = -1;
    protected int position = 0;
    protected XPathContext context;
    private int hostLanguage;

    protected SortedIterator() {
    }

    public SortedIterator(XPathContext context, SequenceIterator base, SortKeyEvaluator sortKeyEvaluator, AtomicComparer[] comparators, boolean createNewContext) {
        if (createNewContext) {
            this.context = context.newMinorContext();
            this.base = new FocusTrackingIterator(base);
            this.context.setCurrentIterator((FocusTrackingIterator)this.base);
            this.context.setTemporaryOutputState(195);
        } else {
            this.base = base;
            this.context = context;
        }
        this.sortKeyEvaluator = sortKeyEvaluator;
        this.comparators = new AtomicComparer[comparators.length];
        for (int n = 0; n < comparators.length; ++n) {
            this.comparators[n] = comparators[n].provideContext(context);
        }
    }

    public void setHostLanguage(int language2) {
        this.hostLanguage = language2;
    }

    public boolean hasNext() {
        if (this.position < 0) {
            return false;
        }
        if (this.count < 0) {
            if (this.base instanceof LookaheadIterator) {
                return ((LookaheadIterator)this.base).hasNext();
            }
            try {
                this.doSort();
                return this.count > 0;
            }
            catch (XPathException err2) {
                this.count = -1;
                this.base = new FocusTrackingIterator(new ErrorIterator(err2));
                return true;
            }
        }
        return this.position < this.count;
    }

    public Item next() throws XPathException {
        if (this.position < 0) {
            return null;
        }
        if (this.count < 0) {
            this.doSort();
        }
        if (this.position < this.count) {
            return (Item)this.values[this.position++].value;
        }
        this.position = -1;
        return null;
    }

    public int getLength() throws XPathException {
        if (this.count < 0) {
            this.doSort();
        }
        return this.count;
    }

    public void close() {
    }

    public int getProperties() {
        return 2;
    }

    protected void buildArray() throws XPathException {
        ObjectToBeSorted[] nk2;
        Item item;
        int allocated = (this.base.getProperties() & 2) != 0 ? ((LastPositionFinder)((Object)this.base)).getLength() : 100;
        this.values = new ItemToBeSorted[allocated];
        this.count = 0;
        while ((item = this.base.next()) != null) {
            if (this.count == allocated) {
                nk2 = new ObjectToBeSorted[allocated *= 2];
                System.arraycopy(this.values, 0, nk2, 0, this.count);
                this.values = nk2;
            }
            ItemToBeSorted itbs = new ItemToBeSorted(this.comparators.length);
            this.values[this.count] = itbs;
            itbs.value = item;
            for (int n = 0; n < this.comparators.length; ++n) {
                itbs.sortKeyValues[n] = this.sortKeyEvaluator.evaluateSortKey(n, this.context);
            }
            ++this.count;
            itbs.originalPosition = itbs.originalPosition;
        }
        if (allocated * 2 < this.count || allocated - this.count > 2000) {
            nk2 = new ObjectToBeSorted[this.count];
            System.arraycopy(this.values, 0, nk2, 0, this.count);
            this.values = nk2;
        }
    }

    private void doSort() throws XPathException {
        this.buildArray();
        if (this.count < 2) {
            return;
        }
        try {
            GenericSorter.quickSort(0, this.count, this);
        }
        catch (ClassCastException e) {
            XPathException err2 = new XPathException("Non-comparable types found while sorting: " + e.getMessage());
            if (this.hostLanguage == 50) {
                err2.setErrorCode("XTDE1030");
            } else {
                err2.setErrorCode("XPTY0004");
            }
            throw err2;
        }
    }

    public int compare(int a, int b) {
        try {
            for (int i = 0; i < this.comparators.length; ++i) {
                int comp = this.comparators[i].compareAtomicValues(this.values[a].sortKeyValues[i], this.values[b].sortKeyValues[i]);
                if (comp == 0) continue;
                return comp;
            }
        }
        catch (NoDynamicContextException e) {
            throw new AssertionError((Object)("Sorting without dynamic context: " + e.getMessage()));
        }
        return this.values[a].originalPosition - this.values[b].originalPosition;
    }

    public void swap(int a, int b) {
        ObjectToBeSorted temp = this.values[a];
        this.values[a] = this.values[b];
        this.values[b] = temp;
    }
}

