/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.parser;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ArithmeticExpression;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.GeneralComparison20;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UntypedSequenceConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.JavaExternalObjectType;
import net.sf.saxon.type.NumericType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;

public class TypeChecker {
    public Expression staticTypeCheck(Expression supplied, SequenceType req, RoleDiagnostic role, ExpressionVisitor visitor) throws XPathException {
        String msg;
        Expression cexp;
        int relation;
        boolean cardOK;
        if (supplied.implementsStaticTypeCheck()) {
            return supplied.staticTypeCheck(req, false, role, visitor);
        }
        Expression exp = supplied;
        StaticContext env = visitor.getStaticContext();
        Configuration config = env.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        ContextItemStaticInfo defaultContextInfo = config.getDefaultContextItemStaticInfo();
        ItemType reqItemType = req.getPrimaryType();
        int reqCard = req.getCardinality();
        boolean allowsMany = Cardinality.allowsMany(reqCard);
        ItemType suppliedItemType = null;
        int suppliedCard = -1;
        boolean bl = cardOK = reqCard == 57344;
        if (!cardOK) {
            suppliedCard = exp.getCardinality();
            cardOK = Cardinality.subsumes(reqCard, suppliedCard);
        }
        boolean itemTypeOK = reqItemType instanceof AnyItemType;
        if (reqCard == 8192) {
            itemTypeOK = true;
        }
        if (!itemTypeOK) {
            suppliedItemType = exp.getItemType();
            if (reqItemType == null || suppliedItemType == null) {
                throw new NullPointerException();
            }
            relation = th.relationship(reqItemType, suppliedItemType);
            boolean bl2 = itemTypeOK = relation == 0 || relation == 1;
        }
        if (!itemTypeOK) {
            if (reqItemType.isPlainType()) {
                if (!suppliedItemType.isPlainType() && suppliedCard != 8192) {
                    if (!suppliedItemType.isAtomizable()) {
                        XPathException err2 = new XPathException("An atomic value is required for the " + role.getMessage() + ", but the supplied value cannot be atomized", "FOTY0013", supplied.getLocation());
                        err2.setIsTypeError(true);
                        throw err2;
                    }
                    if (exp instanceof ContextItemExpression && exp.getRetainedStaticContext() == null) {
                        exp.setRetainedStaticContextLocally(env.makeRetainedStaticContext());
                    }
                    Expression cexp2 = Atomizer.makeAtomizer(exp);
                    ExpressionTool.copyLocationInfo(exp, cexp2);
                    exp = cexp2;
                    cexp2 = exp.simplify();
                    ExpressionTool.copyLocationInfo(exp, cexp2);
                    exp = cexp2;
                    suppliedItemType = exp.getItemType();
                    suppliedCard = exp.getCardinality();
                    cardOK = Cardinality.subsumes(reqCard, suppliedCard);
                }
                if (suppliedItemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC) && !reqItemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC) && !reqItemType.equals(BuiltInAtomicType.ANY_ATOMIC)) {
                    if (((SimpleType)((Object)reqItemType)).isNamespaceSensitive()) {
                        XPathException err3 = new XPathException("An untyped atomic value cannot be converted to a QName or NOTATION as required for the " + role.getMessage(), "XPTY0117", supplied.getLocation());
                        err3.setIsTypeError(true);
                        throw err3;
                    }
                    UntypedSequenceConverter cexp3 = UntypedSequenceConverter.makeUntypedSequenceConverter(config, exp, (PlainType)reqItemType);
                    ExpressionTool.copyLocationInfo(exp, cexp3);
                    try {
                        if (exp instanceof Literal) {
                            exp = Literal.makeLiteral(SequenceExtent.makeSequenceExtent(((Expression)cexp3).iterate(visitor.makeDynamicContext())));
                            ExpressionTool.copyLocationInfo(cexp3, exp);
                        } else {
                            exp = cexp3;
                        }
                    }
                    catch (XPathException err4) {
                        err4.maybeSetLocation(exp.getLocation());
                        err4.setErrorCode(role.getErrorCode());
                        err4.setIsStaticError(true);
                        throw err4;
                    }
                    itemTypeOK = true;
                    suppliedItemType = reqItemType;
                }
                if (suppliedItemType.equals(BuiltInAtomicType.ANY_ATOMIC) && !reqItemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC) && !reqItemType.equals(BuiltInAtomicType.ANY_ATOMIC) && (exp.getSpecialProperties() & 0x2000000) == 0) {
                    UntypedSequenceConverter conversion = ((SimpleType)((Object)reqItemType)).isNamespaceSensitive() ? UntypedSequenceConverter.makeUntypedSequenceRejector(config, exp, (PlainType)reqItemType) : UntypedSequenceConverter.makeUntypedSequenceConverter(config, exp, (PlainType)reqItemType);
                    ExpressionTool.copyLocationInfo(exp, conversion);
                    try {
                        if (exp instanceof Literal) {
                            exp = Literal.makeLiteral(SequenceExtent.makeSequenceExtent(((Expression)conversion).iterate(visitor.makeDynamicContext())));
                            ExpressionTool.copyLocationInfo(supplied, exp);
                        } else {
                            exp = conversion;
                        }
                        suppliedItemType = exp.getItemType();
                    }
                    catch (XPathException err5) {
                        err5.maybeSetLocation(exp.getLocation());
                        err5.setIsStaticError(true);
                        throw err5;
                    }
                }
                if (reqItemType instanceof AtomicType) {
                    int rt = ((AtomicType)reqItemType).getFingerprint();
                    if (rt == 517 && th.relationship(suppliedItemType, NumericType.getInstance()) != 4) {
                        cexp = TypeChecker.makePromoterToDouble(exp);
                        ExpressionTool.copyLocationInfo(exp, cexp);
                        exp = cexp;
                        try {
                            exp = exp.simplify().typeCheck(visitor, defaultContextInfo);
                        }
                        catch (XPathException err6) {
                            err6.maybeSetLocation(exp.getLocation());
                            err6.setIsStaticError(true);
                            throw err6;
                        }
                        suppliedItemType = BuiltInAtomicType.DOUBLE;
                        suppliedCard = -1;
                    } else if (rt == 516 && th.relationship(suppliedItemType, NumericType.getInstance()) != 4 && !th.isSubType(suppliedItemType, BuiltInAtomicType.DOUBLE)) {
                        cexp = TypeChecker.makePromoterToFloat(exp);
                        ExpressionTool.copyLocationInfo(exp, cexp);
                        exp = cexp;
                        try {
                            exp = exp.simplify().typeCheck(visitor, defaultContextInfo);
                        }
                        catch (XPathException err7) {
                            err7.maybeSetLocation(exp.getLocation());
                            err7.setIsStaticError(true);
                            throw err7;
                        }
                        suppliedItemType = BuiltInAtomicType.FLOAT;
                        suppliedCard = -1;
                    }
                    if (rt == 513 && th.isSubType(suppliedItemType, BuiltInAtomicType.ANY_URI)) {
                        suppliedItemType = BuiltInAtomicType.STRING;
                        itemTypeOK = true;
                    }
                }
            } else if (reqItemType instanceof FunctionItemType && !((FunctionItemType)reqItemType).isMapType() && !((FunctionItemType)reqItemType).isArrayType()) {
                if (!(suppliedItemType instanceof FunctionItemType)) {
                    exp = new ItemChecker(exp, th.getGenericFunctionItemType(), role);
                    suppliedItemType = th.getGenericFunctionItemType();
                }
                exp = TypeChecker.makeFunctionSequenceCoercer(exp, (FunctionItemType)reqItemType, visitor, role);
                itemTypeOK = true;
            } else if (reqItemType instanceof JavaExternalObjectType && reqCard == 16384) {
                if (Sequence.class.isAssignableFrom(((JavaExternalObjectType)reqItemType).getJavaClass())) {
                    itemTypeOK = true;
                } else if (supplied instanceof FunctionCall && ((FunctionCall)supplied).adjustRequiredType((JavaExternalObjectType)reqItemType)) {
                    itemTypeOK = true;
                    cardOK = true;
                }
            }
        }
        if (itemTypeOK && cardOK) {
            return exp;
        }
        if (suppliedCard == -1) {
            suppliedCard = exp.getCardinality();
            if (!cardOK) {
                cardOK = Cardinality.subsumes(reqCard, suppliedCard);
            }
        }
        if (cardOK && suppliedCard == 8192) {
            return exp;
        }
        if (suppliedCard == 8192 && (reqCard & 0x2000) == 0) {
            XPathException err8 = new XPathException("An empty sequence is not allowed as the " + role.getMessage(), role.getErrorCode(), supplied.getLocation());
            err8.setIsTypeError(role.isTypeError());
            throw err8;
        }
        int n = relation = itemTypeOK ? 2 : th.relationship(suppliedItemType, reqItemType);
        if (reqCard == 8192) {
            relation = 0;
        }
        if (relation == 4) {
            if (Cardinality.allowsZero(suppliedCard) && Cardinality.allowsZero(reqCard)) {
                if (suppliedCard != 8192) {
                    msg = role.composeErrorMessage(reqItemType, supplied, suppliedItemType);
                    msg = msg + ". The expression can succeed only if the supplied value is an empty sequence.";
                    visitor.issueWarning(msg, supplied.getLocation());
                }
            } else {
                msg = role.composeErrorMessage(reqItemType, supplied, suppliedItemType);
                XPathException err9 = new XPathException(msg, role.getErrorCode(), supplied.getLocation());
                err9.setIsTypeError(role.isTypeError());
                throw err9;
            }
        }
        if (relation != 0 && relation != 2) {
            if (exp instanceof Literal) {
                if (req.matches(((Literal)exp).getValue(), th)) {
                    return exp;
                }
                msg = role.composeErrorMessage(reqItemType, supplied, suppliedItemType);
                XPathException err10 = new XPathException(msg, role.getErrorCode(), supplied.getLocation());
                err10.setIsTypeError(role.isTypeError());
                throw err10;
            }
            cexp = new ItemChecker(exp, reqItemType, role);
            ExpressionTool.copyLocationInfo(exp, cexp);
            exp = cexp;
        }
        if (!cardOK) {
            if (exp instanceof Literal) {
                XPathException err11 = new XPathException("Required cardinality of " + role.getMessage() + " is " + Cardinality.toString(reqCard) + "; supplied value has cardinality " + Cardinality.toString(suppliedCard), role.getErrorCode(), supplied.getLocation());
                err11.setIsTypeError(role.isTypeError());
                throw err11;
            }
            cexp = CardinalityChecker.makeCardinalityChecker(exp, reqCard, role);
            ExpressionTool.copyLocationInfo(exp, cexp);
            exp = cexp;
        }
        return exp;
    }

    public Expression makeArithmeticExpression(Expression lhs, int operator, Expression rhs) {
        return new ArithmeticExpression(lhs, operator, rhs);
    }

    public Expression makeGeneralComparison(Expression lhs, int operator, Expression rhs) {
        return new GeneralComparison20(lhs, operator, rhs);
    }

    public Expression processValueOf(Expression select, Configuration config) {
        return select;
    }

    private static Expression makeFunctionSequenceCoercer(Expression exp, FunctionItemType reqItemType, ExpressionVisitor visitor, RoleDiagnostic role) throws XPathException {
        return reqItemType.makeFunctionSequenceCoercer(exp, role);
    }

    public static Expression strictTypeCheck(Expression supplied, SequenceType req, RoleDiagnostic role, StaticContext env) throws XPathException {
        Expression cexp;
        int relation;
        boolean itemTypeOK;
        boolean cardOK;
        Expression exp = supplied;
        TypeHierarchy th = env.getConfiguration().getTypeHierarchy();
        ItemType reqItemType = req.getPrimaryType();
        int reqCard = req.getCardinality();
        ItemType suppliedItemType = null;
        int suppliedCard = -1;
        boolean bl = cardOK = reqCard == 57344;
        if (!cardOK) {
            suppliedCard = exp.getCardinality();
            cardOK = Cardinality.subsumes(reqCard, suppliedCard);
        }
        if (!(itemTypeOK = req.getPrimaryType() instanceof AnyItemType)) {
            suppliedItemType = exp.getItemType();
            relation = th.relationship(reqItemType, suppliedItemType);
            boolean bl2 = itemTypeOK = relation == 0 || relation == 1;
        }
        if (itemTypeOK && cardOK) {
            return exp;
        }
        if (suppliedCard == -1) {
            suppliedCard = suppliedItemType instanceof ErrorType ? 8192 : exp.getCardinality();
            if (!cardOK) {
                cardOK = Cardinality.subsumes(reqCard, suppliedCard);
            }
        }
        if (cardOK && suppliedCard == 8192) {
            return exp;
        }
        if (suppliedItemType == null) {
            suppliedItemType = exp.getItemType();
        }
        if (suppliedCard == 8192 && (reqCard & 0x2000) == 0) {
            XPathException err2 = new XPathException("An empty sequence is not allowed as the " + role.getMessage(), role.getErrorCode(), supplied.getLocation());
            err2.setIsTypeError(role.isTypeError());
            throw err2;
        }
        relation = th.relationship(suppliedItemType, reqItemType);
        if (relation == 4) {
            if (Cardinality.allowsZero(suppliedCard) && Cardinality.allowsZero(reqCard)) {
                if (suppliedCard != 8192) {
                    String msg = "Required item type of " + role.getMessage() + " is " + reqItemType.toString() + "; supplied value (" + supplied.toShortString() + ") has item type " + suppliedItemType.toString() + ". The expression can succeed only if the supplied value is an empty sequence.";
                    env.issueWarning(msg, supplied.getLocation());
                }
            } else {
                String msg = role.composeErrorMessage(reqItemType, supplied, suppliedItemType);
                XPathException err3 = new XPathException(msg, role.getErrorCode(), supplied.getLocation());
                err3.setIsTypeError(role.isTypeError());
                throw err3;
            }
        }
        if (relation != 0 && relation != 2) {
            cexp = new ItemChecker(exp, reqItemType, role);
            cexp.adoptChildExpression(exp);
            exp = cexp;
        }
        if (!cardOK) {
            if (exp instanceof Literal) {
                XPathException err4 = new XPathException("Required cardinality of " + role.getMessage() + " is " + Cardinality.toString(reqCard) + "; supplied value has cardinality " + Cardinality.toString(suppliedCard), role.getErrorCode(), supplied.getLocation());
                err4.setIsTypeError(role.isTypeError());
                throw err4;
            }
            cexp = CardinalityChecker.makeCardinalityChecker(exp, reqCard, role);
            cexp.adoptChildExpression(exp);
            exp = cexp;
        }
        return exp;
    }

    public static XPathException testConformance(Sequence val, SequenceType requiredType, XPathContext context) throws XPathException {
        Item item;
        ItemType reqItemType = requiredType.getPrimaryType();
        SequenceIterator iter2 = val.iterate();
        int count2 = 0;
        while ((item = iter2.next()) != null) {
            ++count2;
            if (reqItemType.matches(item, context.getConfiguration().getTypeHierarchy())) continue;
            XPathException err2 = new XPathException("Required type is " + reqItemType + "; supplied value has type " + UType.getUType(SequenceTool.toGroundedValue(val)));
            err2.setIsTypeError(true);
            err2.setErrorCode("XPTY0004");
            return err2;
        }
        int reqCardinality = requiredType.getCardinality();
        if (count2 == 0 && !Cardinality.allowsZero(reqCardinality)) {
            XPathException err3 = new XPathException("Required type does not allow empty sequence, but supplied value is empty");
            err3.setIsTypeError(true);
            err3.setErrorCode("XPTY0004");
            return err3;
        }
        if (count2 > 1 && !Cardinality.allowsMany(reqCardinality)) {
            XPathException err4 = new XPathException("Required type requires a singleton sequence; supplied value contains " + count2 + " items");
            err4.setIsTypeError(true);
            err4.setErrorCode("XPTY0004");
            return err4;
        }
        if (count2 > 0 && reqCardinality == 8192) {
            XPathException err5 = new XPathException("Required type requires an empty sequence, but supplied value is non-empty");
            err5.setIsTypeError(true);
            err5.setErrorCode("XPTY0004");
            return err5;
        }
        return null;
    }

    public static XPathException ebvError(Expression exp, TypeHierarchy th) {
        if (Cardinality.allowsZero(exp.getCardinality())) {
            return null;
        }
        ItemType t = exp.getItemType();
        if (th.relationship(t, Type.NODE_TYPE) == 4 && th.relationship(t, BuiltInAtomicType.BOOLEAN) == 4 && th.relationship(t, BuiltInAtomicType.STRING) == 4 && th.relationship(t, BuiltInAtomicType.ANY_URI) == 4 && th.relationship(t, BuiltInAtomicType.UNTYPED_ATOMIC) == 4 && th.relationship(t, NumericType.getInstance()) == 4 && !(t instanceof JavaExternalObjectType)) {
            XPathException err2 = new XPathException("Effective boolean value is defined only for sequences containing booleans, strings, numbers, URIs, or nodes");
            err2.setErrorCode("FORG0006");
            err2.setIsTypeError(true);
            return err2;
        }
        return null;
    }

    private static Expression makePromoterToDouble(Expression exp) {
        return TypeChecker.makePromoter(exp, new Converter.PromoterToDouble(), BuiltInAtomicType.DOUBLE);
    }

    private static Expression makePromoterToFloat(Expression exp) {
        return TypeChecker.makePromoter(exp, new Converter.PromoterToFloat(), BuiltInAtomicType.FLOAT);
    }

    private static Expression makePromoter(Expression exp, Converter converter, BuiltInAtomicType type) {
        ConversionResult result2;
        ConversionRules rules = exp.getConfiguration().getConversionRules();
        converter.setConversionRules(rules);
        if (exp instanceof Literal && ((Literal)exp).getValue() instanceof AtomicValue && (result2 = converter.convert((AtomicValue)((Literal)exp).getValue())) instanceof AtomicValue) {
            Literal converted = Literal.makeLiteral((AtomicValue)result2);
            ExpressionTool.copyLocationInfo(exp, converted);
            return converted;
        }
        AtomicSequenceConverter asc = new AtomicSequenceConverter(exp, type);
        asc.setConverter(converter);
        ExpressionTool.copyLocationInfo(exp, asc);
        return asc;
    }
}

