/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.parser;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;

public abstract class Evaluator {
    public static final Evaluator LITERAL = new Evaluator(){

        public Sequence evaluate(Expression expr, XPathContext context) throws XPathException {
            return ((Literal)expr).getValue();
        }
    };
    public static final Evaluator VARIABLE = new Evaluator(){

        public Sequence evaluate(Expression expr, XPathContext context) throws XPathException {
            try {
                return ((VariableReference)expr).evaluateVariable(context);
            }
            catch (ClassCastException e) {
                assert (false);
                return LAZY_SEQUENCE.evaluate(expr, context);
            }
        }
    };
    public static final Evaluator SINGLE_ITEM = new Evaluator(){

        public Item evaluate(Expression expr, XPathContext context) throws XPathException {
            return expr.evaluateItem(context);
        }
    };
    public static final Evaluator OPTIONAL_ITEM = new Evaluator(){

        public Sequence evaluate(Expression expr, XPathContext context) throws XPathException {
            Item item = expr.evaluateItem(context);
            return item == null ? EmptySequence.getInstance() : item;
        }
    };
    public static final Evaluator LAZY_SEQUENCE = new Evaluator(){

        public Sequence evaluate(Expression expr, XPathContext context) throws XPathException {
            SequenceIterator iter2 = expr.iterate(context);
            return new LazySequence(iter2);
        }
    };
    public static final Evaluator EAGER_SEQUENCE = new Evaluator(){

        public Sequence evaluate(Expression expr, XPathContext context) throws XPathException {
            SequenceIterator iter2 = expr.iterate(context);
            return SequenceExtent.makeSequenceExtent(iter2);
        }
    };

    public abstract Sequence evaluate(Expression var1, XPathContext var2) throws XPathException;
}

