/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.number;

import java.util.Locale;
import net.sf.saxon.expr.number.Alphanumeric;
import net.sf.saxon.expr.number.NumericGroupFormatter;
import net.sf.saxon.expr.number.RegularGroupFormatter;
import net.sf.saxon.lib.Numberer;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.tree.util.FastStringBuffer;

public abstract class AbstractNumberer
implements Numberer {
    private String country;
    public static final int UPPER_CASE = 0;
    public static final int LOWER_CASE = 1;
    public static final int TITLE_CASE = 2;
    protected static final int[] westernDigits = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    protected static final String latinUpper = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    protected static final String latinLower = "abcdefghijklmnopqrstuvwxyz";
    protected static final String greekUpper = "\u0391\u0392\u0393\u0394\u0395\u0396\u0397\u0398\u0399\u039a\u039b\u039c\u039d\u039e\u039f\u03a0\u03a1\u03a2\u03a3\u03a4\u03a5\u03a6\u03a7\u03a8\u03a9";
    protected static final String greekLower = "\u03b1\u03b2\u03b3\u03b4\u03b5\u03b6\u03b7\u03b8\u03b9\u03ba\u03bb\u03bc\u03bd\u03be\u03bf\u03c0\u03c1\u03c2\u03c3\u03c4\u03c5\u03c6\u03c7\u03c8\u03c9";
    protected static final String cyrillicUpper = "\u0410\u0411\u0412\u0413\u0414\u0415\u0416\u0417\u0418\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0421\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042b\u042d\u042e\u042f";
    protected static final String cyrillicLower = "\u0430\u0431\u0432\u0433\u0434\u0435\u0436\u0437\u0438\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0441\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044b\u044d\u044e\u044f";
    protected static final String hebrew = "\u05d0\u05d1\u05d2\u05d3\u05d4\u05d5\u05d6\u05d7\u05d8\u05d9\u05db\u05dc\u05de\u05e0\u05e1\u05e2\u05e4\u05e6\u05e7\u05e8\u05e9\u05ea";
    protected static final String hiraganaA = "\u3042\u3044\u3046\u3048\u304a\u304b\u304d\u304f\u3051\u3053\u3055\u3057\u3059\u305b\u305d\u305f\u3061\u3064\u3066\u3068\u306a\u306b\u306c\u306d\u306e\u306f\u3072\u3075\u3078\u307b\u307e\u307f\u3080\u3081\u3082\u3084\u3086\u3088\u3089\u308a\u308b\u308c\u308d\u308f\u3092\u3093";
    protected static final String katakanaA = "\u30a2\u30a4\u30a6\u30a8\u30aa\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d2\u30d5\u30d8\u30db\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30f2\u30f3";
    protected static final String hiraganaI = "\u3044\u308d\u306f\u306b\u307b\u3078\u3068\u3061\u308a\u306c\u308b\u3092\u308f\u304b\u3088\u305f\u308c\u305d\u3064\u306d\u306a\u3089\u3080\u3046\u3090\u306e\u304a\u304f\u3084\u307e\u3051\u3075\u3053\u3048\u3066\u3042\u3055\u304d\u3086\u3081\u307f\u3057\u3091\u3072\u3082\u305b\u3059";
    protected static final String katakanaI = "\u30a4\u30ed\u30cf\u30cb\u30db\u30d8\u30c8\u30c1\u30ea\u30cc\u30eb\u30f2\u30ef\u30ab\u30e8\u30bf\u30ec\u30bd\u30c4\u30cd\u30ca\u30e9\u30e0\u30a6\u30f0\u30ce\u30aa\u30af\u30e4\u30de\u30b1\u30d5\u30b3\u30a8\u30c6\u30a2\u30b5\u30ad\u30e6\u30e1\u30df\u30b7\u30f1\u30d2\u30e2\u30bb\u30b9";
    private static String[] romanThousands = new String[]{"", "m", "mm", "mmm", "mmmm", "mmmmm", "mmmmmm", "mmmmmmm", "mmmmmmmm", "mmmmmmmmm"};
    private static String[] romanHundreds = new String[]{"", "c", "cc", "ccc", "cd", "d", "dc", "dcc", "dccc", "cm"};
    private static String[] romanTens = new String[]{"", "x", "xx", "xxx", "xl", "l", "lx", "lxx", "lxxx", "xc"};
    private static String[] romanUnits = new String[]{"", "i", "ii", "iii", "iv", "v", "vi", "vii", "viii", "ix"};
    private static final int[] kanjiDigits = new int[]{12295, 19968, 20108, 19977, 22235, 20116, 20845, 19971, 20843, 20061};

    public Locale defaultedLocale() {
        return null;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getCountry() {
        return this.country;
    }

    public final String format(long number2, UnicodeString picture, int groupSize, String groupSeparator, String letterValue, String ordinal) {
        return this.format(number2, picture, new RegularGroupFormatter(groupSize, groupSeparator, UnicodeString.EMPTY_STRING), letterValue, ordinal);
    }

    public String format(long number2, UnicodeString picture, NumericGroupFormatter numGroupFormatter, String letterValue, String ordinal) {
        if (number2 < 0L) {
            return "" + number2;
        }
        if (picture == null || picture.uLength() == 0) {
            return "" + number2;
        }
        int pictureLength = picture.uLength();
        FastStringBuffer sb = new FastStringBuffer(16);
        int formchar = picture.uCharAt(0);
        FastStringBuffer fsb = new FastStringBuffer(2);
        switch (formchar) {
            case 48: 
            case 49: {
                sb.append(this.toRadical(number2, westernDigits, pictureLength, numGroupFormatter));
                if (ordinal == null || ordinal.length() <= 0) break;
                sb.append(this.ordinalSuffix(ordinal, number2));
                break;
            }
            case 65: {
                if (number2 == 0L) {
                    return "0";
                }
                return this.toAlphaSequence(number2, latinUpper);
            }
            case 97: {
                if (number2 == 0L) {
                    return "0";
                }
                return this.toAlphaSequence(number2, latinLower);
            }
            case 87: 
            case 119: {
                int wordCase = picture.uLength() == 1 ? (formchar == 87 ? 0 : 1) : 2;
                if (ordinal != null && ordinal.length() > 0) {
                    return this.toOrdinalWords(ordinal, number2, wordCase);
                }
                return this.toWords(number2, wordCase);
            }
            case 105: {
                if (number2 == 0L) {
                    return "0";
                }
                if (letterValue == null || letterValue.isEmpty() || letterValue.equals("traditional")) {
                    return AbstractNumberer.toRoman(number2);
                }
                this.alphaDefault(number2, 'i', sb);
                break;
            }
            case 73: {
                if (number2 == 0L) {
                    return "0";
                }
                if (letterValue == null || letterValue.isEmpty() || letterValue.equals("traditional")) {
                    return AbstractNumberer.toRoman(number2).toUpperCase();
                }
                this.alphaDefault(number2, 'I', sb);
                break;
            }
            case 9312: {
                if (number2 == 0L) {
                    return "\u24ea";
                }
                if (number2 > 20L && number2 <= 35L) {
                    return "" + (char)(12881L + number2 - 21L);
                }
                if (number2 > 35L && number2 <= 50L) {
                    return "" + (char)(12977L + number2 - 36L);
                }
                if (number2 > 50L) {
                    return "" + number2;
                }
                return "" + (char)(9312L + number2 - 1L);
            }
            case 9332: {
                if (number2 == 0L || number2 > 20L) {
                    return "" + number2;
                }
                return "" + (char)(9332L + number2 - 1L);
            }
            case 9352: {
                if (number2 == 0L) {
                    return "\ud83c\udd00";
                }
                if (number2 > 20L) {
                    return "" + number2;
                }
                return "" + (char)(9352L + number2 - 1L);
            }
            case 10102: {
                if (number2 == 0L) {
                    return "\u24ff";
                }
                if (number2 > 10L && number2 <= 20L) {
                    return "" + (char)(9451L + number2 - 11L);
                }
                if (number2 > 20L) {
                    return "" + number2;
                }
                return "" + (char)(10102L + number2 - 1L);
            }
            case 10112: {
                if (number2 == 0L) {
                    return "\ud83c\udd0b";
                }
                if (number2 > 10L) {
                    return "" + number2;
                }
                return "" + (char)(10112L + number2 - 1L);
            }
            case 9461: {
                if (number2 == 0L || number2 > 10L) {
                    return "" + number2;
                }
                return "" + (char)(9461L + number2 - 1L);
            }
            case 10122: {
                if (number2 == 0L) {
                    return "\ud83c\udd0c";
                }
                if (number2 > 10L) {
                    return "" + number2;
                }
                return "" + (char)(10122L + number2 - 1L);
            }
            case 12832: {
                if (number2 == 0L || number2 > 10L) {
                    return "" + number2;
                }
                return "" + (char)(12832L + number2 - 1L);
            }
            case 12928: {
                if (number2 == 0L || number2 > 10L) {
                    return "" + number2;
                }
                return "" + (char)(12928L + number2 - 1L);
            }
            case 65799: {
                if (number2 == 0L || number2 > 10L) {
                    return "" + number2;
                }
                fsb.appendWideChar(65799 + (int)number2 - 1);
                return fsb.toString();
            }
            case 69216: {
                if (number2 == 0L || number2 > 10L) {
                    return "" + number2;
                }
                fsb.appendWideChar(69216 + (int)number2 - 1);
                return fsb.toString();
            }
            case 69714: {
                if (number2 == 0L || number2 > 10L) {
                    return "" + number2;
                }
                fsb.appendWideChar(69714 + (int)number2 - 1);
                return fsb.toString();
            }
            case 119648: {
                if (number2 == 0L || number2 >= 10L) {
                    return "" + number2;
                }
                fsb.appendWideChar(119648 + (int)number2 - 1);
                return fsb.toString();
            }
            case 127234: {
                if (number2 == 0L) {
                    fsb.appendWideChar(127233);
                    return fsb.toString();
                }
                if (number2 >= 10L) {
                    return "" + number2;
                }
                fsb.appendWideChar(127234 + (int)number2 - 1);
                return fsb.toString();
            }
            case 913: {
                if (number2 == 0L) {
                    return "0";
                }
                return this.toAlphaSequence(number2, greekUpper);
            }
            case 945: {
                if (number2 == 0L) {
                    return "0";
                }
                return this.toAlphaSequence(number2, greekLower);
            }
            case 1040: {
                if (number2 == 0L) {
                    return "0";
                }
                return this.toAlphaSequence(number2, cyrillicUpper);
            }
            case 1072: {
                if (number2 == 0L) {
                    return "0";
                }
                return this.toAlphaSequence(number2, cyrillicLower);
            }
            case 1488: {
                if (number2 == 0L) {
                    return "0";
                }
                return this.toAlphaSequence(number2, hebrew);
            }
            case 12354: {
                if (number2 == 0L) {
                    return "0";
                }
                return this.toAlphaSequence(number2, hiraganaA);
            }
            case 12450: {
                if (number2 == 0L) {
                    return "0";
                }
                return this.toAlphaSequence(number2, katakanaA);
            }
            case 12356: {
                if (number2 == 0L) {
                    return "0";
                }
                return this.toAlphaSequence(number2, hiraganaI);
            }
            case 12452: {
                if (number2 == 0L) {
                    return "0";
                }
                return this.toAlphaSequence(number2, katakanaI);
            }
            case 19968: {
                return this.toJapanese(number2);
            }
            default: {
                int digitValue = Alphanumeric.getDigitValue(formchar);
                if (digitValue >= 0) {
                    int zero2 = formchar - digitValue;
                    int[] digits = new int[10];
                    for (int z = 0; z <= 9; ++z) {
                        digits[z] = zero2 + z;
                    }
                    return this.toRadical(number2, digits, pictureLength, numGroupFormatter);
                }
                if (formchar < 4352 && Character.isLetter((char)formchar) && number2 > 0L) {
                    this.alphaDefault(number2, (char)formchar, sb);
                    break;
                }
                sb.append(this.toRadical(number2, westernDigits, pictureLength, numGroupFormatter));
                if (ordinal == null || ordinal.length() <= 0) break;
                sb.append(this.ordinalSuffix(ordinal, number2));
            }
        }
        return sb.toString();
    }

    protected String ordinalSuffix(String ordinalParam, long number2) {
        return "";
    }

    protected void alphaDefault(long number2, char formchar, FastStringBuffer sb) {
        int min2 = formchar;
        int max2 = formchar;
        while (Character.isLetterOrDigit((char)(max2 + '\u0001'))) {
            ++max2;
        }
        sb.append(this.toAlpha(number2, min2, max2));
    }

    protected String toAlpha(long number2, int min2, int max2) {
        if (number2 <= 0L) {
            return "" + number2;
        }
        int range2 = max2 - min2 + 1;
        char last2 = (char)((number2 - 1L) % (long)range2 + (long)min2);
        if (number2 > (long)range2) {
            return this.toAlpha((number2 - 1L) / (long)range2, min2, max2) + last2;
        }
        return "" + last2;
    }

    protected String toAlphaSequence(long number2, String alphabet) {
        if (number2 <= 0L) {
            return "" + number2;
        }
        int range2 = alphabet.length();
        char last2 = alphabet.charAt((int)((number2 - 1L) % (long)range2));
        if (number2 > (long)range2) {
            return this.toAlphaSequence((number2 - 1L) / (long)range2, alphabet) + last2;
        }
        return "" + last2;
    }

    private String toRadical(long number2, int[] digits, int pictureLength, NumericGroupFormatter numGroupFormatter) {
        FastStringBuffer temp = AbstractNumberer.convertDigitSystem(number2, digits, pictureLength);
        if (numGroupFormatter == null) {
            return temp.toString();
        }
        return numGroupFormatter.format(temp);
    }

    public static FastStringBuffer convertDigitSystem(long number2, int[] digits, int requiredLength) {
        FastStringBuffer temp = new FastStringBuffer(16);
        int base = digits.length;
        FastStringBuffer s2 = new FastStringBuffer(16);
        int count2 = 0;
        for (long n = number2; n > 0L; n /= (long)base) {
            int digit2 = digits[(int)(n % (long)base)];
            s2.prependWideChar(digit2);
            ++count2;
        }
        for (int i = 0; i < requiredLength - count2; ++i) {
            temp.appendWideChar(digits[0]);
        }
        temp.append(s2);
        return temp;
    }

    public static String toRoman(long n) {
        if (n <= 0L || n > 9999L) {
            return "" + n;
        }
        return romanThousands[(int)n / 1000] + romanHundreds[(int)n / 100 % 10] + romanTens[(int)n / 10 % 10] + romanUnits[(int)n % 10];
    }

    public String toJapanese(long number2) {
        FastStringBuffer fsb = new FastStringBuffer(16);
        if (number2 == 0L) {
            fsb.appendWideChar(12295);
        } else if (number2 <= 9999L) {
            AbstractNumberer.toJapanese((int)number2, fsb, false);
        } else {
            fsb.append("" + number2);
        }
        return fsb.toString();
    }

    private static void toJapanese(int nr, FastStringBuffer fsb, boolean isInitial) {
        if (nr != 0) {
            if (nr <= 9) {
                if (nr != 1 || !isInitial) {
                    fsb.appendWideChar(kanjiDigits[nr]);
                }
            } else if (nr == 10) {
                fsb.appendWideChar(21313);
            } else if (nr <= 99) {
                AbstractNumberer.toJapanese(nr / 10, fsb, true);
                fsb.appendWideChar(21313);
                AbstractNumberer.toJapanese(nr % 10, fsb, false);
            } else if (nr <= 999) {
                AbstractNumberer.toJapanese(nr / 100, fsb, true);
                fsb.appendWideChar(30334);
                AbstractNumberer.toJapanese(nr % 100, fsb, false);
            } else if (nr <= 9999) {
                AbstractNumberer.toJapanese(nr / 1000, fsb, true);
                fsb.appendWideChar(21315);
                AbstractNumberer.toJapanese(nr % 1000, fsb, false);
            }
        }
    }

    public abstract String toWords(long var1);

    public String toWords(long number2, int wordCase) {
        String s2 = number2 == 0L ? "Zero" : this.toWords(number2);
        if (wordCase == 0) {
            return s2.toUpperCase();
        }
        if (wordCase == 1) {
            return s2.toLowerCase();
        }
        return s2;
    }

    public abstract String toOrdinalWords(String var1, long var2, int var4);

    public abstract String monthName(int var1, int var2, int var3);

    public abstract String dayName(int var1, int var2, int var3);

    public String halfDayName(int minutes, int minWidth, int maxWidth) {
        String s2;
        if (minutes == 0 && maxWidth >= 8 && "gb".equals(this.country)) {
            s2 = "Midnight";
        } else if (minutes < 720) {
            switch (maxWidth) {
                case 1: {
                    s2 = "A";
                    break;
                }
                case 2: 
                case 3: {
                    s2 = "Am";
                    break;
                }
                default: {
                    s2 = "A.M.";
                    break;
                }
            }
        } else if (minutes == 720 && maxWidth >= 8 && "gb".equals(this.country)) {
            s2 = "Noon";
        } else {
            switch (maxWidth) {
                case 1: {
                    s2 = "P";
                    break;
                }
                case 2: 
                case 3: {
                    s2 = "Pm";
                    break;
                }
                default: {
                    s2 = "P.M.";
                }
            }
        }
        return s2;
    }

    public String getOrdinalSuffixForDateTime(String component) {
        return "yes";
    }

    public String getEraName(int year) {
        return year > 0 ? "AD" : "BC";
    }

    public String getCalendarName(String code) {
        if (code.equals("AD")) {
            return "Gregorian";
        }
        return code;
    }
}

