/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WithParam {
    public static WithParam[] EMPTY_ARRAY = new WithParam[0];
    private Operand selectOp;
    private boolean typeChecked = false;
    private int slotNumber = -1;
    private SequenceType requiredType;
    private StructuredQName variableQName;
    private int evaluationMode = -1;

    public void setSelectExpression(Expression parent, Expression select) {
        this.selectOp = new Operand(parent, select, OperandRole.NAVIGATE);
    }

    public Expression getSelectExpression() {
        return this.selectOp.getChildExpression();
    }

    public void setRequiredType(SequenceType required) {
        this.requiredType = required;
    }

    public SequenceType getRequiredType() {
        return this.requiredType;
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public void setSlotNumber(int s2) {
        this.slotNumber = s2;
    }

    public void setVariableQName(StructuredQName s2) {
        this.variableQName = s2;
    }

    public StructuredQName getVariableQName() {
        return this.variableQName;
    }

    public void setTypeChecked(boolean checked) {
        this.typeChecked = checked;
    }

    public int getInstructionNameCode() {
        return 208;
    }

    public static void simplify(WithParam[] params) throws XPathException {
        if (params != null) {
            for (WithParam param2 : params) {
                param2.selectOp.setChildExpression(param2.selectOp.getChildExpression().simplify());
            }
        }
    }

    public static void typeCheck(WithParam[] params, ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        if (params != null) {
            for (WithParam param2 : params) {
                param2.selectOp.typeCheck(visitor, contextItemType);
            }
        }
    }

    public static void optimize(ExpressionVisitor visitor, WithParam[] params, ContextItemStaticInfo contextItemType) throws XPathException {
        if (params != null) {
            for (WithParam param2 : params) {
                param2.selectOp.optimize(visitor, contextItemType);
                param2.computeEvaluationMode();
            }
        }
    }

    public int getEvaluationMode() {
        if (this.evaluationMode == -1) {
            this.computeEvaluationMode();
        }
        return this.evaluationMode;
    }

    private void computeEvaluationMode() {
        this.evaluationMode = ExpressionTool.lazyEvaluationMode(this.selectOp.getChildExpression());
    }

    public static WithParam[] copy(Expression parent, WithParam[] params, RebindingMap rebindings) {
        if (params == null) {
            return null;
        }
        WithParam[] result2 = new WithParam[params.length];
        for (int i = 0; i < params.length; ++i) {
            result2[i] = new WithParam();
            result2[i].slotNumber = params[i].slotNumber;
            result2[i].typeChecked = params[i].typeChecked;
            result2[i].selectOp = new Operand(parent, params[i].selectOp.getChildExpression().copy(rebindings), OperandRole.NAVIGATE);
            result2[i].requiredType = params[i].requiredType;
            result2[i].variableQName = params[i].variableQName;
        }
        return result2;
    }

    public static void gatherOperands(Expression parent, WithParam[] params, List<Operand> list2) {
        if (params != null) {
            for (WithParam param2 : params) {
                list2.add(param2.selectOp);
            }
        }
    }

    public static void exportParameters(WithParam[] params, ExpressionPresenter out, boolean tunnel) throws XPathException {
        if (params != null) {
            for (WithParam param2 : params) {
                out.startElement("withParam");
                out.emitAttribute("name", param2.variableQName.getEQName());
                String flags = "";
                if (tunnel) {
                    flags = flags + "t";
                }
                if (param2.isTypeChecked()) {
                    flags = flags + "c";
                }
                if (!flags.isEmpty()) {
                    out.emitAttribute("flags", flags);
                }
                if (param2.getRequiredType() != SequenceType.ANY_SEQUENCE) {
                    out.emitAttribute("as", param2.getRequiredType().toExportString());
                }
                if (param2.getSlotNumber() != -1) {
                    out.emitAttribute("slot", param2.getSlotNumber() + "");
                }
                param2.selectOp.getChildExpression().export(out);
                out.endElement();
            }
        }
    }

    public Sequence getSelectValue(XPathContext context) throws XPathException {
        int savedOutputState = context.getTemporaryOutputState();
        context.setTemporaryOutputState(208);
        Sequence result2 = ExpressionTool.evaluate(this.selectOp.getChildExpression(), this.evaluationMode, context, 10);
        context.setTemporaryOutputState(savedOutputState);
        return result2;
    }

    public boolean isTypeChecked() {
        return this.typeChecked;
    }
}

