/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.Controller;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.SimpleNodeConstructor;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public final class ValueOf
extends SimpleNodeConstructor {
    private int options;
    private boolean isNumberingInstruction = false;
    private boolean noNodeIfEmpty;

    public ValueOf(Expression select, boolean disable, boolean noNodeIfEmpty) {
        this.setSelect(select);
        this.options = disable ? 1 : 0;
        this.noNodeIfEmpty = noNodeIfEmpty;
        this.adoptChildExpression(select);
        if (select instanceof StringLiteral) {
            boolean special = false;
            String val = ((StringLiteral)select).getStringValue();
            for (int k = 0; k < val.length(); ++k) {
                char c = val.charAt(k);
                if (c >= '!' && c <= '~' && c != '<' && c != '>' && c != '&') continue;
                special = true;
                break;
            }
            if (!special) {
                this.options |= 4;
            }
        }
    }

    public void setIsNumberingInstruction() {
        this.isNumberingInstruction = true;
    }

    public boolean isNumberingInstruction() {
        return this.isNumberingInstruction;
    }

    public boolean isNoNodeIfEmpty() {
        return this.noNodeIfEmpty;
    }

    public String toShortString() {
        if (this.getSelect() instanceof StringLiteral) {
            return "text{" + Err.depict(((StringLiteral)this.getSelect()).getValue()).toString() + "}";
        }
        return super.toShortString();
    }

    public int getInstructionNameCode() {
        if (this.isNumberingInstruction) {
            return 180;
        }
        if (this.getSelect() instanceof StringLiteral) {
            return 201;
        }
        return 205;
    }

    public int getOptions() {
        return this.options;
    }

    public boolean isDisableOutputEscaping() {
        return (this.options & 1) != 0;
    }

    public ItemType getItemType() {
        return NodeKindTest.TEXT;
    }

    public int computeCardinality() {
        if (this.noNodeIfEmpty) {
            return 24576;
        }
        return 16384;
    }

    public void localTypeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) {
    }

    public int getIntrinsicDependencies() {
        int d = super.getIntrinsicDependencies();
        if (this.isDisableOutputEscaping()) {
            d |= 0x200;
        }
        return d;
    }

    public Expression copy(RebindingMap rebindings) {
        ValueOf exp = new ValueOf(this.getSelect().copy(rebindings), (this.options & 1) != 0, this.noNodeIfEmpty);
        ExpressionTool.copyLocationInfo(this, exp);
        if (this.isNumberingInstruction) {
            exp.setIsNumberingInstruction();
        }
        return exp;
    }

    public void checkPermittedContents(SchemaType parentType, boolean whole) throws XPathException {
        if (this.getSelect() instanceof Literal) {
            GroundedValue selectValue = ((Literal)this.getSelect()).getValue();
            SimpleType stype = null;
            if (parentType instanceof SimpleType && whole) {
                stype = (SimpleType)parentType;
            } else if (parentType instanceof ComplexType && ((ComplexType)parentType).isSimpleContent()) {
                stype = ((ComplexType)parentType).getSimpleContentType();
            }
            if (whole && stype != null && !stype.isNamespaceSensitive()) {
                ValidationFailure err2 = stype.validateContent(selectValue.getStringValue(), null, this.getConfiguration().getConversionRules());
                if (err2 != null) {
                    err2.setLocator(this.getLocation());
                    err2.setErrorCode(this.isXSLT() ? "XTTE1540" : "XQDY0027");
                    throw err2.makeException();
                }
                return;
            }
            if (parentType instanceof ComplexType && !((ComplexType)parentType).isSimpleContent() && !((ComplexType)parentType).isMixedContent() && !Whitespace.isWhite(selectValue.getStringValue())) {
                XPathException err3 = new XPathException("The containing element must be of type " + parentType.getDescription() + ", which does not allow text content " + Err.wrap(selectValue.getStringValue()));
                err3.setLocation(this.getLocation());
                err3.setIsTypeError(true);
                throw err3;
            }
        }
    }

    public Expression convertToCastAsString() {
        if (this.noNodeIfEmpty || !Cardinality.allowsZero(this.getSelect().getCardinality())) {
            return new CastExpression(this.getSelect(), BuiltInAtomicType.UNTYPED_ATOMIC, true);
        }
        Expression sf = SystemFunction.makeCall("string", this.getRetainedStaticContext(), this.getSelect());
        return new CastExpression(sf, BuiltInAtomicType.UNTYPED_ATOMIC, false);
    }

    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        if (this.noNodeIfEmpty) {
            StringValue value2 = (StringValue)this.getSelect().evaluateItem(context);
            if (value2 != null) {
                this.processValue(value2.getStringValueCS(), context);
            }
            return null;
        }
        return super.processLeavingTail(context);
    }

    public void processValue(CharSequence value2, XPathContext context) throws XPathException {
        SequenceReceiver out = context.getReceiver();
        out.characters(value2, this.getLocation(), this.options);
    }

    public NodeInfo evaluateItem(XPathContext context) throws XPathException {
        try {
            CharSequence val;
            Item item = this.getSelect().evaluateItem(context);
            if (item == null) {
                if (this.noNodeIfEmpty) {
                    return null;
                }
                val = "";
            } else {
                val = item.getStringValueCS();
            }
            Controller controller = context.getController();
            assert (controller != null);
            Orphan o = new Orphan(controller.getConfiguration());
            o.setNodeKind((short)3);
            o.setStringValue(val);
            if ((this.options & 1) != 0) {
                o.setDisableOutputEscaping(true);
            }
            return o;
        }
        catch (XPathException err2) {
            err2.maybeSetLocation(this.getLocation());
            throw err2;
        }
    }

    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("valueOf", this);
        String flags = "";
        if ((this.options & 1) != 0) {
            flags = flags + "d";
        }
        if ((this.options & 4) != 0) {
            flags = flags + "S";
        }
        if (this.noNodeIfEmpty) {
            flags = flags + "e";
        }
        if (this.isLocal()) {
            flags = flags + "l";
        }
        if (!flags.isEmpty()) {
            out.emitAttribute("flags", flags);
        }
        this.getSelect().export(out);
        out.endElement();
    }
}

