/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionOwner;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.LocalParam;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.TailCallReturner;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.rules.Rule;
import net.sf.saxon.trans.rules.RuleTarget;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateRule
implements RuleTarget,
Location,
ExpressionOwner {
    protected Expression body;
    protected Pattern matchPattern;
    private boolean hasRequiredParams;
    private boolean bodyIsTailCallReturner;
    private SequenceType requiredType;
    private boolean declaredStreamable;
    private ItemType requiredContextItemType = AnyItemType.getInstance();
    private boolean absentFocus;
    private SlotManager stackFrameMap;
    private PackageData packageData;
    private String systemId;
    private int lineNumber;
    private List<Rule> rules = new ArrayList<Rule>();
    protected List<TemplateRule> slaveCopies = new ArrayList<TemplateRule>();

    public void setMatchPattern(Pattern pattern) {
        this.matchPattern = pattern;
    }

    public Expression getBody() {
        return this.body;
    }

    public void setContextItemRequirements(ItemType type, boolean absentFocus) {
        this.requiredContextItemType = type;
        this.absentFocus = absentFocus;
    }

    public int getComponentKind() {
        return 200;
    }

    public Pattern getMatchPattern() {
        return this.matchPattern;
    }

    public void setBody(Expression body) {
        this.body = body;
        this.bodyIsTailCallReturner = body instanceof TailCallReturner;
    }

    public void setStackFrameMap(SlotManager map2) {
        this.stackFrameMap = map2;
    }

    public SlotManager getStackFrameMap() {
        return this.stackFrameMap;
    }

    public void setHasRequiredParams(boolean has) {
        this.hasRequiredParams = has;
    }

    public boolean hasRequiredParams() {
        return this.hasRequiredParams;
    }

    public void setRequiredType(SequenceType type) {
        this.requiredType = type;
    }

    public SequenceType getRequiredType() {
        if (this.requiredType == null) {
            return SequenceType.ANY_SEQUENCE;
        }
        return this.requiredType;
    }

    @Override
    public void registerRule(Rule rule) {
        this.rules.add(rule);
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public int getContainerGranularity() {
        return 0;
    }

    public PackageData getPackageData() {
        return this.packageData;
    }

    public void setPackageData(PackageData data2) {
        this.packageData = data2;
    }

    @Override
    public String getPublicId() {
        return null;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String id) {
        this.systemId = id;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int line) {
        this.lineNumber = line;
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }

    @Override
    public Location saveLocation() {
        return this;
    }

    public ItemType getRequiredContextItemType() {
        return this.requiredContextItemType;
    }

    public boolean isAbsentFocus() {
        return this.absentFocus;
    }

    public List<LocalParam> getLocalParams() {
        ArrayList<LocalParam> result2 = new ArrayList<LocalParam>();
        TemplateRule.gatherLocalParams(this.getInterpretedBody(), result2);
        return result2;
    }

    private static void gatherLocalParams(Expression exp, List<LocalParam> result2) {
        if (exp instanceof LocalParam) {
            result2.add((LocalParam)exp);
        } else {
            for (Operand o : exp.operands()) {
                TemplateRule.gatherLocalParams(o.getChildExpression(), result2);
            }
        }
    }

    public void prepareInitializer(Compilation compilation, ComponentDeclaration decl, StructuredQName modeName) {
    }

    public void initialize() throws XPathException {
    }

    public void apply(XPathContextMajor context) throws XPathException {
        for (TailCall tc = this.applyLeavingTail(context); tc != null; tc = tc.processLeavingTail()) {
        }
    }

    public TailCall applyLeavingTail(XPathContext context) throws XPathException {
        if (this.requiredContextItemType != AnyItemType.getInstance() && !this.requiredContextItemType.matches(context.getContextItem(), context.getConfiguration().getTypeHierarchy())) {
            XPathException err2 = new XPathException("The template requires a context item of type " + this.requiredContextItemType + ", but the supplied context item has type " + Type.getItemType(context.getContextItem(), context.getConfiguration().getTypeHierarchy()), "XTTE0590");
            err2.setLocation(this);
            err2.setIsTypeError(true);
            throw err2;
        }
        if (this.absentFocus) {
            context = context.newMinorContext();
            context.setCurrentIterator(null);
        }
        try {
            if (this.bodyIsTailCallReturner) {
                return ((TailCallReturner)((Object)this.body)).processLeavingTail(context);
            }
            this.body.process(context);
            return null;
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            e.maybeSetContext(context);
            throw e;
        }
        catch (Exception e2) {
            String message = "Internal error evaluating template rule " + (this.getLineNumber() > 0 ? " at line " + this.getLineNumber() : "") + (this.getSystemId() != null ? " in module " + this.getSystemId() : "");
            throw new RuntimeException(message, e2);
        }
    }

    public int getConstructType() {
        return 2008;
    }

    @Override
    public void export(ExpressionPresenter presenter) throws XPathException {
        throw new UnsupportedOperationException();
    }

    public void setDeclaredStreamable(boolean streamable) {
    }

    public boolean isDeclaredStreamable() {
        return false;
    }

    public void explainProperties(ExpressionPresenter presenter) throws XPathException {
        if (this.getRequiredContextItemType() != AnyItemType.getInstance()) {
            presenter.emitAttribute("cxt", this.getRequiredContextItemType().toString());
            if ("JS".equals(presenter.getOption("target"))) {
                int targetVersion = presenter.getIntOption("targetVersion", 1);
                presenter.emitAttribute("jsTest", this.getRequiredContextItemType().generateJavaScriptItemTypeTest(AnyItemType.getInstance(), targetVersion));
            }
        }
        String flags = "";
        if (!this.absentFocus) {
            flags = flags + "s";
        }
        presenter.emitAttribute("flags", flags);
        if (this.getRequiredType() != SequenceType.ANY_SEQUENCE) {
            presenter.emitAttribute("as", this.getRequiredType().toExportString());
        }
        presenter.emitAttribute("line", this.getLineNumber() + "");
        presenter.emitAttribute("module", this.getSystemId());
        if (this.isDeclaredStreamable()) {
            presenter.emitAttribute("streamable", "1");
        }
    }

    public Expression getInterpretedBody() {
        return this.body.getInterpretedExpression();
    }

    public TemplateRule copy() {
        TemplateRule tr = new TemplateRule();
        if (this.body == null || this.matchPattern == null) {
            this.slaveCopies.add(tr);
        } else {
            this.copyTo(tr);
        }
        return tr;
    }

    public void updateSlaveCopies() {
        for (TemplateRule tr : this.slaveCopies) {
            this.copyTo(tr);
        }
    }

    protected void copyTo(TemplateRule tr) {
        if (this.body != null) {
            tr.body = this.body.copy(new RebindingMap());
        }
        if (this.matchPattern != null) {
            tr.matchPattern = this.matchPattern.copy(new RebindingMap());
        }
        tr.hasRequiredParams = this.hasRequiredParams;
        tr.bodyIsTailCallReturner = this.bodyIsTailCallReturner;
        tr.requiredType = this.requiredType;
        tr.declaredStreamable = this.declaredStreamable;
        tr.requiredContextItemType = this.requiredContextItemType;
        tr.absentFocus = this.absentFocus;
        tr.stackFrameMap = this.stackFrameMap;
        tr.packageData = this.packageData;
        tr.systemId = this.systemId;
        tr.lineNumber = this.lineNumber;
    }

    @Override
    public void setChildExpression(Expression expr) {
        this.setBody(expr);
    }
}

