/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.DocumentInstr;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.InstructionWithComplexContent;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.ValidatingInstruction;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.functions.IriToUri;
import net.sf.saxon.lib.OutputURIResolver;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.SaxonOutputKeys;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.lib.StandardOutputResolver;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.DocumentURI;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.serialize.CharacterMapIndex;
import net.sf.saxon.serialize.ReconfigurableSerializer;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.style.XSLResultDocument;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Whitespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultDocument
extends Instruction
implements ValidatingInstruction,
InstructionWithComplexContent {
    private Operand hrefOp;
    private Operand formatOp;
    private Operand contentOp;
    private boolean async = false;
    protected Properties globalProperties;
    protected Properties localProperties;
    protected ParseOptions validationOptions;
    protected Map<StructuredQName, Operand> serializationAttributes;
    protected boolean resolveAgainstStaticBase = false;
    protected CharacterMapIndex characterMapIndex;

    public ResultDocument(Properties globalProperties, Properties localProperties, Expression href, Expression formatExpression, int validationAction, SchemaType schemaType, Map<StructuredQName, Expression> serializationAttributes, CharacterMapIndex characterMapIndex) {
        this.globalProperties = globalProperties;
        this.localProperties = localProperties;
        if (href != null) {
            this.hrefOp = new Operand(this, href, OperandRole.SINGLE_ATOMIC);
        }
        if (formatExpression != null) {
            this.formatOp = new Operand(this, formatExpression, OperandRole.SINGLE_ATOMIC);
        }
        this.setValidationAction(validationAction, schemaType);
        this.serializationAttributes = new HashMap<StructuredQName, Operand>(serializationAttributes.size());
        for (Map.Entry<StructuredQName, Expression> entry2 : serializationAttributes.entrySet()) {
            this.serializationAttributes.put(entry2.getKey(), new Operand(this, entry2.getValue(), OperandRole.SINGLE_ATOMIC));
        }
        this.characterMapIndex = characterMapIndex;
        for (Expression e : serializationAttributes.values()) {
            this.adoptChildExpression(e);
        }
    }

    public void setContentExpression(Expression content) {
        this.contentOp = new Operand(this, content, OperandRole.SINGLE_ATOMIC);
    }

    public void setSchemaType(SchemaType type) {
        if (this.validationOptions == null) {
            this.validationOptions = new ParseOptions();
        }
        this.validationOptions.setSchemaValidationMode(8);
        this.validationOptions.setTopLevelType(type);
    }

    @Override
    public SchemaType getSchemaType() {
        return this.validationOptions == null ? null : this.validationOptions.getTopLevelType();
    }

    public boolean isResolveAgainstStaticBase() {
        return this.resolveAgainstStaticBase;
    }

    public ParseOptions getValidationOptions() {
        return this.validationOptions;
    }

    public void setValidationAction(int mode, SchemaType schemaType) {
        boolean preservingTypes;
        boolean bl = preservingTypes = mode == 3 && schemaType == null;
        if (!preservingTypes && this.validationOptions == null) {
            this.validationOptions = new ParseOptions();
            this.validationOptions.setSchemaValidationMode(mode);
            this.validationOptions.setTopLevelType(schemaType);
        }
    }

    @Override
    public int getValidationAction() {
        return this.validationOptions == null ? 3 : this.validationOptions.getSchemaValidationMode();
    }

    public Expression getFormatExpression() {
        return this.formatOp == null ? null : this.formatOp.getChildExpression();
    }

    public void setUseStaticBaseUri(boolean staticBase) {
        this.resolveAgainstStaticBase = staticBase;
    }

    public void setAsynchronous(boolean async) {
        this.async = async;
    }

    public boolean isAsynchronous() {
        return this.async;
    }

    @Override
    public boolean isMultiThreaded(Configuration config) {
        return this.isAsynchronous() && config.isLicensedFeature(1) && config.getBooleanProperty("http://saxon.sf.net/feature/allow-multithreading");
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.typeCheckChildren(visitor, contextInfo);
        String method = this.getStaticSerializationProperty(XSLResultDocument.METHOD);
        boolean contentDependentMethod = method == null && this.formatOp == null && !this.serializationAttributes.containsKey(XSLResultDocument.METHOD);
        boolean buildTree = "yes".equals(this.getStaticSerializationProperty(XSLResultDocument.BUILD_TREE));
        if (buildTree || contentDependentMethod || "xml".equals(method) || "html".equals(method) || "xhtml".equals(method) || "text".equals(method)) {
            try {
                DocumentInstr.checkContentSequence(visitor.getStaticContext(), this.contentOp, this.validationOptions);
            }
            catch (XPathException err2) {
                err2.maybeSetLocation(this.getLocation());
                throw err2;
            }
        }
        return this;
    }

    @Override
    public int getIntrinsicDependencies() {
        return 0x1000000;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.optimizeChildren(visitor, contextInfo);
        if (this.isAsynchronous()) {
            for (Expression e = this.getParentExpression(); e != null; e = e.getParentExpression()) {
                if (!(e instanceof LetExpression) || !ExpressionTool.dependsOnVariable(this.getContentExpression(), new Binding[]{(LetExpression)e})) continue;
                ((LetExpression)e).setNeedsEagerEvaluation(true);
            }
        }
        return this;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        HashMap<StructuredQName, Expression> map2 = new HashMap<StructuredQName, Expression>();
        for (Map.Entry<StructuredQName, Operand> entry2 : this.serializationAttributes.entrySet()) {
            map2.put(entry2.getKey(), entry2.getValue().getChildExpression());
        }
        ResultDocument r = new ResultDocument(this.globalProperties, this.localProperties, this.getHref() == null ? null : this.getHref().copy(rebindings), this.getFormatExpression() == null ? null : this.getFormatExpression().copy(rebindings), this.getValidationAction(), this.getSchemaType(), map2, this.characterMapIndex);
        ExpressionTool.copyLocationInfo(this, r);
        r.setContentExpression(this.getContentExpression().copy(rebindings));
        r.resolveAgainstStaticBase = this.resolveAgainstStaticBase;
        r.async = this.async;
        return r;
    }

    @Override
    public int getInstructionNameCode() {
        return 193;
    }

    @Override
    public ItemType getItemType() {
        return ErrorType.getInstance();
    }

    @Override
    public Iterable<Operand> operands() {
        ArrayList<Operand> list2 = new ArrayList<Operand>(6);
        list2.add(this.contentOp);
        if (this.hrefOp != null) {
            list2.add(this.hrefOp);
        }
        if (this.formatOp != null) {
            list2.add(this.formatOp);
        }
        for (Operand e : this.serializationAttributes.values()) {
            list2.add(e);
        }
        return list2;
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet result2 = super.addToPathMap(pathMap, pathMapNodeSet);
        result2.setReturnable(false);
        return new PathMap.PathMapNodeSet(pathMap.makeNewRoot(this));
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        this.process(this.getContentExpression(), context);
        return null;
    }

    public void process(Expression content, XPathContext context) throws XPathException {
        if (context.getTemporaryOutputState() != 0) {
            XPathException err2 = new XPathException("Cannot execute xsl:result-document while evaluating xsl:" + context.getNamePool().getLocalName(context.getTemporaryOutputState()));
            err2.setErrorCode("XTDE1480");
            err2.setLocation(this.getLocation());
            throw err2;
        }
        context.getConfiguration().processResultDocument(this, content, context);
    }

    public void processInstruction(Expression content, XPathContext context) throws XPathException {
        Receiver out;
        Controller controller = context.getController();
        assert (controller != null);
        SequenceReceiver saved = context.getReceiver();
        String savedOutputUri = context.getCurrentOutputUri();
        if (context.getTemporaryOutputState() != 0) {
            XPathException err2 = new XPathException("Cannot execute xsl:result-document while evaluating xsl:" + context.getNamePool().getLocalName(context.getTemporaryOutputState()));
            err2.setErrorCode("XTDE1480");
            err2.setLocation(this.getLocation());
            throw err2;
        }
        Properties computedLocalProps = this.gatherOutputProperties(context);
        if (this.getStaticBaseURIString() != null) {
            computedLocalProps.setProperty("{http://saxon.sf.net/}parameter-document-base-uri", this.getStaticBaseURIString());
        }
        String nextInChain = computedLocalProps.getProperty("{http://saxon.sf.net/}next-in-chain");
        OutputURIResolver resolver = null;
        CloseableResult closeableResult = null;
        Result result2 = null;
        boolean buildTree = SaxonOutputKeys.isBuildTree(computedLocalProps);
        if (this.getHref() == null) {
            if (!computedLocalProps.propertyNames().hasMoreElements()) {
                out = controller.getPrincipalResult();
            } else if (controller.getPrincipalResult() instanceof ReconfigurableSerializer) {
                ReconfigurableSerializer rs = (ReconfigurableSerializer)controller.getPrincipalResult();
                rs.reconfigure(computedLocalProps, this.characterMapIndex);
                out = rs;
            } else {
                out = controller.getPrincipalResult();
            }
            String resultURI = controller.getBaseOutputURI();
            if (resultURI == null) {
                resultURI = "dummy:/anonymous/principal/result";
            }
            ResultDocument.checkAcceptableUri(context, resultURI);
            if (buildTree) {
                out = ComplexContentOutputter.makeComplexContentReceiver(out, this.getValidationOptions());
            }
            context.setReceiver((SequenceReceiver)out);
            context.setCurrentOutputUri(resultURI);
        } else {
            resolver = controller.getOutputURIResolver().newInstance();
            try {
                closeableResult = ResultDocument.getResult(this.getHref(), this.getStaticBaseURIString(), context, resolver, this.resolveAgainstStaticBase);
                result2 = closeableResult.result;
            }
            catch (XPathException e) {
                e.maybeSetLocation(this.getLocation());
                throw e;
            }
            SerializerFactory sf = context.getConfiguration().getSerializerFactory();
            PipelineConfiguration pipe = controller.makePipelineConfiguration();
            pipe.setLocationIsCodeLocation(true);
            pipe.setHostLanguage(50);
            out = sf.getReceiver(result2, pipe, computedLocalProps, this.characterMapIndex);
            if (buildTree) {
                out = ComplexContentOutputter.makeComplexContentReceiver(out, this.getValidationOptions());
            }
            context.setReceiver((SequenceReceiver)out);
            context.setCurrentOutputUri(result2.getSystemId());
        }
        out.open();
        try {
            if (buildTree) {
                out.startDocument(0);
                content.process(context);
                out.endDocument();
            } else {
                content.process(context);
            }
        }
        catch (XPathException err3) {
            err3.setXPathContext(context);
            err3.maybeSetLocation(this.getLocation());
            throw err3;
        }
        finally {
            out.close();
        }
        context.setReceiver(saved);
        context.setCurrentOutputUri(savedOutputUri);
        if (closeableResult != null) {
            try {
                closeableResult.close();
            }
            catch (TransformerException e) {
                throw XPathException.makeXPathException(e);
            }
        }
    }

    public static CloseableResult getResult(Expression href, String baseURI, XPathContext context, OutputURIResolver resolver, boolean resolveAgainstStaticBase) throws XPathException {
        CloseableResult closeable;
        String resultURI;
        Result result2;
        block14: {
            boolean resultFromResolver = false;
            Controller controller = context.getController();
            if (href == null) {
                result2 = controller.getPrincipalResult();
                resultURI = controller.getBaseOutputURI();
                if (resultURI == null) {
                    resultURI = "dummy:/anonymous/principal/result";
                }
                closeable = new CloseableResult();
                closeable.result = result2;
            } else {
                try {
                    String base = resolveAgainstStaticBase ? baseURI : controller.getCookedBaseOutputURI();
                    String hrefValue = IriToUri.iriToUri(href.evaluateAsString(context)).toString();
                    if (hrefValue.equals("")) {
                        result2 = controller.getPrincipalResult();
                        resultURI = controller.getBaseOutputURI();
                        if (resultURI == null) {
                            resultURI = "dummy:/anonymous/principal/result";
                        }
                        closeable = new CloseableResult();
                        closeable.result = result2;
                        break block14;
                    }
                    try {
                        result2 = resolver == null ? null : resolver.resolve(hrefValue, base);
                    }
                    catch (TransformerException err2) {
                        throw XPathException.makeXPathException(err2);
                    }
                    catch (Exception err3) {
                        err3.printStackTrace();
                        throw new XPathException("Exception thrown by OutputURIResolver", err3);
                    }
                    if (result2 == null) {
                        resolver = StandardOutputResolver.getInstance();
                        result2 = resolver.resolve(hrefValue, base);
                    }
                    final OutputURIResolver finalResolver = resolver;
                    closeable = new CloseableResult(){

                        public void close() throws TransformerException {
                            finalResolver.close(this.result);
                        }
                    };
                    closeable.result = result2;
                    resultURI = result2.getSystemId();
                    if (resultURI == null) {
                        try {
                            resultURI = new URI(base).resolve(hrefValue).toString();
                            result2.setSystemId(resultURI);
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (TransformerException e) {
                    throw XPathException.makeXPathException(e);
                }
            }
        }
        ResultDocument.checkAcceptableUri(context, resultURI);
        ResultDocument.traceDestination(context, result2);
        return closeable;
    }

    public static void traceDestination(XPathContext context, Result result2) {
        Configuration config = context.getConfiguration();
        boolean timing = config.isTiming();
        if (timing) {
            String dest = result2.getSystemId();
            if (dest == null) {
                dest = result2 instanceof StreamResult ? "anonymous output stream" : (result2 instanceof SAXResult ? "SAX2 ContentHandler" : (result2 instanceof DOMResult ? "DOM tree" : result2.getClass().getName()));
            }
            config.getStandardErrorOutput().println("Writing to " + dest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkAcceptableUri(XPathContext context, String uri) throws XPathException {
        Controller controller = context.getController();
        assert (controller != null);
        if (uri != null) {
            if (controller.getDocumentPool().find(uri) != null) {
                XPathException err2 = new XPathException("Cannot write to a URI that has already been read: " + (uri.equals("dummy:/anonymous/principal/result") ? "(implicit output URI)" : uri));
                err2.setXPathContext(context);
                err2.setErrorCode("XTDE1500");
                throw err2;
            }
            DocumentURI documentKey = new DocumentURI(uri);
            Controller controller2 = controller;
            synchronized (controller2) {
                if (!controller.checkUniqueOutputDestination(documentKey)) {
                    XPathException err3 = new XPathException("Cannot write more than one result document to the same URI: " + (uri.equals("dummy:/anonymous/principal/result") ? "(implicit output URI)" : uri));
                    err3.setXPathContext(context);
                    err3.setErrorCode("XTDE1490");
                    throw err3;
                }
                controller.addUnavailableOutputDestination(documentKey);
            }
        }
        controller.setThereHasBeenAnExplicitResultDocument();
    }

    public Properties gatherOutputProperties(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        assert (controller != null);
        Configuration config = context.getConfiguration();
        Properties computedGlobalProps = this.globalProperties;
        RetainedStaticContext nsResolver = this.getRetainedStaticContext();
        if (this.getFormatExpression() != null) {
            String[] parts;
            CharSequence format2 = this.getFormatExpression().evaluateAsString(context);
            try {
                parts = NameChecker.getQNameParts(format2);
            }
            catch (QNameException qNameException) {
                XPathException err2 = new XPathException("The requested output format " + Err.wrap(format2) + " is not a valid QName");
                err2.maybeSetLocation(this.getFormatExpression().getLocation());
                err2.setErrorCode("XTDE1460");
                err2.setXPathContext(context);
                throw err2;
            }
            String string2 = nsResolver.getURIForPrefix(parts[0], false);
            if (string2 == null) {
                XPathException err3 = new XPathException("The namespace prefix in the format name " + format2 + " is undeclared");
                err3.maybeSetLocation(this.getFormatExpression().getLocation());
                err3.setErrorCode("XTDE1460");
                err3.setXPathContext(context);
                throw err3;
            }
            StructuredQName qName = new StructuredQName(parts[0], string2, parts[1]);
            computedGlobalProps = ((StylesheetPackage)this.getRetainedStaticContext().getPackageData()).getNamedOutputProperties(qName);
            if (computedGlobalProps == null) {
                XPathException err4 = new XPathException("There is no xsl:output format named " + format2);
                err4.setErrorCode("XTDE1460");
                err4.setXPathContext(context);
                throw err4;
            }
        }
        Properties computedLocalProps = new Properties(computedGlobalProps);
        for (Object object : this.localProperties.keySet()) {
            String key = (String)object;
            StructuredQName qName = StructuredQName.fromClarkName(key);
            try {
                ResultDocument.setSerializationProperty(computedLocalProps, qName.getURI(), qName.getLocalPart(), this.localProperties.getProperty(key), nsResolver, true, config);
            }
            catch (XPathException e) {
                e.setErrorCode("XTDE0030");
                e.maybeSetLocation(this.getLocation());
                throw e;
            }
        }
        if (this.serializationAttributes.size() > 0) {
            for (Map.Entry entry2 : this.serializationAttributes.entrySet()) {
                String value2 = ((Operand)entry2.getValue()).getChildExpression().evaluateAsString(context).toString();
                String lname = ((StructuredQName)entry2.getKey()).getLocalPart();
                String uri = ((StructuredQName)entry2.getKey()).getURI();
                try {
                    ResultDocument.setSerializationProperty(computedLocalProps, uri, lname, value2, nsResolver, false, config);
                }
                catch (XPathException e) {
                    e.setErrorCode("XTDE0030");
                    e.maybeSetLocation(this.getLocation());
                    e.maybeSetContext(context);
                    if ("http://saxon.sf.net/".equals(e.getErrorCodeNamespace()) && "SXWN".equals(e.getErrorCodeLocalPart().substring(0, 4))) {
                        controller.getErrorListener().warning(e);
                        continue;
                    }
                    throw e;
                }
            }
        }
        return computedLocalProps;
    }

    public String getStaticSerializationProperty(StructuredQName name) {
        String clarkName = name.getClarkName();
        String local = this.localProperties.getProperty(clarkName);
        if (local != null) {
            return local;
        }
        if (this.serializationAttributes.containsKey(name)) {
            return null;
        }
        return this.globalProperties.getProperty(clarkName);
    }

    public static void setSerializationProperty(Properties details, String uri, String lname, String value2, NamespaceResolver nsResolver, boolean prevalidated, Configuration config) throws XPathException {
        SerializerFactory sf = config.getSerializerFactory();
        if (uri.isEmpty() || "http://saxon.sf.net/".equals(uri)) {
            if (lname.equals("method")) {
                if ((value2 = Whitespace.trim(value2)).startsWith("Q{}") && value2.length() > 3) {
                    value2 = value2.substring(3);
                }
                if (value2.equals("xml") || value2.equals("html") || value2.equals("text") || value2.equals("xhtml") || value2.equals("json") || value2.equals("adaptive") || prevalidated || value2.startsWith("{")) {
                    details.setProperty("method", value2);
                } else if (value2.startsWith("Q{")) {
                    details.setProperty("method", value2.substring(1));
                } else {
                    try {
                        String[] parts = NameChecker.getQNameParts(value2);
                        String prefix = parts[0];
                        if (prefix.isEmpty()) {
                            XPathException err2 = new XPathException("method must be xml, html, xhtml, text, json, adaptive, or a prefixed name");
                            err2.setErrorCode("SEPM0016");
                            err2.setIsStaticError(true);
                            throw err2;
                        }
                        if (nsResolver != null) {
                            String muri = nsResolver.getURIForPrefix(prefix, false);
                            if (muri == null) {
                                XPathException err3 = new XPathException("Namespace prefix '" + prefix + "' has not been declared");
                                err3.setErrorCode("SEPM0016");
                                err3.setIsStaticError(true);
                                throw err3;
                            }
                            details.setProperty("method", '{' + muri + '}' + parts[1]);
                        }
                        details.setProperty("method", value2);
                    }
                    catch (QNameException e) {
                        XPathException err4 = new XPathException("Invalid method name. " + e.getMessage());
                        err4.setErrorCode("SEPM0016");
                        err4.setIsStaticError(true);
                        throw err4;
                    }
                }
            } else if (lname.equals("use-character-maps")) {
                String existing = details.getProperty("use-character-maps");
                if (existing == null) {
                    existing = "";
                }
                details.setProperty("use-character-maps", existing + value2);
            } else if (lname.equals("cdata-section-elements")) {
                ResultDocument.processListOfNodeNames(details, "cdata-section-elements", value2, nsResolver, true, prevalidated);
            } else if (lname.equals("suppress-indentation")) {
                ResultDocument.processListOfNodeNames(details, "suppress-indentation", value2, nsResolver, true, prevalidated);
            } else if (lname.equals("double-space")) {
                ResultDocument.processListOfNodeNames(details, "{http://saxon.sf.net/}double-space", value2, nsResolver, true, prevalidated);
            } else if (lname.equals("attribute-order")) {
                ResultDocument.processListOfNodeNames(details, "{http://saxon.sf.net/}attribute-order", value2, nsResolver, false, prevalidated);
            } else if (!lname.equals("next-in-chain")) {
                if (lname.equals("output-version")) {
                    lname = "version";
                }
                String clarkName = lname;
                if (uri.length() != 0) {
                    clarkName = '{' + uri + '}' + lname;
                }
                if (!prevalidated) {
                    try {
                        if (!"item-separator".equals(clarkName)) {
                            value2 = Whitespace.trim(value2);
                        }
                        value2 = sf.checkOutputProperty(clarkName, value2);
                    }
                    catch (XPathException err5) {
                        err5.maybeSetErrorCode("SEPM0016");
                        throw err5;
                    }
                }
                details.setProperty(clarkName, value2);
            }
        } else {
            details.setProperty('{' + uri + '}' + lname, value2);
        }
    }

    private static void processListOfNodeNames(Properties details, String key, String value2, NamespaceResolver nsResolver, boolean useDefaultNS, boolean prevalidated) throws XPathException {
        String existing = details.getProperty(key);
        if (existing == null) {
            existing = "";
        }
        String s2 = SaxonOutputKeys.parseListOfNodeNames(value2, nsResolver, useDefaultNS, prevalidated, "SEPM0016");
        details.setProperty(key, existing + s2);
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        SchemaType schemaType;
        out.startElement("resultDoc", this);
        out.emitAttribute("global", this.exportProperties(this.globalProperties));
        out.emitAttribute("local", this.exportProperties(this.localProperties));
        if (this.getValidationAction() != 4 && this.getValidationAction() != 8) {
            out.emitAttribute("validation", Validation.toString(this.getValidationAction()));
        }
        if ((schemaType = this.getSchemaType()) != null) {
            out.emitAttribute("type", schemaType.getEQName());
        }
        if (this.getHref() != null) {
            out.setChildRole("href");
            this.getHref().export(out);
        }
        if (this.getFormatExpression() != null) {
            out.setChildRole("format");
            this.getFormatExpression().export(out);
        }
        for (Map.Entry<StructuredQName, Operand> p : this.serializationAttributes.entrySet()) {
            StructuredQName name = p.getKey();
            Expression value2 = p.getValue().getChildExpression();
            out.setChildRole(name.getEQName());
            value2.export(out);
        }
        out.setChildRole("content");
        this.getContentExpression().export(out);
        out.endElement();
    }

    private String exportProperties(Properties props) {
        try {
            StringWriter writer = new StringWriter();
            props.store(writer, "");
            return writer.toString();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void processXslOutputElement(NodeInfo element, Properties props, XPathContext c) throws XPathException {
        NodeInfo att;
        AxisIterator iter2 = element.iterateAxis((byte)2);
        InscopeNamespaceResolver resolver = new InscopeNamespaceResolver(element);
        while ((att = (NodeInfo)iter2.next()) != null) {
            String uri = att.getURI();
            String local = att.getLocalPart();
            String val = Whitespace.trim(att.getStringValueCS());
            ResultDocument.setSerializationProperty(props, uri, local, val, resolver, false, c.getConfiguration());
        }
    }

    @Override
    public String getStreamerName() {
        return "ResultDocument";
    }

    public Expression getHref() {
        return this.hrefOp == null ? null : this.hrefOp.getChildExpression();
    }

    public void setHref(Expression href) {
        this.hrefOp.setChildExpression(href);
    }

    public void setFormatExpression(Expression formatExpression) {
        this.formatOp.setChildExpression(formatExpression);
    }

    @Override
    public Expression getContentExpression() {
        return this.contentOp.getChildExpression();
    }

    public static class CloseableResult {
        public Result result;

        public void close() throws TransformerException {
        }
    }
}

