/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.ContextOriginator;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.Actor;
import net.sf.saxon.expr.instruct.Bindery;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.Declaration;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionLibrary;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.SingletonClosure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalVariable
extends Actor
implements Binding,
Declaration,
InstructionInfo,
ContextOriginator {
    protected List<BindingReference> references = new ArrayList<BindingReference>(10);
    private Expression select;
    private StructuredQName variableQName;
    private SequenceType requiredType;
    private boolean indexed;
    private boolean isPrivate = false;
    private boolean isAssignable = false;
    private GlobalVariable originalVariable;
    private int binderySlotNumber;
    private boolean isRequiredParam;

    public void init(Expression select, StructuredQName qName) {
        this.select = select;
        this.variableQName = qName;
        this.setBody(select);
    }

    @Override
    public SymbolicName getSymbolicName() {
        return new SymbolicName(206, this.variableQName);
    }

    public void setSelectExpression(Expression select) {
        this.select = select;
        this.setBody(select);
    }

    public Expression getSelectExpression() {
        return this.select;
    }

    public void setRequiredType(SequenceType required) {
        this.requiredType = required;
    }

    @Override
    public SequenceType getRequiredType() {
        return this.requiredType;
    }

    private Configuration getConfiguration() {
        return this.getPackageData().getConfiguration();
    }

    public void setOriginalVariable(GlobalVariable var) {
        this.originalVariable = var;
    }

    public GlobalVariable getOriginalVariable() {
        return this.originalVariable;
    }

    public GlobalVariable getUltimateOriginalVariable() {
        if (this.originalVariable == null) {
            return this;
        }
        return this.originalVariable.getUltimateOriginalVariable();
    }

    public void setUnused(boolean unused) {
        this.binderySlotNumber = -9234;
    }

    public boolean isUnused() {
        return this.binderySlotNumber == -9234;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public void setPrivate(boolean b) {
        this.isPrivate = b;
    }

    public void setAssignable(boolean assignable) {
        this.isAssignable = assignable;
    }

    @Override
    public final boolean isAssignable() {
        return this.isAssignable;
    }

    @Override
    public int getConstructType() {
        return 206;
    }

    @Override
    public StructuredQName getObjectName() {
        return this.getVariableQName();
    }

    @Override
    public Object getProperty(String name) {
        return null;
    }

    @Override
    public Iterator<String> getProperties() {
        List list2 = Collections.emptyList();
        return list2.iterator();
    }

    public int getHostLanguage() {
        return this.getPackageData().getHostLanguage();
    }

    public void setIndexedVariable() {
        this.indexed = true;
    }

    public boolean isIndexedVariable() {
        return this.indexed;
    }

    public void setContainsLocals(SlotManager map2) {
        this.setStackFrameMap(map2);
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    public void registerReference(BindingReference ref) {
        this.references.add(ref);
    }

    public Iterator iterateReferences() {
        return this.references.iterator();
    }

    public int getBinderySlotNumber() {
        return this.binderySlotNumber;
    }

    public void setBinderySlotNumber(int s2) {
        if (!this.isUnused()) {
            this.binderySlotNumber = s2;
        }
    }

    public void setRequiredParam(boolean requiredParam) {
        this.isRequiredParam = requiredParam;
    }

    public boolean isRequiredParam() {
        return this.isRequiredParam;
    }

    public void compile(Executable exec, int slot) throws XPathException {
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        this.setBinderySlotNumber(slot);
        if (this instanceof GlobalParam) {
            this.setRequiredParam(this.select == null);
        }
        SequenceType type = this.getRequiredType();
        for (BindingReference ref : this.references) {
            int relation;
            ref.fixup(this);
            GroundedValue constantValue = null;
            int properties = 0;
            Expression select = this.getSelectExpression();
            if (select instanceof Literal && !(this instanceof GlobalParam) && ((relation = th.relationship(select.getItemType(), type.getPrimaryType())) == 0 || relation == 2)) {
                constantValue = ((Literal)select).getValue();
                type = SequenceType.makeSequenceType(SequenceTool.getItemType(constantValue, th), SequenceTool.getCardinality(constantValue));
            }
            if (select != null) {
                properties = select.getSpecialProperties();
            }
            ref.setStaticType(type, constantValue, properties |= 0x400000);
        }
        if (this.isRequiredParam()) {
            exec.registerGlobalParameter((GlobalParam)this);
        }
    }

    public void typeCheck(ExpressionVisitor visitor) throws XPathException {
        Expression value2 = this.getSelectExpression();
        if (value2 != null) {
            value2.checkForUpdatingSubexpressions();
            if (value2.isUpdatingExpression()) {
                throw new XPathException("Initializing expression for global variable must not be an updating expression", "XUST0001");
            }
            RoleDiagnostic role = new RoleDiagnostic(3, this.getVariableQName().getDisplayName(), 0);
            ContextItemStaticInfo cit = this.getConfiguration().makeContextItemStaticInfo(AnyItemType.getInstance(), true);
            Expression value22 = TypeChecker.strictTypeCheck(value2.simplify().typeCheck(visitor, cit), this.getRequiredType(), role, visitor.getStaticContext());
            value22 = value22.optimize(visitor, cit);
            this.setSelectExpression(value22);
            SlotManager map2 = this.getConfiguration().makeSlotManager();
            int slots = ExpressionTool.allocateSlots(value22, 0, map2);
            if (slots > 0) {
                this.setContainsLocals(map2);
            }
            if (this.getRequiredType() == SequenceType.ANY_SEQUENCE && !(this instanceof GlobalParam)) {
                try {
                    ItemType itemType = value2.getItemType();
                    int cardinality = value2.getCardinality();
                    this.setRequiredType(SequenceType.makeSequenceType(itemType, cardinality));
                    GroundedValue constantValue = null;
                    if (value22 instanceof Literal) {
                        constantValue = ((Literal)value22).getValue();
                    }
                    for (BindingReference reference : this.references) {
                        if (!(reference instanceof VariableReference)) continue;
                        ((VariableReference)reference).refineVariableType(itemType, cardinality, constantValue, value2.getSpecialProperties());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void lookForCycles(Stack<Object> referees, XQueryFunctionLibrary globalFunctionLibrary) throws XPathException {
        if (referees.contains(this)) {
            int s2 = referees.indexOf(this);
            referees.push(this);
            String message = "Circular definition of global variable: $" + this.getVariableQName().getDisplayName();
            for (int i = s2; i < referees.size() - 1; ++i) {
                InstructionInfo next2;
                if (i != s2) {
                    message = message + ", which";
                }
                if (referees.get(i + 1) instanceof GlobalVariable) {
                    next2 = (GlobalVariable)referees.get(i + 1);
                    message = message + " uses $" + ((GlobalVariable)next2).getVariableQName().getDisplayName();
                    continue;
                }
                if (!(referees.get(i + 1) instanceof XQueryFunction)) continue;
                next2 = (XQueryFunction)referees.get(i + 1);
                message = message + " calls " + ((XQueryFunction)next2).getFunctionName().getDisplayName() + "#" + ((XQueryFunction)next2).getNumberOfArguments() + "()";
            }
            message = message + '.';
            XPathException err2 = new XPathException(message);
            String errorCode = this.getPackageData().getHostLanguage() == 50 ? "XTDE0640" : "XQDY0054";
            err2.setErrorCode(errorCode);
            err2.setIsStaticError(true);
            err2.setLocation(this.getLocation());
            throw err2;
        }
        if (this.select != null) {
            referees.push(this);
            ArrayList<Binding> list2 = new ArrayList<Binding>(10);
            ExpressionTool.gatherReferencedVariables(this.select, list2);
            for (Binding b : list2) {
                if (!(b instanceof GlobalVariable)) continue;
                ((GlobalVariable)b).lookForCycles(referees, globalFunctionLibrary);
            }
            ArrayList<SymbolicName> flist = new ArrayList<SymbolicName>();
            ExpressionTool.gatherCalledFunctionNames(this.select, flist);
            for (SymbolicName s3 : flist) {
                XQueryFunction f = globalFunctionLibrary.getDeclarationByKey(s3);
                if (referees.contains(f)) continue;
                GlobalVariable.lookForFunctionCycles(f, referees, globalFunctionLibrary);
            }
            referees.pop();
        }
    }

    private static void lookForFunctionCycles(XQueryFunction f, Stack<Object> referees, XQueryFunctionLibrary globalFunctionLibrary) throws XPathException {
        Expression body = f.getBody();
        referees.push(f);
        ArrayList<Binding> list2 = new ArrayList<Binding>(10);
        ExpressionTool.gatherReferencedVariables(body, list2);
        for (Binding b : list2) {
            if (!(b instanceof GlobalVariable)) continue;
            ((GlobalVariable)b).lookForCycles(referees, globalFunctionLibrary);
        }
        ArrayList<SymbolicName> flist = new ArrayList<SymbolicName>();
        ExpressionTool.gatherCalledFunctionNames(body, flist);
        for (SymbolicName s2 : flist) {
            XQueryFunction qf = globalFunctionLibrary.getDeclarationByKey(s2);
            if (referees.contains(qf)) continue;
            GlobalVariable.lookForFunctionCycles(qf, referees, globalFunctionLibrary);
        }
        referees.pop();
    }

    public Sequence getSelectValue(XPathContext context, Component target) throws XPathException {
        if (this.select == null) {
            throw new AssertionError((Object)("*** No select expression for global variable $" + this.getVariableQName().getDisplayName() + "!!"));
        }
        if (this.select instanceof Literal) {
            return ((Literal)this.select).getValue();
        }
        try {
            XPathContextMajor c2 = context.newCleanContext();
            c2.setOrigin(this);
            if (target == null || target.getDeclaringPackage().isRootPackage()) {
                ManualIterator mi = new ManualIterator(context.getController().getGlobalContextItem());
                c2.setCurrentIterator(mi);
            } else {
                c2.setCurrentIterator(null);
            }
            if (this.getStackFrameMap() != null) {
                c2.openStackFrame(this.getStackFrameMap());
            }
            c2.setCurrentComponent(target);
            int savedOutputState = c2.getTemporaryOutputState();
            c2.setTemporaryOutputState(206);
            c2.setCurrentOutputUri(null);
            Sequence result2 = this.indexed ? c2.getConfiguration().makeSequenceExtent(this.select, 10000, c2) : SequenceExtent.makeSequenceExtent(this.select.iterate(c2));
            c2.setTemporaryOutputState(savedOutputState);
            return result2;
        }
        catch (XPathException e) {
            if (!this.getVariableQName().hasURI("http://saxon.sf.net/generated-variable")) {
                e.setIsGlobalError(true);
            }
            throw e;
        }
    }

    @Override
    public Sequence evaluateVariable(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        assert (controller != null);
        Bindery b = controller.getBindery(this.getPackageData());
        Sequence v = b.getGlobalVariable(this.getBinderySlotNumber());
        if (v != null) {
            return v;
        }
        return this.actuallyEvaluate(context, null);
    }

    public Sequence evaluateVariable(XPathContext context, Component target) throws XPathException {
        Controller controller = context.getController();
        assert (controller != null);
        Bindery b = controller.getBindery(this.getPackageData());
        if (b == null) {
            throw new AssertionError();
        }
        Sequence v = b.getGlobalVariable(this.getBinderySlotNumber());
        if (v != null) {
            return v;
        }
        return this.actuallyEvaluate(context, target);
    }

    protected Sequence actuallyEvaluate(XPathContext context, Component target) throws XPathException {
        Controller controller = context.getController();
        assert (controller != null);
        Bindery b = controller.getBindery(this.getPackageData());
        try {
            GlobalVariable.setDependencies(this, context);
            boolean go = b.setExecuting(this);
            if (!go) {
                return b.getGlobalVariable(this.getBinderySlotNumber());
            }
            Sequence value2 = this.getSelectValue(context, target);
            if (this.indexed) {
                value2 = controller.getConfiguration().obtainOptimizer().makeIndexedValue(value2.iterate());
            }
            return b.saveGlobalVariableValue(this, value2);
        }
        catch (XPathException err2) {
            b.setNotExecuting(this);
            if (err2 instanceof XPathException.Circularity) {
                String errorCode = this.getPackageData().getHostLanguage() == 50 ? "XTDE0640" : "XQDY0054";
                err2.setErrorCode(errorCode);
                err2.setXPathContext(context);
                SingletonClosure closure = new SingletonClosure(new ErrorExpression(err2), context);
                b.setGlobalVariable(this, closure);
                err2.setLocation(this.getLocation());
                throw err2;
            }
            throw err2;
        }
    }

    protected static void setDependencies(GlobalVariable var, XPathContext context) throws XPathException {
        Controller controller = context.getController();
        if (!(context instanceof XPathContextMajor)) {
            context = GlobalVariable.getMajorCaller(context);
        }
        while (context != null) {
            do {
                ContextOriginator origin;
                if (!((origin = ((XPathContextMajor)context).getOrigin()) instanceof GlobalVariable)) continue;
                controller.registerGlobalVariableDependency((GlobalVariable)origin, var);
                return;
            } while ((context = GlobalVariable.getMajorCaller(context)) != null);
        }
    }

    private static XPathContextMajor getMajorCaller(XPathContext context) {
        XPathContext caller;
        for (caller = context.getCaller(); caller != null && !(caller instanceof XPathContextMajor); caller = caller.getCaller()) {
        }
        return (XPathContextMajor)caller;
    }

    @Override
    public IntegerValue[] getIntegerBoundsForVariable() {
        return this.select == null ? null : this.select.getIntegerBounds();
    }

    public int getLocalSlotNumber() {
        return 0;
    }

    public void setVariableQName(StructuredQName s2) {
        this.variableQName = s2;
    }

    @Override
    public StructuredQName getVariableQName() {
        return this.variableQName;
    }

    @Override
    public void addReference(VariableReference ref, boolean isLoopingReference) {
    }

    @Override
    public int getComponentKind() {
        return 206;
    }

    @Override
    public void export(ExpressionPresenter presenter) throws XPathException {
        String flags;
        Visibility vis;
        presenter.startElement(this instanceof GlobalParam ? "globalParam" : "globalVariable");
        presenter.emitAttribute("name", this.getVariableQName().getEQName());
        presenter.emitAttribute("type", this.getRequiredType().toExportString());
        presenter.emitAttribute("line", this.getLineNumber() + "");
        presenter.emitAttribute("module", this.getSystemId());
        if (this.getStackFrameMap() != null) {
            presenter.emitAttribute("slots", this.getStackFrameMap().getNumberOfVariables() + "");
        }
        if (this.getDeclaringComponent() != null && (vis = this.getDeclaringComponent().getVisibility()) != null) {
            presenter.emitAttribute("visibility", vis.toString());
        }
        if (!(flags = this.getFlags()).isEmpty()) {
            presenter.emitAttribute("flags", flags);
        }
        if ("JS".equals(presenter.getOption("target"))) {
            int targetVersion = presenter.getIntOption("targetVersion", 1);
            presenter.emitAttribute("jsAcceptor", this.getRequiredType().getPrimaryType().generateJavaScriptItemTypeAcceptor("XTTE0590", targetVersion));
            presenter.emitAttribute("jsCardCheck", Cardinality.generateJavaScriptChecker(this.getRequiredType().getCardinality()));
        }
        if (this.getSelectExpression() != null) {
            this.getSelectExpression().export(presenter);
        }
        presenter.endElement();
    }

    protected String getFlags() {
        String flags = "";
        if (this.isAssignable) {
            flags = flags + "a";
        }
        if (this.indexed) {
            flags = flags + "x";
        }
        if (this.isRequiredParam) {
            flags = flags + "r";
        }
        return flags;
    }
}

