/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.SimpleNodeConstructor;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

public final class Comment
extends SimpleNodeConstructor {
    public int getInstructionNameCode() {
        return 143;
    }

    public ItemType getItemType() {
        return NodeKindTest.COMMENT;
    }

    public int getCardinality() {
        return 16384;
    }

    public Expression copy(RebindingMap rebindings) {
        Comment exp = new Comment();
        ExpressionTool.copyLocationInfo(this, exp);
        exp.setSelect(this.getSelect().copy(rebindings));
        return exp;
    }

    public void localTypeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        String s2;
        String s22;
        if (this.getSelect() instanceof Literal && !(s22 = this.checkContent(s2 = ((Literal)this.getSelect()).getValue().getStringValue(), visitor.getStaticContext().makeEarlyEvaluationContext())).equals(s2)) {
            this.setSelect(new StringLiteral(s22));
        }
    }

    public void processValue(CharSequence value2, XPathContext context) throws XPathException {
        String comment2 = this.checkContent(value2.toString(), context);
        SequenceReceiver out = context.getReceiver();
        out.comment(comment2, this.getLocation(), 0);
    }

    protected String checkContent(String comment2, XPathContext context) throws XPathException {
        if (this.isXSLT()) {
            return Comment.checkContentXSLT(comment2);
        }
        try {
            return Comment.checkContentXQuery(comment2);
        }
        catch (XPathException err2) {
            err2.setXPathContext(context);
            err2.setLocation(this.getLocation());
            throw err2;
        }
    }

    public static String checkContentXSLT(String comment2) {
        int hh;
        while ((hh = comment2.indexOf("--")) >= 0) {
            comment2 = comment2.substring(0, hh + 1) + ' ' + comment2.substring(hh + 1);
        }
        if (comment2.length() > 0 && comment2.charAt(comment2.length() - 1) == '-') {
            comment2 = comment2 + ' ';
        }
        return comment2;
    }

    public static String checkContentXQuery(String comment2) throws XPathException {
        if (comment2.contains("--")) {
            throw new XPathException("Invalid characters (--) in comment", "XQDY0072");
        }
        if (comment2.length() > 0 && comment2.charAt(comment2.length() - 1) == '-') {
            throw new XPathException("Comment cannot end in '-'", "XQDY0072");
        }
        return comment2;
    }

    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("comment", this);
        String flags = "";
        if (this.isLocal()) {
            flags = flags + "l";
        }
        if (!flags.isEmpty()) {
            out.emitAttribute("flags", flags);
        }
        this.getSelect().export(out);
        out.endElement();
    }
}

