/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import java.util.Arrays;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.TailCallReturner;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.functions.BooleanFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Choose
extends Instruction {
    private Operand[] conditionOps;
    private Operand[] actionOps;
    private boolean isInstruction;
    private static final OperandRole CHOICE_ACTION = new OperandRole(8, OperandUsage.TRANSMISSION, SequenceType.ANY_SEQUENCE);

    public Choose(Expression[] conditions, Expression[] actions) {
        int i;
        this.conditionOps = new Operand[conditions.length];
        for (i = 0; i < conditions.length; ++i) {
            this.conditionOps[i] = new Operand(this, conditions[i], OperandRole.INSPECT);
        }
        this.actionOps = new Operand[actions.length];
        for (i = 0; i < actions.length; ++i) {
            this.actionOps[i] = new Operand(this, actions[i], CHOICE_ACTION);
        }
    }

    public static Expression makeConditional(Expression condition, Expression thenExp, Expression elseExp) {
        if (Literal.isEmptySequence(elseExp)) {
            Expression[] conditions = new Expression[]{condition};
            Expression[] actions = new Expression[]{thenExp};
            return new Choose(conditions, actions);
        }
        Expression[] conditions = new Expression[]{condition, Literal.makeLiteral(BooleanValue.TRUE)};
        Expression[] actions = new Expression[]{thenExp, elseExp};
        return new Choose(conditions, actions);
    }

    public static Expression makeConditional(Expression condition, Expression thenExp) {
        Expression[] conditions = new Expression[]{condition};
        Expression[] actions = new Expression[]{thenExp};
        return new Choose(conditions, actions);
    }

    public void setInstruction(boolean inst) {
        this.isInstruction = inst;
    }

    @Override
    public boolean isInstruction() {
        return this.isInstruction;
    }

    public int size() {
        return this.conditionOps.length;
    }

    public static boolean isSingleBranchChoice(Expression exp) {
        return exp instanceof Choose && ((Choose)exp).size() == 1;
    }

    public int getNumberOfConditions() {
        return this.size();
    }

    public Expression getCondition(int i) {
        return this.conditionOps[i].getChildExpression();
    }

    public void setCondition(int i, Expression condition) {
        this.conditionOps[i].setChildExpression(condition);
    }

    public Iterable<Operand> conditions() {
        return Arrays.asList(this.conditionOps);
    }

    public Operand getActionOperand(int i) {
        return this.actionOps[i];
    }

    public Expression getAction(int i) {
        return this.actionOps[i].getChildExpression();
    }

    public void setAction(int i, Expression action) {
        this.actionOps[i].setChildExpression(action);
    }

    public Iterable<Operand> actions() {
        return Arrays.asList(this.actionOps);
    }

    @Override
    public Iterable<Operand> operands() {
        ArrayList<Operand> operanda = new ArrayList<Operand>(this.size() * 2);
        for (int i = 0; i < this.size(); ++i) {
            operanda.add(this.conditionOps[i]);
            operanda.add(this.actionOps[i]);
        }
        return operanda;
    }

    @Override
    public boolean allowExtractingCommonSubexpressions() {
        return false;
    }

    public void atomizeActions() {
        for (int i = 0; i < this.size(); ++i) {
            this.setAction(i, Atomizer.makeAtomizer(this.getAction(i)));
        }
    }

    @Override
    public int getInstructionNameCode() {
        return this.size() == 1 ? 160 : 142;
    }

    @Override
    public Expression simplify() throws XPathException {
        for (int i = 0; i < this.size(); ++i) {
            this.setCondition(i, this.getCondition(i).simplify());
            try {
                this.setAction(i, this.getAction(i).simplify());
                continue;
            }
            catch (XPathException err2) {
                if (err2.isTypeError()) {
                    throw err2;
                }
                this.setAction(i, new ErrorExpression(err2));
            }
        }
        return this;
    }

    private Expression removeRedundantBranches(ExpressionVisitor visitor) {
        Expression result2 = this.removeRedundantBranches0(visitor);
        if (result2 != this) {
            ExpressionTool.copyLocationInfo(this, result2);
        }
        return result2;
    }

    private Expression removeRedundantBranches0(ExpressionVisitor visitor) {
        int i;
        Expression[] actions;
        Expression[] conditions;
        boolean compress = false;
        for (int i2 = 0; i2 < this.size(); ++i2) {
            Expression condition = this.getCondition(i2);
            if (!(condition instanceof Literal)) continue;
            compress = true;
            break;
        }
        int size2 = this.size();
        boolean changed = false;
        if (compress) {
            conditions = new ArrayList(size2);
            actions = new ArrayList(size2);
            for (i = 0; i < size2; ++i) {
                Expression condition = this.getCondition(i);
                if (!Literal.hasEffectiveBooleanValue(condition, false)) {
                    conditions.add(condition);
                    actions.add(this.getAction(i));
                }
                if (Literal.hasEffectiveBooleanValue(condition, true)) break;
            }
            if (conditions.isEmpty()) {
                Literal lit = Literal.makeEmptySequence();
                ExpressionTool.copyLocationInfo(this, lit);
                return lit;
            }
            if (conditions.size() == 1 && Literal.hasEffectiveBooleanValue((Expression)conditions.get(0), true)) {
                return (Expression)actions.get(0);
            }
            if (conditions.size() != size2) {
                Expression[] c = conditions.toArray(new Expression[conditions.size()]);
                Expression[] a = actions.toArray(new Expression[actions.size()]);
                Choose result2 = new Choose(c, a);
                result2.setRetainedStaticContext(this.getRetainedStaticContext());
                return result2;
            }
        }
        if (this.size() == 1 && Literal.hasEffectiveBooleanValue(this.getCondition(0), true)) {
            return this.getAction(0);
        }
        if (Literal.isEmptySequence(this.getAction(this.size() - 1))) {
            if (this.size() == 1) {
                Literal lit = Literal.makeEmptySequence();
                ExpressionTool.copyLocationInfo(this, lit);
                return lit;
            }
            conditions = new Expression[size2 - 1];
            actions = new Expression[size2 - 1];
            for (i = 0; i < size2 - 1; ++i) {
                conditions[i] = this.getCondition(i);
                actions[i] = this.getAction(i);
            }
            return new Choose(conditions, actions);
        }
        if (Literal.hasEffectiveBooleanValue(this.getCondition(size2 - 1), true) && this.getAction(size2 - 1) instanceof Choose) {
            int i3;
            Choose choose2 = (Choose)this.getAction(size2 - 1);
            int newLen = size2 + choose2.size() - 1;
            Expression[] c2 = new Expression[newLen];
            Expression[] a2 = new Expression[newLen];
            for (i3 = 0; i3 < size2 - 1; ++i3) {
                c2[i3] = this.getCondition(i3);
                a2[i3] = this.getAction(i3);
            }
            for (i3 = 0; i3 < choose2.size(); ++i3) {
                c2[i3 + size2 - 1] = choose2.getCondition(i3);
                a2[i3 + size2 - 1] = choose2.getAction(i3);
            }
            return new Choose(c2, a2);
        }
        if (size2 == 2 && Literal.isConstantBoolean(this.getAction(0), true) && Literal.isConstantBoolean(this.getAction(1), false) && Literal.hasEffectiveBooleanValue(this.getCondition(1), true)) {
            TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
            if (th.isSubType(this.getCondition(0).getItemType(), BuiltInAtomicType.BOOLEAN) && this.getCondition(0).getCardinality() == 16384) {
                return this.getCondition(0);
            }
            return SystemFunction.makeCall("boolean", this.getRetainedStaticContext(), this.getCondition(0));
        }
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        int i;
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        for (i = 0; i < this.size(); ++i) {
            this.conditionOps[i].typeCheck(visitor, contextInfo);
            XPathException err2 = TypeChecker.ebvError(this.getCondition(i), th);
            if (err2 == null) continue;
            err2.setLocator(this.getCondition(i).getLocation());
            throw err2;
        }
        for (i = 0; i < this.size(); ++i) {
            try {
                this.actionOps[i].typeCheck(visitor, contextInfo);
                continue;
            }
            catch (XPathException err3) {
                err3.maybeSetLocation(this.getLocation());
                if (err3.isStaticError()) {
                    throw err3;
                }
                if (err3.isTypeError()) {
                    if (Literal.isEmptySequence(this.getAction(i)) || Literal.hasEffectiveBooleanValue(this.getCondition(i), false)) {
                        this.setAction(i, new ErrorExpression(err3));
                        continue;
                    }
                    throw err3;
                }
                this.setAction(i, new ErrorExpression(err3));
            }
        }
        return this.removeRedundantBranches(visitor);
    }

    @Override
    public boolean implementsStaticTypeCheck() {
        return true;
    }

    @Override
    public Expression staticTypeCheck(SequenceType req, boolean backwardsCompatible, RoleDiagnostic role, ExpressionVisitor visitor) throws XPathException {
        int size2 = this.size();
        TypeChecker tc = this.getConfiguration().getTypeChecker(backwardsCompatible);
        for (int i = 0; i < size2; ++i) {
            try {
                this.setAction(i, tc.staticTypeCheck(this.getAction(i), req, role, visitor));
                continue;
            }
            catch (XPathException err2) {
                if (err2.isStaticError()) {
                    throw err2;
                }
                if (err2.isTypeError()) {
                    visitor.issueWarning("Branch " + (i + 1) + " of conditional will fail with a type error if executed. " + err2.getMessage(), this.getLocation());
                }
                ErrorExpression ee = new ErrorExpression(err2);
                ExpressionTool.copyLocationInfo(this.getAction(0), ee);
                this.setAction(i, ee);
            }
        }
        if (!Literal.hasEffectiveBooleanValue(this.getCondition(size2 - 1), true) && !Cardinality.allowsZero(req.getCardinality())) {
            Expression[] c = new Expression[size2 + 1];
            Expression[] a = new Expression[size2 + 1];
            for (int i = 0; i < size2; ++i) {
                c[i] = this.getCondition(i);
                a[i] = this.getAction(i);
            }
            c[size2] = Literal.makeLiteral(BooleanValue.TRUE);
            String cond = size2 == 1 ? "The condition is not" : "None of the conditions is";
            String message = "Conditional expression: " + cond + " satisfied, so an empty sequence is returned, " + "but this is not allowed as the " + role.getMessage();
            ErrorExpression errExp = new ErrorExpression(message, role.getErrorCode(), true);
            ExpressionTool.copyLocationInfo(this, errExp);
            a[size2] = errExp;
            return new Choose(c, a);
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        int i;
        int size2 = this.size();
        for (i = 0; i < size2; ++i) {
            boolean b;
            this.conditionOps[i].optimize(visitor, contextItemType);
            Expression ebv = BooleanFn.rewriteEffectiveBooleanValue(this.getCondition(i), visitor, contextItemType);
            if (ebv != null && ebv != this.getCondition(i)) {
                this.setCondition(i, ebv);
            }
            if (!(this.getCondition(i) instanceof Literal) || ((Literal)this.getCondition(i)).getValue() instanceof BooleanValue) continue;
            try {
                b = ((Literal)this.getCondition(i)).getValue().effectiveBooleanValue();
            }
            catch (XPathException err2) {
                err2.setLocation(this.getLocation());
                throw err2;
            }
            this.setCondition(i, Literal.makeLiteral(BooleanValue.get(b)));
        }
        for (i = 0; i < size2; ++i) {
            try {
                this.actionOps[i].optimize(visitor, contextItemType);
                continue;
            }
            catch (XPathException err3) {
                if (err3.isTypeError()) {
                    throw err3;
                }
                this.setAction(i, new ErrorExpression(err3));
            }
        }
        if (size2 == 0) {
            return Literal.makeEmptySequence();
        }
        Expression e = this.removeRedundantBranches(visitor);
        if (e instanceof Choose) {
            return visitor.getConfiguration().obtainOptimizer().trySwitch((Choose)e, visitor);
        }
        return e;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        int size2 = this.size();
        Expression[] c2 = new Expression[size2];
        Expression[] a2 = new Expression[size2];
        for (int c = 0; c < size2; ++c) {
            c2[c] = this.getCondition(c).copy(rebindings);
            a2[c] = this.getAction(c).copy(rebindings);
        }
        Choose ch2 = new Choose(c2, a2);
        ExpressionTool.copyLocationInfo(this, ch2);
        ch2.setInstruction(this.isInstruction());
        return ch2;
    }

    @Override
    public void checkForUpdatingSubexpressions() throws XPathException {
        for (Operand o : this.conditions()) {
            Expression condition = o.getChildExpression();
            condition.checkForUpdatingSubexpressions();
            if (!condition.isUpdatingExpression()) continue;
            XPathException err2 = new XPathException("Updating expression appears in a context where it is not permitted", "XUST0001");
            err2.setLocator(condition.getLocation());
            throw err2;
        }
        boolean updating = false;
        boolean nonUpdating = false;
        for (Operand o : this.actions()) {
            Expression act = o.getChildExpression();
            act.checkForUpdatingSubexpressions();
            if (!ExpressionTool.isAllowedInUpdatingContext(act)) {
                if (updating) {
                    XPathException err3 = new XPathException("If any branch of a conditional is an updating expression, then all must be updating expressions (or vacuous)", "XUST0001");
                    err3.setLocator(act.getLocation());
                    throw err3;
                }
                nonUpdating = true;
            }
            if (!act.isUpdatingExpression()) continue;
            if (nonUpdating) {
                XPathException err4 = new XPathException("If any branch of a conditional is an updating expression, then all must be updating expressions (or vacuous)", "XUST0001");
                err4.setLocator(act.getLocation());
                throw err4;
            }
            updating = true;
        }
    }

    @Override
    public boolean isUpdatingExpression() {
        for (Operand o : this.actions()) {
            if (!o.getChildExpression().isUpdatingExpression()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isVacuousExpression() {
        for (Operand action : this.actions()) {
            if (action.getChildExpression().isVacuousExpression()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getImplementationMethod() {
        int m = 14;
        if (!Cardinality.allowsMany(this.getCardinality())) {
            m |= 1;
        }
        return m;
    }

    @Override
    public int markTailFunctionCalls(StructuredQName qName, int arity) {
        int result2 = 0;
        for (Operand action : this.actions()) {
            result2 = Math.max(result2, action.getChildExpression().markTailFunctionCalls(qName, arity));
        }
        return result2;
    }

    @Override
    public ItemType getItemType() {
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        ItemType type = this.getAction(0).getItemType();
        for (int i = 1; i < this.size(); ++i) {
            type = Type.getCommonSuperType(type, this.getAction(i).getItemType(), th);
        }
        return type;
    }

    @Override
    public UType getStaticUType(UType contextItemType) {
        if (this.isInstruction()) {
            return super.getStaticUType(contextItemType);
        }
        UType type = this.getAction(0).getStaticUType(contextItemType);
        for (int i = 1; i < this.size(); ++i) {
            type = type.union(this.getAction(i).getStaticUType(contextItemType));
        }
        return type;
    }

    @Override
    public int computeCardinality() {
        int card = 0;
        boolean includesTrue = false;
        for (int i = 0; i < this.size(); ++i) {
            card = Cardinality.union(card, this.getAction(i).getCardinality());
            if (!Literal.hasEffectiveBooleanValue(this.getCondition(i), true)) continue;
            includesTrue = true;
        }
        if (!includesTrue) {
            card = Cardinality.union(card, 8192);
        }
        return card;
    }

    @Override
    public int computeSpecialProperties() {
        int props = this.getAction(0).getSpecialProperties();
        for (int i = 1; i < this.size(); ++i) {
            props &= this.getAction(i).getSpecialProperties();
        }
        return props;
    }

    @Override
    public final boolean mayCreateNewNodes() {
        for (Operand action : this.actions()) {
            int props = action.getChildExpression().getSpecialProperties();
            if ((props & 0x400000) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public Expression unordered(boolean retainAllNodes, boolean forStreaming) throws XPathException {
        for (int i = 0; i < this.size(); ++i) {
            this.setAction(i, this.getAction(i).unordered(retainAllNodes, forStreaming));
        }
        return this;
    }

    @Override
    public void checkPermittedContents(SchemaType parentType, boolean whole) throws XPathException {
        for (Operand action : this.actions()) {
            action.getChildExpression().checkPermittedContents(parentType, whole);
        }
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        for (Operand condition : this.conditions()) {
            condition.getChildExpression().addToPathMap(pathMap, pathMapNodeSet);
        }
        PathMap.PathMapNodeSet result2 = new PathMap.PathMapNodeSet();
        for (Operand action : this.actions()) {
            PathMap.PathMapNodeSet temp = action.getChildExpression().addToPathMap(pathMap, pathMapNodeSet);
            result2.addNodeSet(temp);
        }
        return result2;
    }

    @Override
    public String toString() {
        FastStringBuffer sb = new FastStringBuffer(64);
        sb.append("if (");
        for (int i = 0; i < this.size(); ++i) {
            sb.append(this.getCondition(i).toString());
            sb.append(") then (");
            sb.append(this.getAction(i).toString());
            if (i == this.size() - 1) {
                sb.append(")");
                continue;
            }
            sb.append(") else if (");
        }
        return sb.toString();
    }

    @Override
    public String toShortString() {
        return "if(" + this.getCondition(0).toShortString() + ") then ... else ...";
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("choose", this);
        for (int i = 0; i < this.size(); ++i) {
            this.getCondition(i).export(out);
            this.getAction(i).export(out);
        }
        out.endElement();
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        int i = this.choose(context);
        if (i >= 0) {
            if (this.getAction(i) instanceof TailCallReturner) {
                return ((TailCallReturner)((Object)this.getAction(i))).processLeavingTail(context);
            }
            this.getAction(i).process(context);
            return null;
        }
        return null;
    }

    private int choose(XPathContext context) throws XPathException {
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            boolean b;
            try {
                b = this.getCondition(i).effectiveBooleanValue(context);
            }
            catch (XPathException e) {
                e.maybeSetLocation(this.getCondition(i).getLocation());
                throw e;
            }
            if (!b) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        int i = this.choose(context);
        return i < 0 ? null : this.getAction(i).evaluateItem(context);
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        int i = this.choose(context);
        return i < 0 ? EmptyIterator.emptyIterator() : this.getAction(i).iterate(context);
    }

    @Override
    public void evaluatePendingUpdates(XPathContext context, PendingUpdateList pul) throws XPathException {
        int i = this.choose(context);
        if (i >= 0) {
            this.getAction(i).evaluatePendingUpdates(context, pul);
        }
    }

    @Override
    public String getExpressionName() {
        return "choose";
    }

    @Override
    public String getStreamerName() {
        return "Choose";
    }
}

