/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.DummyNamespaceResolver;
import net.sf.saxon.expr.instruct.SimpleNodeConstructor;
import net.sf.saxon.expr.instruct.ValidatingInstruction;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.Whitespace;

public abstract class AttributeCreator
extends SimpleNodeConstructor
implements ValidatingInstruction {
    SimpleType schemaType = null;
    private int validationAction;
    private int options;
    private boolean isInstruction;

    public void setInstruction(boolean inst) {
        this.isInstruction = inst;
    }

    public boolean isInstruction() {
        return this.isInstruction;
    }

    public void setSchemaType(SimpleType type) {
        this.schemaType = type;
    }

    public SimpleType getSchemaType() {
        return this.schemaType;
    }

    public void setValidationAction(int action) {
        this.validationAction = action;
    }

    public int getValidationAction() {
        return this.validationAction;
    }

    public void setOptions(int options) {
        this.options = options;
    }

    public void setRejectDuplicates() {
        this.options |= 0x20;
    }

    public void setNoSpecialChars() {
        this.options |= 4;
    }

    public int getOptions() {
        return this.options;
    }

    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        if (this.getValidationAction() == 4) {
            p |= 0x4000000;
        }
        return p;
    }

    public ItemType getItemType() {
        return NodeKindTest.ATTRIBUTE;
    }

    public void processValue(CharSequence value2, XPathContext context) throws XPathException {
        SimpleType ann;
        NodeName attName = this.evaluateNodeName(context);
        SequenceReceiver out = context.getReceiver();
        int opt2 = this.getOptions();
        SimpleType schemaType = this.getSchemaType();
        int validationAction = this.getValidationAction();
        if (schemaType != null) {
            ann = schemaType;
            ValidationFailure err2 = schemaType.validateContent(value2, DummyNamespaceResolver.getInstance(), context.getConfiguration().getConversionRules());
            if (err2 != null) {
                ValidationFailure ve = new ValidationFailure("Attribute value " + Err.wrap(value2, 4) + " does not match the required type " + schemaType.getDescription() + ". " + err2.getMessage());
                ve.setSchemaType(schemaType);
                ve.setErrorCode("XTTE1540");
                throw ve.makeException();
            }
        } else if (validationAction == 1 || validationAction == 2) {
            try {
                Configuration config = context.getConfiguration();
                ann = config.validateAttribute(attName.getStructuredQName(), value2, validationAction);
            }
            catch (ValidationException e) {
                XPathException err3 = XPathException.makeXPathException(e);
                err3.maybeSetErrorCode(validationAction == 1 ? "XTTE1510" : "XTTE1515");
                err3.setXPathContext(context);
                err3.maybeSetLocation(this.getLocation());
                err3.setIsTypeError(true);
                throw err3;
            }
        } else {
            ann = BuiltInAtomicType.UNTYPED_ATOMIC;
        }
        if (attName.equals(StandardNames.XML_ID_NAME)) {
            value2 = Whitespace.collapseWhitespace(value2);
        }
        try {
            out.attribute(attName, ann, value2, this.getLocation(), opt2);
        }
        catch (XPathException err4) {
            throw AttributeCreator.dynamicError(this.getLocation(), err4, context);
        }
    }

    protected void validateOrphanAttribute(Orphan orphan, XPathContext context) throws XPathException {
        ConversionRules rules = context.getConfiguration().getConversionRules();
        SimpleType schemaType = this.getSchemaType();
        int validationAction = this.getValidationAction();
        if (schemaType != null) {
            ValidationFailure err2 = schemaType.validateContent(orphan.getStringValueCS(), DummyNamespaceResolver.getInstance(), rules);
            if (err2 != null) {
                err2.setMessage("Attribute value " + Err.wrap(orphan.getStringValueCS(), 4) + " does not the match the required type " + schemaType.getDescription() + ". " + err2.getMessage());
                err2.setErrorCode("XTTE1555");
                err2.setLocator(this.getLocation());
                throw err2.makeException();
            }
            orphan.setTypeAnnotation(schemaType);
            if (schemaType.isNamespaceSensitive()) {
                throw new XPathException("Cannot validate a parentless attribute whose content is namespace-sensitive", "XTTE1545");
            }
        } else if (validationAction == 1 || validationAction == 2) {
            try {
                Controller controller = context.getController();
                assert (controller != null);
                SimpleType ann = controller.getConfiguration().validateAttribute(NameOfNode.makeName(orphan).getStructuredQName(), orphan.getStringValueCS(), validationAction);
                orphan.setTypeAnnotation(ann);
            }
            catch (ValidationException e) {
                XPathException err3 = XPathException.makeXPathException(e);
                err3.setErrorCodeQName(e.getErrorCodeQName());
                err3.setXPathContext(context);
                err3.setLocation(this.getLocation());
                err3.setIsTypeError(true);
                throw err3;
            }
        }
    }
}

