/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.flwor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.GroupByClause;
import net.sf.saxon.expr.flwor.Tuple;
import net.sf.saxon.expr.flwor.TupleExpression;
import net.sf.saxon.expr.flwor.TuplePush;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;

public class GroupByClausePush
extends TuplePush {
    private TuplePush destination;
    private GroupByClause groupByClause;
    private HashMap<Object, List<GroupByClause.ObjectToBeGrouped>> map = new HashMap();
    private XPathContext context;
    private GenericAtomicComparer[] comparers;

    public GroupByClausePush(TuplePush destination, GroupByClause groupBy2, XPathContext context) {
        this.destination = destination;
        this.groupByClause = groupBy2;
        this.context = context;
        this.comparers = new GenericAtomicComparer[groupBy2.comparers.length];
        for (int i = 0; i < this.comparers.length; ++i) {
            this.comparers[i] = groupBy2.comparers[i].provideContext(context);
        }
    }

    public void processTuple(XPathContext context) throws XPathException {
        TupleExpression groupingTupleExpr = this.groupByClause.getGroupingTupleExpression();
        TupleExpression retainedTupleExpr = this.groupByClause.getRetainedTupleExpression();
        GroupByClause.ObjectToBeGrouped otbg = new GroupByClause.ObjectToBeGrouped();
        Sequence[] groupingValues = groupingTupleExpr.evaluateItem(context).getMembers();
        for (int i = 0; i < groupingValues.length; ++i) {
            Sequence v = groupingValues[i];
            if (v instanceof EmptySequence || v instanceof AtomicValue) continue;
            if (SequenceTool.getLength(v = SequenceExtent.makeSequenceExtent(Atomizer.getAtomizingIterator(v.iterate(), false))) > 1) {
                throw new XPathException("Grouping key value cannot be a sequence of more than one item", "XPTY0004");
            }
            groupingValues[i] = v;
        }
        otbg.groupingValues = new Tuple(groupingValues);
        otbg.retainedValues = retainedTupleExpr.evaluateItem(context);
        GroupByClause.TupleComparisonKey key = this.groupByClause.getComparisonKey(otbg.groupingValues, this.comparers);
        List<GroupByClause.ObjectToBeGrouped> group = this.map.get(key);
        if (group != null) {
            group.add(otbg);
            this.map.put(key, group);
        } else {
            ArrayList<GroupByClause.ObjectToBeGrouped> list2 = new ArrayList<GroupByClause.ObjectToBeGrouped>();
            list2.add(otbg);
            this.map.put(key, list2);
        }
    }

    public void close() throws XPathException {
        for (List<GroupByClause.ObjectToBeGrouped> group : this.map.values()) {
            this.groupByClause.processGroup(group, this.context);
            this.destination.processTuple(this.context);
        }
        this.destination.close();
    }
}

