/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.accum;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.accum.Accumulator;
import net.sf.saxon.expr.accum.AccumulatorData;
import net.sf.saxon.expr.accum.FailedAccumulatorData;
import net.sf.saxon.expr.accum.IAccumulatorData;
import net.sf.saxon.expr.accum.PathMappedAccumulatorData;
import net.sf.saxon.expr.accum.VirtualAccumulatorData;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.tree.wrapper.VirtualCopy;
import net.sf.saxon.tree.wrapper.VirtualTreeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccumulatorManager {
    private transient WeakHashMap<TreeInfo, Map<Accumulator, IAccumulatorData>> accumulatorDataIndex = new WeakHashMap();
    private transient WeakHashMap<TreeInfo, Set<? extends Accumulator>> applicableAccumulators = new WeakHashMap();
    private static AccumulatorData MARKER = new AccumulatorData(null);

    public void setApplicableAccumulators(TreeInfo tree, Set<? extends Accumulator> accumulators) {
        this.applicableAccumulators.put(tree, accumulators);
    }

    public boolean isApplicable(TreeInfo tree, Accumulator accumulator) {
        Set<? extends Accumulator> accSet = this.applicableAccumulators.get(tree);
        return accSet == null || accSet.contains(accumulator);
    }

    public synchronized IAccumulatorData getAccumulatorData(TreeInfo doc, Accumulator acc, XPathContext context) throws XPathException {
        Object original;
        Map<Accumulator, IAccumulatorData> map2 = this.accumulatorDataIndex.get(doc);
        if (map2 != null) {
            IAccumulatorData data2 = map2.get(acc);
            if (data2 != null) {
                if (data2 == MARKER) {
                    throw new XPathException("Accumulator " + acc.getAccumulatorName().getDisplayName() + " requires access to its own value", "XTDE3400");
                }
                return data2;
            }
        } else {
            map2 = new HashMap<Accumulator, IAccumulatorData>();
            map2.put(acc, MARKER);
            this.accumulatorDataIndex.put(doc, map2);
        }
        if (doc instanceof VirtualTreeInfo && ((VirtualTreeInfo)doc).isCopyAccumulators()) {
            original = ((VirtualCopy)doc.getRootNode()).getOriginalNode();
            IAccumulatorData originalData = this.getAccumulatorData(original.getTreeInfo(), acc, context);
            VirtualAccumulatorData vad = new VirtualAccumulatorData(originalData);
            map2.put(acc, vad);
            return vad;
        }
        if (doc instanceof TinyTree && ((TinyTree)doc).getCopiedFrom() != null) {
            original = this.getAccumulatorData(((TinyTree)doc).getCopiedFrom().getTreeInfo(), acc, context);
            return new PathMappedAccumulatorData((IAccumulatorData)original, ((TinyTree)doc).getCopiedFrom());
        }
        AccumulatorData d = new AccumulatorData(acc);
        XPathContextMajor c2 = context.newCleanContext();
        c2.setCurrentComponent(acc.getDeclaringComponent());
        try {
            d.buildIndex(doc.getRootNode(), c2);
            map2.put(acc, d);
            return d;
        }
        catch (XPathException err2) {
            FailedAccumulatorData failed2 = new FailedAccumulatorData(acc, err2);
            map2.put(acc, failed2);
            return failed2;
        }
    }

    public synchronized void addAccumulatorData(TreeInfo doc, Accumulator acc, IAccumulatorData accData) {
        Map<Accumulator, IAccumulatorData> map2 = this.accumulatorDataIndex.get(doc);
        if (map2 != null) {
            IAccumulatorData data2 = map2.get(acc);
            if (data2 != null) {
                return;
            }
        } else {
            map2 = new HashMap<Accumulator, IAccumulatorData>();
            this.accumulatorDataIndex.put(doc, map2);
        }
        map2.put(acc, accData);
    }
}

