/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.BigRangeIterator;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.ReverseRangeIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.ReversibleIterator;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.IntegerValue;

public class RangeIterator
implements AtomicIterator,
ReversibleIterator,
LastPositionFinder,
LookaheadIterator,
GroundedIterator {
    long start;
    long currentValue;
    long limit;

    public static SequenceIterator makeRangeIterator(IntegerValue start, IntegerValue end) throws XPathException {
        if (start == null || end == null) {
            return EmptyIterator.getInstance();
        }
        if (start.compareTo(end) > 0) {
            return EmptyIterator.getInstance();
        }
        if (start instanceof BigIntegerValue || end instanceof BigIntegerValue) {
            return new BigRangeIterator(start.asBigInteger(), end.asBigInteger());
        }
        long startVal = start.longValue();
        long endVal = end.longValue();
        if (endVal - startVal > Integer.MAX_VALUE) {
            throw new XPathException("Saxon limit on sequence length exceeded (2^31)", "XPDY0130");
        }
        return new RangeIterator(startVal, endVal);
    }

    public RangeIterator(long start, long end) {
        this.start = start;
        this.currentValue = start - 1L;
        this.limit = end;
    }

    public boolean hasNext() {
        return this.currentValue < this.limit;
    }

    public IntegerValue next() {
        if (++this.currentValue > this.limit) {
            return null;
        }
        return Int64Value.makeIntegerValue(this.currentValue);
    }

    public void close() {
    }

    public int getLength() {
        return (int)(this.limit - this.start + 1L);
    }

    public int getProperties() {
        return 7;
    }

    public SequenceIterator getReverseIterator() {
        try {
            return new ReverseRangeIterator(this.limit, this.start);
        }
        catch (XPathException err2) {
            throw new AssertionError((Object)err2);
        }
    }

    public GroundedValue materialize() {
        return new IntegerRange(this.start, this.limit);
    }

    public GroundedValue getResidue() throws XPathException {
        return new IntegerRange(this.currentValue, this.limit);
    }
}

