/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.AndExpression;
import net.sf.saxon.expr.BooleanExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;

public class OrExpression
extends BooleanExpression {
    public OrExpression(Expression p1, Expression p2) {
        super(p1, 9, p2);
    }

    protected Expression preEvaluate() {
        if (Literal.hasEffectiveBooleanValue(this.getLhsExpression(), true) || Literal.hasEffectiveBooleanValue(this.getRhsExpression(), true)) {
            return Literal.makeLiteral(BooleanValue.TRUE);
        }
        if (Literal.hasEffectiveBooleanValue(this.getLhsExpression(), false)) {
            return this.forceToBoolean(this.getRhsExpression());
        }
        if (Literal.hasEffectiveBooleanValue(this.getRhsExpression(), false)) {
            return this.forceToBoolean(this.getLhsExpression());
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        Expression e2;
        Expression e = super.optimize(visitor, contextItemType);
        if (e != this) {
            return e;
        }
        if (!(this.getParentExpression() instanceof OrExpression) && (e2 = visitor.getConfiguration().obtainOptimizer().tryGeneralComparison(visitor, contextItemType, this)) != null && e2 != this) {
            return e2;
        }
        return this;
    }

    public int getCost() {
        return this.getLhsExpression().getCost() + this.getRhsExpression().getCost() / 2;
    }

    public Expression copy(RebindingMap rebindings) {
        OrExpression exp = new OrExpression(this.getLhsExpression().copy(rebindings), this.getRhsExpression().copy(rebindings));
        ExpressionTool.copyLocationInfo(this, exp);
        return exp;
    }

    public Expression negate() {
        Expression not0 = SystemFunction.makeCall("not", this.getRetainedStaticContext(), this.getLhsExpression());
        Expression not1 = SystemFunction.makeCall("not", this.getRetainedStaticContext(), this.getRhsExpression());
        AndExpression result2 = new AndExpression(not0, not1);
        ExpressionTool.copyLocationInfo(this, result2);
        return result2;
    }

    protected String tag() {
        return "or";
    }

    public boolean effectiveBooleanValue(XPathContext c) throws XPathException {
        return this.getLhsExpression().effectiveBooleanValue(c) || this.getRhsExpression().effectiveBooleanValue(c);
    }
}

