/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.QualifiedNameValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Literal
extends Expression {
    private GroundedValue value;

    protected Literal(GroundedValue value2) {
        this.value = value2.reduce();
    }

    public static Literal makeStringsLiteral(List<String> strings) {
        ArrayList<StringValue> values = new ArrayList<StringValue>();
        for (String s2 : strings) {
            values.add(new StringValue(s2));
        }
        GroundedValue gv = SequenceExtent.makeSequenceExtent(values);
        return Literal.makeLiteral(gv);
    }

    public GroundedValue getValue() {
        return this.value;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        return this;
    }

    @Override
    public int getNetCost() {
        return 0;
    }

    @Override
    public ItemType getItemType() {
        if (this.value instanceof AtomicValue) {
            return ((AtomicValue)this.value).getItemType();
        }
        if (this.value.getLength() == 0) {
            return ErrorType.getInstance();
        }
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        return SequenceTool.getItemType(this.value, th);
    }

    @Override
    public UType getStaticUType(UType contextItemType) {
        if (this.value.getLength() == 0) {
            return UType.VOID;
        }
        if (this.value instanceof AtomicValue) {
            return ((AtomicValue)this.value).getUType();
        }
        if (this.value instanceof Function) {
            return UType.FUNCTION;
        }
        return super.getStaticUType(contextItemType);
    }

    @Override
    public int computeCardinality() {
        if (this.value.getLength() == 0) {
            return 8192;
        }
        if (this.value instanceof AtomicValue) {
            return 16384;
        }
        try {
            UnfailingIterator iter2 = this.value.iterate();
            Item next2 = iter2.next();
            if (next2 == null) {
                return 8192;
            }
            if (iter2.next() != null) {
                return 49152;
            }
            return 16384;
        }
        catch (XPathException err2) {
            return 57344;
        }
    }

    @Override
    public int computeSpecialProperties() {
        if (this.value.getLength() == 0) {
            return 0xEFF0000;
        }
        return 0x400000;
    }

    @Override
    public IntegerValue[] getIntegerBounds() {
        if (this.value instanceof IntegerValue) {
            return new IntegerValue[]{(IntegerValue)this.value, (IntegerValue)this.value};
        }
        if (this.value instanceof IntegerRange) {
            return new IntegerValue[]{Int64Value.makeIntegerValue(((IntegerRange)this.value).getStart()), Int64Value.makeIntegerValue(((IntegerRange)this.value).getEnd())};
        }
        return null;
    }

    @Override
    public boolean isVacuousExpression() {
        return this.value.getLength() == 0;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        Literal l2 = new Literal(this.value);
        ExpressionTool.copyLocationInfo(this, l2);
        return l2;
    }

    @Override
    public Pattern toPattern(Configuration config, boolean is30) throws XPathException {
        if (Literal.isEmptySequence(this)) {
            return new NodeTestPattern(ErrorType.getInstance());
        }
        return super.toPattern(config, is30);
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        return pathMapNodeSet;
    }

    @Override
    public final int getDependencies() {
        return 0;
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return this.value.iterate();
    }

    public SequenceIterator iterate() throws XPathException {
        return this.value.iterate();
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        return this.value.head();
    }

    @Override
    public void process(XPathContext context) throws XPathException {
        SequenceReceiver out = context.getReceiver();
        if (this.value instanceof Item) {
            out.append((Item)((Object)this.value), this.getLocation(), 2);
        } else {
            Item it;
            UnfailingIterator iter2 = this.value.iterate();
            while ((it = iter2.next()) != null) {
                out.append(it, this.getLocation(), 2);
            }
        }
    }

    @Override
    public int getImplementationMethod() {
        return 7;
    }

    @Override
    public CharSequence evaluateAsString(XPathContext context) throws XPathException {
        AtomicValue value2 = (AtomicValue)this.evaluateItem(context);
        if (value2 == null) {
            return "";
        }
        return value2.getStringValueCS();
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        return this.value.effectiveBooleanValue();
    }

    @Override
    public void evaluatePendingUpdates(XPathContext context, PendingUpdateList pul) throws XPathException {
        if (this.value.getLength() != 0) {
            super.evaluatePendingUpdates(context, pul);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Literal)) {
            return false;
        }
        GroundedValue v0 = this.value;
        GroundedValue v1 = ((Literal)obj).value;
        try {
            block9: {
                UnfailingIterator i0 = v0.iterate();
                UnfailingIterator i1 = v1.iterate();
                while (true) {
                    Item m0 = i0.next();
                    Item m1 = i1.next();
                    if (m0 == null && m1 == null) {
                        return true;
                    }
                    if (m0 == null || m1 == null) {
                        return false;
                    }
                    if (m0 == m1) continue;
                    boolean n0 = m0 instanceof NodeInfo;
                    boolean n1 = m1 instanceof NodeInfo;
                    if (n0 != n1) {
                        return false;
                    }
                    if (n0) {
                        if (((NodeInfo)m0).isSameNodeInfo((NodeInfo)m1)) continue;
                        return false;
                    }
                    boolean a0 = m0 instanceof AtomicValue;
                    boolean a1 = m1 instanceof AtomicValue;
                    if (a0 != a1) {
                        return false;
                    }
                    if (!a0) break block9;
                    if (!((AtomicValue)m0).isIdentical((AtomicValue)m1) || ((AtomicValue)m0).getItemType() != ((AtomicValue)m1).getItemType()) break;
                }
                return false;
            }
            return false;
        }
        catch (XPathException err2) {
            return false;
        }
    }

    public int hashCode() {
        if (this.value instanceof AtomicSequence) {
            return ((AtomicSequence)this.value).getSchemaComparable().hashCode();
        }
        return super.hashCode();
    }

    @Override
    public String toString() {
        return this.value.toString();
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        Literal.exportValue(this.value, out);
    }

    public static void exportValue(Sequence value2, ExpressionPresenter out) throws XPathException {
        if (value2.head() == null) {
            out.startElement("empty");
            out.endElement();
        } else if (value2 instanceof AtomicValue) {
            Literal.exportAtomicValue((AtomicValue)value2, out);
        } else if (value2 instanceof IntegerRange) {
            out.startElement("range");
            out.emitAttribute("from", "" + ((IntegerRange)value2).getStart());
            out.emitAttribute("to", "" + ((IntegerRange)value2).getEnd());
            out.endElement();
        } else if (value2 instanceof NodeInfo) {
            out.startElement("node");
            out.emitAttribute("kind", ((NodeInfo)value2).getNodeKind() + "");
            out.emitAttribute("baseUri", ((NodeInfo)value2).getBaseURI());
            String ser = QueryResult.serialize((NodeInfo)value2);
            out.emitAttribute("content", ser);
            out.endElement();
        } else if (value2 instanceof MapItem) {
            out.startElement("map");
            out.emitAttribute("size", "" + ((MapItem)value2).size());
            for (KeyValuePair kvp : (MapItem)value2) {
                Literal.exportAtomicValue(kvp.key, out);
                Literal.exportValue(kvp.value, out);
            }
            out.endElement();
        } else if (value2 instanceof Function) {
            ((Function)value2).export(out);
        } else if (value2 instanceof ObjectValue) {
            out.startElement("externalObject");
            out.emitAttribute("class", ((ObjectValue)value2).getObject().getClass().getName());
            out.endElement();
        } else {
            Item it;
            out.startElement("literal");
            if (value2 instanceof GroundedValue) {
                out.emitAttribute("count", ((GroundedValue)value2).getLength() + "");
            }
            SequenceIterator iter2 = value2.iterate();
            while ((it = iter2.next()) != null) {
                Literal.exportValue(it, out);
            }
            out.endElement();
        }
    }

    @Override
    public String getExpressionName() {
        return "literal";
    }

    public static void exportAtomicValue(AtomicValue value2, ExpressionPresenter out) throws XPathException {
        if ("JS".equals(out.getOption("target"))) {
            value2.checkValidInJavascript();
        }
        AtomicType type = value2.getItemType();
        String val = value2.getStringValue();
        if (type.equals(BuiltInAtomicType.STRING)) {
            out.startElement("str");
            out.emitAttribute("val", val);
            out.endElement();
        } else if (type.equals(BuiltInAtomicType.INTEGER)) {
            out.startElement("int");
            out.emitAttribute("val", val);
            out.endElement();
        } else if (type.equals(BuiltInAtomicType.DECIMAL)) {
            out.startElement("dec");
            out.emitAttribute("val", val);
            out.endElement();
        } else if (type.equals(BuiltInAtomicType.DOUBLE)) {
            out.startElement("dbl");
            out.emitAttribute("val", val);
            out.endElement();
        } else if (type.equals(BuiltInAtomicType.BOOLEAN)) {
            out.startElement(((BooleanValue)value2).effectiveBooleanValue() ? "true" : "false");
            out.endElement();
        } else if (value2 instanceof QualifiedNameValue) {
            out.startElement("qName");
            out.emitAttribute("pre", ((QualifiedNameValue)value2).getPrefix());
            out.emitAttribute("uri", ((QualifiedNameValue)value2).getNamespaceURI());
            out.emitAttribute("loc", ((QualifiedNameValue)value2).getLocalName());
            if (!type.equals(BuiltInAtomicType.QNAME)) {
                out.emitAttribute("type", type.getTypeName());
            }
            out.endElement();
        } else {
            out.startElement("atomic");
            out.emitAttribute("val", val);
            out.emitAttribute("type", type.getTypeName());
            out.endElement();
        }
    }

    @Override
    public String toShortString() {
        if (this.value.getLength() == 0) {
            return "()";
        }
        if (this.value instanceof AtomicValue) {
            return this.value.toString();
        }
        return "(" + this.value.head().toString() + ",...)";
    }

    public static boolean isAtomic(Expression exp) {
        return exp instanceof Literal && ((Literal)exp).getValue() instanceof AtomicValue;
    }

    public static boolean isEmptySequence(Expression exp) {
        return exp instanceof Literal && ((Literal)exp).getValue().getLength() == 0;
    }

    public static boolean isConstantBoolean(Expression exp, boolean value2) {
        if (exp instanceof Literal) {
            GroundedValue b = ((Literal)exp).getValue();
            return b instanceof BooleanValue && ((BooleanValue)b).getBooleanValue() == value2;
        }
        return false;
    }

    public static boolean hasEffectiveBooleanValue(Expression exp, boolean value2) {
        if (exp instanceof Literal) {
            try {
                return value2 == ((Literal)exp).getValue().effectiveBooleanValue();
            }
            catch (XPathException err2) {
                return false;
            }
        }
        return false;
    }

    public static boolean isConstantOne(Expression exp) {
        if (exp instanceof Literal) {
            GroundedValue v = ((Literal)exp).getValue();
            return v instanceof Int64Value && ((Int64Value)v).longValue() == 1L;
        }
        return false;
    }

    @Override
    public boolean isSubtreeExpression() {
        return true;
    }

    public static Literal makeEmptySequence() {
        return new Literal(EmptySequence.getInstance());
    }

    public static Literal makeLiteral(GroundedValue value2) {
        if ((value2 = value2.reduce()) instanceof StringValue) {
            return new StringLiteral((StringValue)value2);
        }
        return new Literal(value2);
    }

    public static Literal makeLiteral(GroundedValue value2, Expression origin) {
        Literal lit = Literal.makeLiteral(value2);
        lit.setRetainedStaticContext(origin.getRetainedStaticContext());
        ExpressionTool.copyLocationInfo(origin, lit);
        return lit;
    }

    @Override
    public String getStreamerName() {
        return "Literal";
    }
}

