/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Converter;

public abstract class CastingExpression
extends UnaryExpression {
    private AtomicType targetType;
    private AtomicType targetPrimitiveType;
    private boolean allowEmpty = false;
    protected Converter converter;
    private boolean operandIsStringLiteral = false;

    public CastingExpression(Expression source, AtomicType target, boolean allowEmpty) {
        super(source);
        this.allowEmpty = allowEmpty;
        this.targetType = target;
        this.targetPrimitiveType = target.getPrimitiveItemType();
    }

    public AtomicType getTargetPrimitiveType() {
        return this.targetPrimitiveType;
    }

    public void setTargetType(AtomicType type) {
        this.targetType = type;
    }

    public AtomicType getTargetType() {
        return this.targetType;
    }

    protected OperandRole getOperandRole() {
        return OperandRole.SINGLE_ATOMIC;
    }

    public void setAllowEmpty(boolean allow) {
        this.allowEmpty = allow;
    }

    public boolean allowsEmpty() {
        return this.allowEmpty;
    }

    public void setOperandIsStringLiteral(boolean option) {
        this.operandIsStringLiteral = option;
    }

    public boolean isOperandIsStringLiteral() {
        return this.operandIsStringLiteral;
    }

    public Converter getConverter() {
        return this.converter;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.getRetainedStaticContext();
    }

    public Expression simplify() throws XPathException {
        String s2;
        if (this.targetType instanceof BuiltInAtomicType && (s2 = XPathParser.whyDisallowedType(this.getPackageData(), (BuiltInAtomicType)this.targetType)) != null) {
            XPathException err2 = new XPathException(s2, "XPST0080", this.getLocation());
            err2.setIsStaticError(true);
            throw err2;
        }
        this.setBaseExpression(this.getBaseExpression().simplify());
        return this;
    }

    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p | 0x400000;
    }
}

