/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.CastingExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.UType;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;

public final class CastableExpression
extends CastingExpression {
    public CastableExpression(Expression source, AtomicType target, boolean allowEmpty) {
        super(source, target, allowEmpty);
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.typeCheckChildren(visitor, contextInfo);
        Expression operand = this.getBaseExpression();
        ItemType sourceItemType = operand.getItemType();
        AtomicType atomizedType = sourceItemType.getAtomizedItemType().getPrimitiveItemType();
        if (atomizedType != BuiltInAtomicType.ANY_ATOMIC) {
            this.converter = visitor.getConfiguration().getConversionRules().getConverter(atomizedType, this.getTargetType());
            if (this.converter == null) {
                if (!this.allowsEmpty() || !Cardinality.allowsZero(operand.getCardinality())) {
                    return Literal.makeLiteral(BooleanValue.FALSE);
                }
            } else {
                if (this.getTargetPrimitiveType().isNamespaceSensitive()) {
                    this.converter = this.converter.setNamespaceResolver(this.getRetainedStaticContext());
                }
                if (this.converter.isAlwaysSuccessful() && !this.allowsEmpty() && operand.getCardinality() == 16384) {
                    return Literal.makeLiteral(BooleanValue.TRUE);
                }
            }
        }
        this.setBaseExpression(operand);
        if (operand instanceof Literal) {
            return this.preEvaluate();
        }
        return this;
    }

    protected Expression preEvaluate() throws XPathException {
        GroundedValue literalOperand = ((Literal)this.getBaseExpression()).getValue();
        if (literalOperand instanceof AtomicValue && this.converter != null) {
            ConversionResult result2 = this.converter.convert((AtomicValue)literalOperand);
            return Literal.makeLiteral(BooleanValue.get(!(result2 instanceof ValidationFailure)));
        }
        int length = literalOperand.getLength();
        if (length == 0) {
            return Literal.makeLiteral(BooleanValue.get(this.allowsEmpty()));
        }
        if (length > 1) {
            return Literal.makeLiteral(BooleanValue.FALSE);
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.optimizeChildren(visitor, contextInfo);
        if (this.getBaseExpression() instanceof Literal) {
            return this.preEvaluate();
        }
        return this;
    }

    public int getImplementationMethod() {
        return 1;
    }

    public boolean equals(Object other) {
        return other instanceof CastableExpression && this.getBaseExpression().equals(((CastableExpression)other).getBaseExpression()) && this.getTargetType() == ((CastableExpression)other).getTargetType() && this.allowsEmpty() == ((CastableExpression)other).allowsEmpty();
    }

    public int hashCode() {
        return super.hashCode() ^ 0x5555;
    }

    public ItemType getItemType() {
        return BuiltInAtomicType.BOOLEAN;
    }

    public UType getStaticUType(UType contextItemType) {
        return UType.BOOLEAN;
    }

    public int computeCardinality() {
        return 16384;
    }

    public Expression copy(RebindingMap rebindings) {
        CastableExpression ce = new CastableExpression(this.getBaseExpression().copy(rebindings), this.getTargetType(), this.allowsEmpty());
        ExpressionTool.copyLocationInfo(this, ce);
        ce.setRetainedStaticContext(this.getRetainedStaticContext());
        ce.converter = this.converter;
        return ce;
    }

    public BooleanValue evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        Item item;
        int count2 = 0;
        SequenceIterator iter2 = this.getBaseExpression().iterate(context);
        while ((item = iter2.next()) != null) {
            if (item instanceof NodeInfo) {
                AtomicValue av;
                AtomicSequence atomizedValue = item.atomize();
                int length = SequenceTool.getLength(atomizedValue);
                if ((count2 += length) > 1) {
                    return false;
                }
                if (length == 0 || this.isCastable(av = atomizedValue.head(), this.getTargetType(), context)) continue;
                return false;
            }
            if (item instanceof AtomicValue) {
                AtomicValue av = (AtomicValue)item;
                if (++count2 > 1) {
                    return false;
                }
                if (this.isCastable(av, this.getTargetType(), context)) continue;
                return false;
            }
            throw new XPathException("Input to cast cannot be atomized", "XPTY0004");
        }
        return count2 != 0 || this.allowsEmpty();
    }

    private boolean isCastable(AtomicValue value2, AtomicType targetType, XPathContext context) {
        Converter converter = this.converter;
        if (converter == null) {
            converter = context.getConfiguration().getConversionRules().getConverter(value2.getPrimitiveType(), targetType);
            if (converter == null) {
                return false;
            }
            if (converter.isAlwaysSuccessful()) {
                return true;
            }
            if (this.getTargetType().isNamespaceSensitive()) {
                converter = converter.setNamespaceResolver(this.getRetainedStaticContext());
            }
        }
        return !(converter.convert(value2) instanceof ValidationFailure);
    }

    public String getExpressionName() {
        return "castable";
    }

    public String toString() {
        return this.getBaseExpression().toString() + " castable as " + this.getTargetType().getEQName();
    }

    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("castable", this);
        out.emitAttribute("as", this.getTargetType().getTypeName());
        out.emitAttribute("emptiable", this.allowsEmpty() ? "1" : "0");
        this.getBaseExpression().export(out);
        out.endElement();
    }
}

